/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.msp.device;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.MspSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.device.api.openapi.AdoptDeviceOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.MspKnownDeviceOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.MspUnknownDeviceOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.BatchAdoptDeviceOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.TagRespOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="MSP Device")
@RestController
@b(a=31)
@Conditional(value={MspSwaggerMatchCondition.class})
public class MspDeviceOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MspDeviceOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get MSP known device list", description="Get MSP known device list")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/devices/known-devices"})
    @a(a=1)
    @com.tplink.smb.omada.common.m.a(b={k.MSP_DEVICES_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<MspKnownDeviceOpenApiVO>>> getMspKnownDeviceList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchMacs", description="Fuzzy query parameters, support field mac") @RequestParam(name="searchMacs", required=false) String searchMac, @Parameter(name="searchNames", description="Fuzzy query parameters, support field name") @RequestParam(name="searchNames", required=false) String searchName, @Parameter(name="searchModels", description="Fuzzy query parameters, support field model") @RequestParam(name="searchModels", required=false) String searchModel, @Parameter(name="searchSns", description="Fuzzy query parameters, support field sn") @RequestParam(name="searchSns", required=false) String searchSn, @Parameter(name="filters.tag", description="Filter query parameters, support field tag ID") @RequestParam(name="filters.tag", required=false) String filterTagId, @Parameter(name="filters.deviceSeriesType", description="Filter query parameters, support field Device series type. 0: basic; 1: pro.") @RequestParam(name="filters.deviceSeriesType", required=false) String deviceSeriesType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Get MSP unknown device list", description="Get MSP unknown device list")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/devices/unknown-devices"})
    @a(a=2)
    @com.tplink.smb.omada.common.m.a(b={k.MSP_DEVICES_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<MspUnknownDeviceOpenApiVO>>> getMspUnknownDeviceList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchMacs", description="Fuzzy query parameters, support field mac") @RequestParam(name="searchMacs", required=false) String searchMac, @Parameter(name="searchNames", description="Fuzzy query parameters, support field name") @RequestParam(name="searchNames", required=false) String searchName, @Parameter(name="searchModels", description="Fuzzy query parameters, support field model") @RequestParam(name="searchModels", required=false) String searchModel, @Parameter(name="filters.deviceSeriesType", description="Filter query parameters, support field Device series type. 0: basic; 1: pro.") @RequestParam(name="filters.deviceSeriesType", required=false) String deviceSeriesType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Get tag list", description="Get tag list.")
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_READ, k.MSP_DEVICES_READ, k.MAP_READ})
    @GetMapping(value={"/openapi/v1/msp/{mspId}/devices/tag"})
    @a(a=3)
    @ResponseBody
    public DeferredResult<OperationResponse<List<TagRespOpenApiVO>>> getTags(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Start adopt device For Msp", description="Start adopt device in msp view.This interface does not return the actual adoptive result, you need to use the interface:Get device adopt result to obtain the adoptive result")
    @PostMapping(value={"/openapi/v1/msp/{mspId}/customers/{customerId}/sites/{siteId}/devices/{deviceMac}/start-adopt"})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_ADOPT, k.MSP_ADD_ADOPT_DEVICE})
    @a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> adoptOneForMsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="customerId", description="Omada ID") @PathVariable(name="customerId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @RequestBody AdoptDeviceOpenApiVO adoptDeviceOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)adoptDeviceOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="batch adopt device in msp view", description="batch adopt device in msp view.This interface does not return the actual adoptive result,you need to use the interface:Get device adopt result to obtain the adoptive result")
    @com.tplink.smb.omada.common.m.a(b={k.MSP_ADOPT, k.MSP_ADD_ADOPT_DEVICE})
    @PostMapping(value={"/openapi/v1/msp/{mspId}/customers/{customerId}/sites/{siteId}/cmd/devices/batch-adopt"})
    @a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> batchAdoptForMsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="customerId", description="Omada ID") @PathVariable(name="customerId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody BatchAdoptDeviceOpenApiVO batchAdoptDeviceOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)batchAdoptDeviceOpenApiVO), request, response, omadacId);
    }
}

