/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.msp.account;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.MspSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.identityaccess.api.external.dto.BatchModifyCountVO;
import com.tplink.smb.omada.identityaccess.api.external.dto.DeleteUserVO;
import com.tplink.smb.omada.identityaccess.api.external.dto.GetUserListResponseVO;
import com.tplink.smb.omada.identityaccess.api.external.dto.MspUserVO;
import com.tplink.smb.omada.identityaccess.api.external.dto.openapi.CreateMspUserVO;
import com.tplink.smb.omada.identityaccess.api.external.dto.openapi.MspUserDetailVO;
import com.tplink.smb.omada.identityaccess.api.openapi.vo.BatchModifyUserOpenApiVO;
import com.tplink.smb.omada.identityaccess.api.openapi.vo.CreateUserResultVO;
import com.tplink.smb.omada.identityaccess.api.openapi.vo.MFAConfigOpenApiVO;
import com.tplink.smb.omada.identityaccess.api.openapi.vo.ModifyMspUserVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="MSP User and Role")
@RestController
@b(a=8)
@Conditional(value={MspSwaggerMatchCondition.class})
public class MspUserManagerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MspUserManagerController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get msp user list", description="Get msp user list. This interface only supports the authorization code mode, not the client mode. Please call this interface in authorization code mode.")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/users"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.OPEN_API_INTERFACE_ONLY_SUPPORT_CODE}, b={k.MSP_USERS_READ})
    @a(a=1)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<MspUserDetailVO>>> getGridUsers(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortsUserName, @Parameter(name="sorts.roleId", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.roleId", required=false) String sortsRoleId, @Parameter(name="sorts.email", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.email", required=false) String sortsEmail, @Parameter(name="sorts.customerRoleId", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.customerRoleId", required=false) String sortsCustomerRoleId, @Parameter(name="searchKey", description="Fuzzy query parameters, support field userName") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Get msp user info", description="Get msp user info. This interface only supports the authorization code mode, not the client mode. Please call this interface in authorization code mode.")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/users/{userID}"})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_USERS_READ})
    @a(a=2)
    @ResponseBody
    public DeferredResult<OperationResponse<MspUserDetailVO>> getUser(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="userId", description="User ID") @PathVariable(name="userID") String userId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Create new msp user", description="Create new msp user. This interface only supports the authorization code mode, not the client mode. Please call this interface in authorization code mode.")
    @PostMapping(value={"/openapi/v1/msp/{mspId}/users"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_USER_NAME, com.tplink.smb.omada.common.g.b.DUPLICATE_USER_NAME, com.tplink.smb.omada.common.g.b.INVALID_EMAIL, com.tplink.smb.omada.common.g.b.REACHED_MAX_USER_NUM, com.tplink.smb.omada.common.g.b.INVALID_PASSWORD, com.tplink.smb.omada.common.g.b.OPEN_API_INTERFACE_ONLY_SUPPORT_CODE}, b={k.MSP_USERS_WRITE})
    @a(a=3)
    @ResponseBody
    public DeferredResult<OperationResponse<CreateUserResultVO>> createNewMspUser(@RequestBody CreateMspUserVO user, HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)user), request, response, mspId);
    }

    @Operation(summary="Modify an existing msp user", description="Modify an existing msp user. This interface only supports the authorization code mode, not the client mode. Please call this interface in authorization code mode.")
    @RequestMapping(path={"/openapi/v1/msp/{mspId}/users/{userID}"}, method={RequestMethod.PUT})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_USER_NAME, com.tplink.smb.omada.common.g.b.DUPLICATE_USER_NAME, com.tplink.smb.omada.common.g.b.INVALID_EMAIL, com.tplink.smb.omada.common.g.b.MODIFY_ADMIN_DEGRADED_EXIST_CHILD, com.tplink.smb.omada.common.g.b.INVALID_PASSWORD, com.tplink.smb.omada.common.g.b.USER_NAME_NOT_EXIST, com.tplink.smb.omada.common.g.b.MODIFY_VIEWER_SCOPE_GTEATER_PARENT, com.tplink.smb.omada.common.g.b.MODIFY_VIEWER_SCOPE_GTEATER_MANAGER, com.tplink.smb.omada.common.g.b.MODIFY_ADMIN_SCOPE_SMALLER_CHILD, com.tplink.smb.omada.common.g.b.OPEN_API_INTERFACE_ONLY_SUPPORT_CODE}, b={k.MSP_USERS_WRITE})
    @a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponse> modifyMspUser(@RequestBody ModifyMspUserVO modifyUserVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="userId", description="User ID") @PathVariable(name="userID") String userId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyUserVO), request, response, mspId);
    }

    @Operation(summary="Delete an existing msp user", description="Delete an existing msp user. This interface only supports the authorization code mode, not the client mode. Please call this interface in authorization code mode.")
    @RequestMapping(path={"/openapi/v1/msp/{mspId}/users/{userID}"}, method={RequestMethod.DELETE})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.DELETE_USER_ERROR, com.tplink.smb.omada.common.g.b.DELETE_USER_EXIST_CHILD, com.tplink.smb.omada.common.g.b.DELETE_USER_NOT_EXIST, com.tplink.smb.omada.common.g.b.OPEN_API_INTERFACE_ONLY_SUPPORT_CODE}, b={k.MSP_USERS_WRITE})
    @a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponse> deleteMspUser(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="userId", description="User ID") @PathVariable(name="userID") String userId, @RequestBody DeleteUserVO deleteUserVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deleteUserVO), request, response, mspId);
    }

    @Operation(summary="Get all MSP local users exclude owner")
    @RequestMapping(path={"/openapi/v1/msp/{mspId}/users/local"}, method={RequestMethod.GET})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.USER_NOT_EXIST})
    @a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponse<GetUserListResponseVO>> getAllMspLocalUsersExcludeRoot(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get all MSP cloud users exclude owner")
    @RequestMapping(path={"/openapi/v1/msp/{mspId}/users/cloud"}, method={RequestMethod.GET})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.USER_NOT_EXIST})
    @a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponse<GetUserListResponseVO>> getAllMspCloudUsersExcludeRoot(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Batch modify MSP users.", description="Batch modify MSP users.")
    @RequestMapping(path={"/openapi/v1/msp/{mspId}/users/batch-temporary-users"}, method={RequestMethod.PATCH})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_USERS_WRITE})
    @a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponse<BatchModifyCountVO>> modifyMspUserBatch(@RequestBody BatchModifyUserOpenApiVO modifyUserVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyUserVO), request, response, mspId);
    }

    @Operation(summary="Get msp user list for app", description="Get msp user list. This interface only supports the authorization code mode, not the client mode. Please call this interface in authorization code mode.")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/all-users"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.OPEN_API_INTERFACE_ONLY_SUPPORT_CODE}, b={k.MSP_USERS_READ})
    @a(a=8)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<MspUserVO>>> getMspAppGridUsers(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortsUserName, @Parameter(name="sorts.roleId", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.roleId", required=false) String sortsRoleId, @Parameter(name="sorts.email", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.email", required=false) String sortsEmail, @Parameter(name="sorts.customerRoleId", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.customerRoleId", required=false) String sortsCustomerRoleId, @Parameter(name="searchKey", description="Fuzzy query parameters, support field userName") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Get the status of the MSP system's Two-Factor Authentication.", description="Get the status of the system's Two-Factor Authentication.")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/mfa/status"})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_SETTINGS_READ})
    @a(a=9)
    @ResponseBody
    public DeferredResult<OperationResponse<MFAConfigOpenApiVO>> getMFAStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Modify the status of the MSP system's Two-Factor Authentication.", description="Modify the status of the system's Two-Factor Authentication.")
    @PostMapping(value={"/openapi/v1/msp/{mspId}/mfa/status"})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_SETTINGS_WRITE})
    @a(a=10)
    @ResponseBody
    public DeferredResult<OperationResponse> modifyMspMFAStatus(@RequestBody MFAConfigOpenApiVO mfaConfigOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)mfaConfigOpenApiVO), request, response, mspId);
    }
}

