/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.msp.account;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.MspSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.identityaccess.api.external.dto.openapi.ControllerRoleDetailVO;
import com.tplink.smb.omada.identityaccess.api.external.dto.openapi.MspRoleDetailVO;
import com.tplink.smb.omada.identityaccess.api.external.dto.openapi.RoleBriefVO;
import com.tplink.smb.omada.identityaccess.api.openapi.vo.CreateRoleResultVO;
import com.tplink.smb.omada.identityaccess.api.openapi.vo.ModifyMspRoleVO;
import com.tplink.smb.omada.identityaccess.api.openapi.vo.ModifyRoleVO;
import com.tplink.smb.omada.identityaccess.api.openapi.vo.RoleDetailOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="MSP User and Role")
@RestController
@b(a=7)
@Conditional(value={MspSwaggerMatchCondition.class})
public class MspRoleManagerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MspRoleManagerController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get msp role list", description="Get msp role list")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/roles"})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_ROLES_READ})
    @a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponse<List<MspRoleDetailVO>>> getAllMspRoles(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Get msp role info", description="Get msp role info")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.ROLE_NOT_EXIST}, b={k.MSP_ROLES_READ})
    @GetMapping(value={"/openapi/v1/msp/{mspId}/roles/{roleId}"})
    @a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponse<MspRoleDetailVO>> getMspRole(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="mspId") String mspId, @Parameter(name="roleId", description="Role ID") @PathVariable(name="roleId") String roleId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Create new msp role", description="Create new msp role")
    @PostMapping(value={"/openapi/v1/msp/{mspId}/roles"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.ADD_ROLE_ERROR, com.tplink.smb.omada.common.g.b.DUPLICATE_ROLE_NAME, com.tplink.smb.omada.common.g.b.REACHED_MAX_ROLE_NUM}, b={k.MSP_ROLES_WRITE})
    @a(a=8)
    @ResponseBody
    public DeferredResult<OperationResponse<CreateRoleResultVO>> createNewMspRole(@RequestBody ModifyMspRoleVO role, HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)role), request, response, mspId);
    }

    @Operation(summary="Modify an existing msp role", description="Modify an existing msp role.")
    @RequestMapping(path={"/openapi/v1/msp/{mspId}/roles/{roleId}"}, method={RequestMethod.PUT})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.MODIFY_ROLE_ERROR, com.tplink.smb.omada.common.g.b.DUPLICATE_ROLE_NAME, com.tplink.smb.omada.common.g.b.MODIFY_DEFAULT_ROLE_ERROR, com.tplink.smb.omada.common.g.b.ROLE_NOT_EXIST, com.tplink.smb.omada.common.g.b.CHILD_ROLE_EXCEED_PARENT}, b={k.MSP_ROLES_WRITE})
    @a(a=9)
    @ResponseBody
    public DeferredResult<OperationResponse> modifyMspRole(@RequestBody ModifyRoleVO roleDetailVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="roleId", description="Role ID") @PathVariable(name="roleId") String roleId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)roleDetailVO), request, response, mspId);
    }

    @Operation(summary="Delete an existing msp role", description="Delete an existing msp role")
    @RequestMapping(path={"/openapi/v1/msp/{mspId}/roles/{roleId}"}, method={RequestMethod.DELETE})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.DELETE_ROLE_ERROR, com.tplink.smb.omada.common.g.b.DELETE_ROLE_ERROR_USED, com.tplink.smb.omada.common.g.b.ROLE_NOT_EXIST, com.tplink.smb.omada.common.g.b.DELETE_SSO_BOUND_ROLE_ERROR, com.tplink.smb.omada.common.g.b.DELETE_DEFAULT_ROLE_ERROR}, b={k.MSP_ROLES_WRITE})
    @a(a=10)
    @ResponseBody
    public DeferredResult<OperationResponse> deleteMspRole(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="roleId", description="Role ID") @PathVariable(name="roleId") String roleId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Get customer role list in msp", description="Get customer role list in msp")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/customer-roles"})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_ROLES_READ})
    @a(a=11)
    @ResponseBody
    public DeferredResult<OperationResponse<List<ControllerRoleDetailVO>>> getAllCustomerRoles(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Create new customer role", description="Create new customer role")
    @PostMapping(value={"/openapi/v1/msp/{mspId}/account/customer-roles"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.ADD_ROLE_ERROR, com.tplink.smb.omada.common.g.b.DUPLICATE_ROLE_NAME, com.tplink.smb.omada.common.g.b.REACHED_MAX_ROLE_NUM}, b={k.MSP_ROLES_WRITE})
    @a(a=12)
    @ResponseBody
    public DeferredResult<OperationResponse<CreateRoleResultVO>> createCustomerRole(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @RequestBody RoleDetailOpenApiVO roleDetailVOo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)roleDetailVOo), request, response, mspId);
    }

    @Operation(summary="Modify an existing customer role", description="Modify an existing customer role.")
    @PutMapping(path={"/openapi/v1/msp/{mspId}/account/customer-roles/{roleId}"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.MODIFY_ROLE_ERROR, com.tplink.smb.omada.common.g.b.DUPLICATE_ROLE_NAME, com.tplink.smb.omada.common.g.b.MODIFY_DEFAULT_ROLE_ERROR, com.tplink.smb.omada.common.g.b.ROLE_NOT_EXIST, com.tplink.smb.omada.common.g.b.CHILD_ROLE_EXCEED_PARENT}, b={k.MSP_ROLES_WRITE})
    @a(a=13)
    @ResponseBody
    public DeferredResult<OperationResponse> modifyCustomerRole(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="roleId", description="Role ID") @PathVariable(name="roleId") String roleId, @RequestBody RoleDetailOpenApiVO roleDetailVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)roleDetailVO), request, response, mspId);
    }

    @Operation(summary="Delete an existing customer role", description="Delete an existing customer role")
    @DeleteMapping(path={"/openapi/v1/msp/{mspId}/account/customer-roles/{roleId}"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.DELETE_ROLE_ERROR, com.tplink.smb.omada.common.g.b.DELETE_ROLE_ERROR_USED, com.tplink.smb.omada.common.g.b.ROLE_NOT_EXIST, com.tplink.smb.omada.common.g.b.DELETE_SSO_BOUND_ROLE_ERROR, com.tplink.smb.omada.common.g.b.DELETE_DEFAULT_ROLE_ERROR}, b={k.MSP_ROLES_WRITE})
    @a(a=14)
    @ResponseBody
    public DeferredResult<OperationResponse> deleteCustomerRole(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="roleId", description="Role ID") @PathVariable(name="roleId") String roleId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Get available MSP roles for creating new user", description="Get available MSP roles for creating new user.")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/roles/available"})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_ROLES_READ})
    @a(a=15)
    @ResponseBody
    public DeferredResult<OperationResponse<List<RoleBriefVO>>> getAvailableMspRoles(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Get available customer roles for creating new user", description="Get available customer roles for creating new user.")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/roles/customer/roles/available"})
    @com.tplink.smb.omada.common.m.a(b={k.ROLES_READ})
    @a(a=16)
    @ResponseBody
    public DeferredResult<OperationResponse<List<RoleBriefVO>>> getAvailableCustomerRoles(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }
}

