/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.msp;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.MspSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.system.api.openapi.vo.UploadCertificateOpenApiVO;
import com.tplink.smb.omada.system.api.openapi.vo.UploadSSLKeyOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="Msp setting")
@RestController
@b(a=2)
@Conditional(value={MspSwaggerMatchCondition.class})
public class LocalMspSettingOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalMspSettingOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @a(a=5)
    @Operation(summary="Upload msp certificate", description="Upload msp certificate. Only support .pem, .pfx, .pem files. Certificate name should be the same as the file name.")
    @PostMapping(path={"/openapi/v1/msp/{mspId}/system/setting/certificate"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={})
    public DeferredResult<OperationResponse> uploadCertificate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(value="mspId") String mspId, @RequestParam(value="cerName") String cerName, @RequestParam(name="file") MultipartFile file) {
        UploadCertificateOpenApiVO uploadCertificateOpenApiVO = new UploadCertificateOpenApiVO();
        uploadCertificateOpenApiVO.setCerName(cerName);
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)uploadCertificateOpenApiVO), request, response, mspId);
    }

    @a(a=6)
    @Operation(summary="Delete an existing msp certificate", description="Delete an existing msp certificate.")
    @DeleteMapping(path={"/openapi/v1/msp/{mspId}/system/setting/certificate/{cerId}"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={})
    public DeferredResult<OperationResponse> deleteCertificate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(value="mspId") String mspId, @Parameter(name="cerId", description="Certificate ID") @PathVariable(value="cerId") String cerId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @a(a=7)
    @Operation(summary="Upload msp SSL key", description="Upload msp SSL key. Only support .pem files.")
    @PostMapping(path={"/openapi/v1/msp/{mspId}/system/setting/ssl-key"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={})
    public DeferredResult<OperationResponse> uploadSSLKey(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(value="mspId") String mspId, @RequestParam(value="keyName") String keyName, @RequestParam(name="file") MultipartFile file) {
        UploadSSLKeyOpenApiVO uploadSSLKeyOpenApiVO = new UploadSSLKeyOpenApiVO();
        uploadSSLKeyOpenApiVO.setKeyName(keyName);
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)uploadSSLKeyOpenApiVO), request, response, mspId);
    }

    @a(a=8)
    @Operation(summary="Delete an existing msp SSL key", description="Delete an existing msp SSL key.")
    @DeleteMapping(path={"/openapi/v1/msp/{mspId}/system/setting/ssl-key/{keyId}"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={})
    public DeferredResult<OperationResponse> deleteSSLKey(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(value="mspId") String mspId, @Parameter(name="keyId", description="SSL Key ID") @PathVariable(value="keyId") String keyId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }
}

