/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.msp;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.MspSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.identityaccess.api.internal.dto.CreateCustomerOmadacVO;
import com.tplink.smb.omada.identityaccess.api.openapi.vo.CustomerInfoOpenApiVO;
import com.tplink.smb.omada.identityaccess.api.openapi.vo.CustomerOpenApiVO;
import com.tplink.smb.omada.maintenance.openapi.api.vo.CustomerCopyOpenapiResVO;
import com.tplink.smb.omada.maintenance.openapi.api.vo.CustomerCopyOpenapiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Customer")
@RestController
@b(a=3)
@Conditional(value={MspSwaggerMatchCondition.class})
public class CustomerOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomerOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;
    public static final String NAME = "name";

    @Operation(summary="Get customer list", description="Get customer list")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/customers"})
    @a(a=1)
    @com.tplink.smb.omada.common.m.a(b={k.MSP_DASHBOARD_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<CustomerInfoOpenApiVO>>> getCustomerList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortsName, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Get customer info", description="Get customer info")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/customers/{customerId}"})
    @a(a=2)
    @com.tplink.smb.omada.common.m.a(b={k.MSP_DASHBOARD_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<CustomerInfoOpenApiVO>> getCustomerDetail(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="customerId", description="Customer ID") @PathVariable(value="customerId") String customerId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Create new customer", description="Create new customer(This interface only supports the authorization code mode, not the client mode. Please call this interface in authorization code mode.)")
    @PostMapping(value={"/openapi/v1/msp/{mspId}/customers"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.DUPLICATE_CUSTOMER_NAME, com.tplink.smb.omada.common.g.b.REACHED_MAX_OMADAC_NUM, com.tplink.smb.omada.common.g.b.OPEN_API_INTERFACE_ONLY_SUPPORT_CODE}, b={k.MSP_DASHBOARD_WRITE})
    @a(a=3)
    @ResponseBody
    public DeferredResult<OperationResponse<CreateCustomerOmadacVO>> createCustomer(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @RequestBody CustomerOpenApiVO customerOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)customerOpenApiVO), request, response, mspId);
    }

    @Operation(summary="Modify an existing customer", description="Modify an existing customer")
    @PatchMapping(value={"/openapi/v1/msp/{mspId}/customers/{customerId}"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.DUPLICATE_CUSTOMER_NAME}, b={k.MSP_DASHBOARD_WRITE})
    @a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyCustomer(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="customerId", description="Customer ID") @PathVariable(value="customerId") String customerId, @RequestBody CustomerOpenApiVO customerOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)customerOpenApiVO), request, response, mspId);
    }

    @Operation(summary="Delete an existing customer", description="Delete an existing customer(This interface only supports the authorization code mode, not the client mode. Please call this interface in authorization code mode.)")
    @DeleteMapping(value={"/openapi/v1/msp/{mspId}/customers/{customerId}"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_EXIST_IN_CUSTOMER, com.tplink.smb.omada.common.g.b.OPEN_API_INTERFACE_ONLY_SUPPORT_CODE}, b={k.MSP_DASHBOARD_WRITE})
    @a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteCustomer(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="customerId", description="Customer ID") @PathVariable(value="customerId") String customerId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Obtain the customer ID with permission to modify site templates", description="Obtain the IDs of customers whose site templates the current user has permission to modify.")
    @GetMapping(value={"/openapi/v1/{omadacId}/copy/site/template/batch/customers"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponse<List<CustomerInfoOpenApiVO>>> getCustomersInGlobalHaveSiteTemplateModify(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Favorite a customer", description="Favorite a customer")
    @PostMapping(value={"/openapi/v1/msp/{mspId}/customers/{customerId}/favorites"})
    @a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> favoriteCustomer(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="customerId", description="Customer ID") @PathVariable(value="customerId") String customerId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Cancel a favorite customer", description="Cancel a favorite customer")
    @PostMapping(value={"/openapi/v1/msp/{mspId}/customers/{customerId}/favorites/cancels"})
    @a(a=8)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> cancelFavoriteCustomer(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="customerId", description="Customer ID") @PathVariable(value="customerId") String customerId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Create a customer by copying from existing customer", description="Create a customer by copying from existing customer")
    @PostMapping(value={"/openapi/v1/msp/{mspId}/customers/copy"})
    @a(a=9)
    @ResponseBody
    public DeferredResult<OperationResponse<CustomerCopyOpenapiResVO>> copyCustomer(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @RequestBody CustomerCopyOpenapiVO customerCopyOpenapiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)customerCopyOpenapiVO), request, response, mspId);
    }
}

