/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.monitor.statistic;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.monitor.api.openapi.stat.OltStatOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.stat.OltStatQueryOpenApiDTO;
import com.tplink.smb.omada.monitor.api.openapi.stat.OswRankingCardsOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.stat.OswStackStatQueryOpenApiDTO;
import com.tplink.smb.omada.monitor.api.openapi.stat.OswStatOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.stat.OswStatQueryOpenApiDTO;
import com.tplink.smb.omada.monitor.api.openapi.stat.TimeQueryOpenApiVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.BaseDeviceStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStackDetailStatVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStackMemberStatVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStackStatQueryVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.StatQueryVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.StatisticsOswVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Statistic")
@RestController
@b(a=66)
public class StatisticOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get switch statistics", description="Get switch statistics")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stat/switches/{deviceMac}"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_REQUEST_PARAMS, com.tplink.smb.omada.common.g.b.SWITCH_DOES_NOT_EXIST}, b={k.STATICS_READ, k.DEVICES_READ})
    @a(a=1)
    @ResponseBody
    public DeferredResult<OperationResponse<StatisticsOswVO>> getSwitchStat(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String switchMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get switch statistics chart", description="Display statistics based on the time granularity calculated by start and end times:\nWithin 26 hours, 5 minutes of data is displayed\n26 hours to 7 days 2 hours, showing hourly statistics\n7 days 2 hours to 120 days 2 hours, showing daily statistics\n120 days 2 hours or more, showing weekly statistics\n")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stat/switches/{deviceMac}/chart"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_REQUEST_PARAMS}, b={k.STATICS_READ, k.DEVICES_READ})
    @a(a=2)
    @ResponseBody
    public DeferredResult<OperationResponse<OswStatOpenApiVO>> getSwitchStatChart(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @RequestBody OswStatQueryOpenApiDTO dto) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)dto), request, response, omadacId);
    }

    @Operation(summary="Get olt statistics chart", description="Display statistics based on the time granularity calculated by start and end times:\nWithin 26 hours, 5 minutes of data is displayed\n26 hours to 7 days 2 hours, showing hourly statistics\n7 days 2 hours to 120 days 2 hours, showing daily statistics\n120 days 2 hours or more, showing weekly statistics\n")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stat/olts/{deviceMac}/chart"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_REQUEST_PARAMS}, b={k.STATICS_READ, k.DEVICES_READ})
    @a(a=3)
    @ResponseBody
    public DeferredResult<OperationResponse<OltStatOpenApiVO>> getOltStatChart(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @RequestBody OltStatQueryOpenApiDTO dto) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)dto), request, response, omadacId);
    }

    @Operation(summary="Get switch stack statistics", description="Get switch stack statistics")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stat/stack/{stackId}"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_REQUEST_PARAMS, com.tplink.smb.omada.common.g.b.STACK_NOT_EXIST}, b={k.STATICS_READ, k.DEVICES_READ})
    @a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponse<List<OswStackDetailStatVO>>> getOswStackDetailStat(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(name="deviceMac") String stackId, @RequestBody OswStackStatQueryVO dto) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)dto), request, response, omadacId);
    }

    @Operation(summary="Get switch ranking cards", description="Get switch ranking cards")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/health/switches/rankingCards"})
    @com.tplink.smb.omada.common.m.a(a={}, b={k.ANOMALY_READ})
    @a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponse<OswRankingCardsOpenApiVO>> getOswRankingCards(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody TimeQueryOpenApiVO timeQueryOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)timeQueryOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get device statistic data 5 min", description="Get device statistic data 5 min")
    @PostMapping(value={"/openapi/v2/{omadacId}/sites/{siteId}/stat/{deviceMac}/5min"})
    @com.tplink.smb.omada.common.m.a(a={}, b={k.DEVICES_READ, k.STATICS_READ})
    @a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponse<BaseDeviceStatDTO>> getDevice5MinStatistic(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @Parameter(name="type", description="Device Type. Supported type: ap, gateway, switch, olt.") @RequestParam(name="type") String deviceType, @RequestBody StatQueryVO statQuery) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)statQuery), request, response, omadacId);
    }

    @Operation(summary="Get device statistic data hourly", description="Get device statistic data hourly")
    @PostMapping(value={"/openapi/v2/{omadacId}/sites/{siteId}/stat/{deviceMac}/hourly"})
    @com.tplink.smb.omada.common.m.a(a={}, b={k.DEVICES_READ, k.STATICS_READ})
    @a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponse<BaseDeviceStatDTO>> getDeviceHourlyStatistic(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @Parameter(name="type", description="Device Type. Supported type: ap, gateway, switch, olt.") @RequestParam(name="type") String deviceType, @RequestBody StatQueryVO statQuery) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)statQuery), request, response, omadacId);
    }

    @Operation(summary="Get device statistic data daily", description="Get device statistic data daily")
    @PostMapping(value={"/openapi/v2/{omadacId}/sites/{siteId}/stat/{deviceMac}/daily"})
    @com.tplink.smb.omada.common.m.a(a={}, b={k.DEVICES_READ, k.STATICS_READ})
    @a(a=8)
    @ResponseBody
    public DeferredResult<OperationResponse<BaseDeviceStatDTO>> getDeviceDailyStatistic(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @Parameter(name="type", description="Device Type. Supported type: ap, gateway, switch, olt.") @RequestParam(name="type") String deviceType, @RequestBody StatQueryVO statQuery) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)statQuery), request, response, omadacId);
    }

    @Operation(summary="Get stack statistics chart", description="Display statistics based on the time granularity calculated by start and end times:\nWithin 26 hours, 5 minutes of data is displayed\n26 hours to 7 days 2 hours, showing hourly statistics\n7 days 2 hours to 120 days 2 hours, showing daily statistics\n120 days 2 hours or more, showing weekly statistics\n")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stat/stack/{stackId}/chart"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_REQUEST_PARAMS}, b={k.STATICS_READ, k.DEVICES_READ})
    @a(a=9)
    @ResponseBody
    public DeferredResult<OperationResponse<List<OswStackMemberStatVO>>> getStackStatChart(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(name="stackId") String stackId, @RequestBody OswStackStatQueryOpenApiDTO dto) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)dto), request, response, omadacId);
    }
}

