/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.monitor.dashboard;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.dashboard.api.web.network.DashboardIspLoadDetailVO;
import com.tplink.smb.omada.manager.dashboard.api.web.network.WanPortBandwidthVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.ApChannelsStatOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.ApInterferencesOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.BatchTabOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.CardOverviewOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.CpuUsageOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.CreateTabOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.DashboardVpnStatsOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.GetActiveDeviceOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.GetActiveDeviceV2OpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.IpsecVpnStatsOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.IspLoadOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.ListTabsOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.MemUsageOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.OswSummaryOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.OverviewOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.PoeUsageOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.RetryDropRateOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.TrafficActivitiesOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.TrafficDistributionOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.UpdateTabOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.WifiSummaryOpenApiVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.NetworkActivityVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.TopApByRtDropVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Dashboard")
@RestController
@com.a.a.a.a.b(a=13)
public class DashboardOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get tab without overall tab list", description="Get tabs without Overall Tab.")
    @a(a={b.DASH_BOARD_DATA_ERR}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/without-overall-tabs"})
    @ResponseBody
    @com.a.a.a.a.a(a=1)
    public DeferredResult<OperationResponse<List<ListTabsOpenApiVO>>> listTabs(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get tab list", description="Get tab list.")
    @a(a={b.DASH_BOARD_DATA_ERR}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/tabs"})
    @ResponseBody
    @com.a.a.a.a.a(a=2)
    public DeferredResult<OperationResponse<List<ListTabsOpenApiVO>>> listAllTabs(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new tab", description="Create tab.")
    @a(a={b.DASH_BOARD_DATA_ERR, b.TAB_REACH_LIMIT, b.TAB_NAME_DUPLICATED}, b={k.DASHBOARD_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/tabs"})
    @ResponseBody
    @com.a.a.a.a.a(a=3)
    public DeferredResult<OperationResponseWithoutResult> createTab(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateTabOpenApiVO tabOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)tabOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing tab", description="Delete an existing tab.")
    @a(a={b.DASH_BOARD_DATA_ERR, b.OVERALL_NOT_ALLOWED_DELETED}, b={k.DASHBOARD_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/tabs/{tabId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=4)
    public DeferredResult<OperationResponseWithoutResult> removeTab(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="tabId", description="Tab ID") @PathVariable(name="tabId") String tabId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify an existing tab", description="Modify an existing tab.")
    @a(a={b.DASH_BOARD_DATA_ERR, b.TAB_NOT_EXIST, b.SYSTEN_CARD_NOT_ALLOWED_EDITED, b.TAB_NAME_DUPLICATED}, b={k.DASHBOARD_WRITE})
    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/tabs/{tabId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=5)
    public DeferredResult<OperationResponseWithoutResult> updateTab(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="tabId", description="Tab ID") @PathVariable(name="tabId") String tabId, @RequestBody UpdateTabOpenApiVO tabOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)tabOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Batch set tab config", description="Batch set tab configurations, add or delete tabs.")
    @a(a={b.DASH_BOARD_DATA_ERR, b.TAB_NOT_EXIST, b.SYSTEN_CARD_NOT_ALLOWED_EDITED, b.TAB_NAME_DUPLICATED}, b={k.DASHBOARD_WRITE})
    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/multi-tabs/config"})
    @ResponseBody
    @com.a.a.a.a.a(a=6)
    public DeferredResult<OperationResponseWithoutResult> batchConfigTab(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody BatchTabOpenApiVO batchTabOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)batchTabOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get site overview diagram info", description="Get site overview diagram info.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/overview-diagram"})
    @ResponseBody
    @com.a.a.a.a.a(a=7)
    public DeferredResult<OperationResponse<OverviewOpenApiVO>> getOverview(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get channel distribution and usage", description="Get channel distribution and usage.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/channels"})
    @ResponseBody
    @com.a.a.a.a.a(a=8)
    public DeferredResult<OperationResponse<ApChannelsStatOpenApiVO>> getChannels(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the most active eap list", description="Obtain the top 5 APs with the highest device traffic within the time range (in Bytes)..")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/most-active-eaps"})
    @ResponseBody
    @com.a.a.a.a.a(a=9)
    public DeferredResult<OperationResponse<List<GetActiveDeviceOpenApiVO>>> getActiveAps(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get most active switch list", description="Obtain the top 5 switches with the highest device traffic within the time range (in Bytes)")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/most-active-switches"})
    @ResponseBody
    @com.a.a.a.a.a(a=10)
    public DeferredResult<OperationResponse<List<GetActiveDeviceOpenApiVO>>> getActiveSwitches(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get wifi summary", description="Get wifi summary.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/wifi-summary"})
    @ResponseBody
    @com.a.a.a.a.a(a=11)
    public DeferredResult<OperationResponse<WifiSummaryOpenApiVO>> getWifiSummary(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get switch summary", description="Get switch summary")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/switch-summary"})
    @ResponseBody
    @com.a.a.a.a.a(a=12)
    public DeferredResult<OperationResponse<OswSummaryOpenApiVO>> getSwitchSummary(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get traffic distribution", description="Obtain wired/wireless traffic distribution data within the time range")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/traffic-distribution"})
    @ResponseBody
    @com.a.a.a.a.a(a=13)
    public DeferredResult<OperationResponse<TrafficDistributionOpenApiVO>> getTrafficDistribution(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get traffic activity", description="Obtain AP and Switch traffic Activities within the time range")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/traffic-activities"})
    @ResponseBody
    @com.a.a.a.a.a(a=14)
    public DeferredResult<OperationResponse<TrafficActivitiesOpenApiVO>> getTrafficActivities(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get retried rate and dropped rate", description="Get retried rate and dropped rate.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/retry-dropped-rate"})
    @ResponseBody
    @com.a.a.a.a.a(a=15)
    public DeferredResult<OperationResponse<RetryDropRateOpenApiVO>> getRetryAndDroppedRate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get top device cpu usage", description="Obtain the top 5 CPU usage devices within the time range")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/top-device-cpu-usage"})
    @ResponseBody
    @com.a.a.a.a.a(a=16)
    public DeferredResult<OperationResponse<List<CpuUsageOpenApiVO>>> getTopCpuUsageWithTimeRange(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get top device memory usage", description="Obtain the top 5 memory usage devices within the time range")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/top-device-memory-usage"})
    @ResponseBody
    @com.a.a.a.a.a(a=17)
    public DeferredResult<OperationResponse<List<MemUsageOpenApiVO>>> getTopMemoryUsageWithTimeRange(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get top interference", description="Obtain the 5 APs with the highest interference intensity in different frequency bands within the time range")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/top-interference"})
    @ResponseBody
    @com.a.a.a.a.a(a=18)
    public DeferredResult<OperationResponse<ApInterferencesOpenApiVO>> getInterference(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get poe usage", description="Obtain the PoE usage of the switch within the time range")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/poe-usage"})
    @ResponseBody
    @com.a.a.a.a.a(a=19)
    public DeferredResult<OperationResponse<List<PoeUsageOpenApiVO>>> getPoeUsage(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get isp load info", description="Obtain IPS load data for the gateway within the time range.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/isp-load"})
    @ResponseBody
    @com.a.a.a.a.a(a=20)
    public DeferredResult<OperationResponse<List<IspLoadOpenApiVO>>> getIspLoad(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get grid dashboard tunnel statistic list", description="Get the status, IP address, and other information of the established dashboard tunnel statistic VPN connection")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/vpn-tunnel-stats"})
    @ResponseBody
    @com.a.a.a.a.a(a=21)
    public DeferredResult<OperationResponse<List<DashboardVpnStatsOpenApiVO>>> getGridDashboardTunnelStats(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="type", description="Type should be a value as follows: 0:Server,1:Client") @RequestParam(name="type") Integer type) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get grid dashboard lpsec tunnel statistic list", description="Obtain the status, IP address, and other information of the established IPsec VPN connection")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/lpset-tunnel-stats"})
    @ResponseBody
    @com.a.a.a.a.a(a=22)
    public DeferredResult<OperationResponse<List<IpsecVpnStatsOpenApiVO>>> getGridDashboardIpsecTunnelStats(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get grid dashboard open vpn tunnel statistic list", description="Obtain the status, traffic, and other information of the established open VPN connection")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/open-vpn-tunnel-stats"})
    @ResponseBody
    @com.a.a.a.a.a(a=23)
    public DeferredResult<OperationResponse<List<DashboardVpnStatsOpenApiVO>>> getGridDashboardOpenVpnTunnelStats(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="type", description="type: 0:Server, 1:Client") @RequestParam(name="type") Integer type) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get grid dashboard open network activity statistic list")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/allNetworkActivity"})
    @ResponseBody
    @com.a.a.a.a.a(a=24)
    public DeferredResult<OperationResponse<NetworkActivityVO>> getAllNetworkActivity(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get network overview", description="Obtain the statistic info of devices.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/card/overview"})
    @ResponseBody
    @com.a.a.a.a.a(a=25)
    public DeferredResult<OperationResponse<List<CardOverviewOpenApiVO>>> getCardTopology(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/gateway/isp/load"})
    @ResponseBody
    @com.a.a.a.a.a(a=26)
    @Operation(summary="Get site dashboard isp load inform", description="Get site dashboard isp load inform of the site with the given omadacId and siteId.")
    @a(b={k.DASHBOARD_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<DashboardIspLoadDetailVO>> getGatewayIspLoad(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/wan/bandwidth"})
    @ResponseBody
    @com.a.a.a.a.a(a=27)
    @Operation(summary="Set site dashboard wan bandwidth", description="Set site dashboard wan bandwidth of the site with the given omadacId and siteId.")
    @a(b={k.DASHBOARD_WRITE}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponseWithoutResult> configBandwidthForWanPorts(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody WanPortBandwidthVO wanPortBandwidthVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)wanPortBandwidthVO), request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/top-aps"})
    @ResponseBody
    @com.a.a.a.a.a(a=28)
    @Operation(summary="Get Top 5 Aps", description="Get Top 5 Aps.")
    @a(b={k.DASHBOARD_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<TopApByRtDropVO>> getTop5Aps(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the most active eap list", description="Obtain the top 5 APs with the highest device traffic within the time range (in Bytes)..")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/dashboard/most-active-eaps"})
    @ResponseBody
    @com.a.a.a.a.a(a=29)
    public DeferredResult<OperationResponse<GetActiveDeviceV2OpenApiVO>> getActiveApsV2(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceNum", description="The number of most active APs acquired.") @RequestParam(name="deviceNum") Integer deviceNum, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

