/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.insight;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.monitor.api.openapi.vo.OsgVpnIpSecOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.OsgVpnTunnelOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.OswRoutingOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.PortForwardingOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.RemoveBlackListOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.StackRoutingOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.WidsDataOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.WipsBlackListOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.ApChannelLoadResultOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.ApFullChannelDetectStatusOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.ApWifiInterferenceResultOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.BatchFullChannelDetectApListOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.BatchFullChannelDetectGridOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.BatchFullChannelDetectHistoryOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.BatchFullChannelDetectStatusOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.BatchWifiInterferenceOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.DisableFullChanDetectApListOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.EnableFullChannelDetectApInfoOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.FullChanScanCommandOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect.StartBatchFullChannelDetectCmdOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.rogueap.ExportRougeApOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.rogueap.RogueApOpenApiVO;
import com.tplink.smb.omada.monitor.api.web.fullchanneldetect.dto.QueryBatchFullChannelDetectStatusVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Insight")
@RestController
public class InsightOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InsightOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get Port Forwarding Status", description="Get Port Forwarding Status")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/insight/port-forwarding/{type}"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.INSIGHT_READ})
    @com.a.a.a.a.a(a=1)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<PortForwardingOpenApiVO>>> getPortForwardStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="type", description="User/UPnP") @PathVariable(value="type") String type, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the dynamic blacklist entry data of Wireless IDS", description="Get the dynamic blacklist entry data of Wireless IDS")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/insight/wids/blacklist"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.INSIGHT_READ, k.SITE_NETWORK_READ})
    @com.a.a.a.a.a(a=2)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<WipsBlackListOpenApiVO>>> getGridWipsBlackList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Remove the specified Device MAC from the blacklist of the reported device", description="Remove the specified Device MAC from the blacklist of the reported device")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/insight/wids/blacklist/{mac}"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.INSIGHT_WRITE, k.SITE_NETWORK_WRITE})
    @com.a.a.a.a.a(a=2)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> removeWipsBlackList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="mac", description="Mac Address") @PathVariable(value="mac") String mac, @RequestBody RemoveBlackListOpenApiVO removeBlackListOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)removeBlackListOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get the routing table data interface", description="Get the routing table data interface")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/insight/routing/{type}"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.INSIGHT_READ, k.DEVICES_READ})
    @com.a.a.a.a.a(a=3)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<OswRoutingOpenApiVO>>> getGridRouting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="type", description="type") @PathVariable(value="type") String type, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Query the vpnStats ipsec list", description="Query the vpnStats ipsec list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/vpn/stats/ipsec"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.INSIGHT_READ, k.SITE_DEVICE_READ})
    @com.a.a.a.a.a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<OsgVpnIpSecOpenApiVO>>> getGridVpnIpSec(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Query the vpnStats tunnel list", description="Query the vpnStats tunnel list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/vpn/stats/tunnel"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.INSIGHT_READ, k.DEVICES_READ, k.SITE_DEVICE_READ})
    @com.a.a.a.a.a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<OsgVpnTunnelOpenApiVO>>> getGridVpnTunnel(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Query the Wireless IDS entry list", description="Query the Wireless IDS entry list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/insight/wids"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.INSIGHT_READ, k.SITE_NETWORK_READ})
    @com.a.a.a.a.a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<WidsDataOpenApiVO>>> getGridWidsData(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Terminating vpn tunnel", description="Terminating vpn tunnel")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cmd/vpn/stats/tunnel/terminate"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.INSIGHT_READ, k.SITE_DEVICE_WRITE})
    @com.a.a.a.a.a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> terminateVpnTunnel(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody OsgVpnTunnelOpenApiVO osgVpnTunnelOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)osgVpnTunnelOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Enable interference detection", description="Enable interference detection")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/aps/{apMac}/full-channel-detect-start"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST, b.SETTING_OVERRIDE}, b={k.DEVICES_WRITE})
    @com.a.a.a.a.a(a=8)
    @ResponseBody
    DeferredResult<OperationResponseWithoutResult> triggerFullChannelDetect(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="apMac", description="AP MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="apMac") String mac, @RequestBody FullChanScanCommandOpenApiVO fullChanScanCommandOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)fullChanScanCommandOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get the interference detection status of APs", description="Get Full Channel Detect Status")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/aps/{apMac}/full-channel-detect/status"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.DEVICES_READ})
    @com.a.a.a.a.a(a=9)
    @ResponseBody
    DeferredResult<OperationResponse<ApFullChannelDetectStatusOpenApiVO>> getFullChannelDetectStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="apMac", description="AP MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="apMac") String mac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary=" Get WiFi interference results of interference detection", description=" Get WiFi interference results of interference detection")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/aps/{apMac}/full-channel-detect/wlan-interference"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.DEVICES_READ})
    @com.a.a.a.a.a(a=10)
    @ResponseBody
    DeferredResult<OperationResponse<GridVO<ApWifiInterferenceResultOpenApiVO>>> getGridWifiInterfResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="apMac", description="AP MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="apMac") String mac, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get channel utilization results of interference detection", description="Get channel utilization results of interference detection")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/aps/{apMac}/full-channel-detect/channel-load"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.DEVICES_READ})
    @com.a.a.a.a.a(a=12)
    @ResponseBody
    DeferredResult<OperationResponse<ApChannelLoadResultOpenApiVO>> getChannelLoadResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="apMac", description="AP MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="apMac") String mac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Enable environment scanning", description="Enable environment scanning")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/aps/{apMac}/spectral-scan-start"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST, b.SETTING_OVERRIDE}, b={k.DEVICES_WRITE})
    @com.a.a.a.a.a(a=13)
    @ResponseBody
    DeferredResult<OperationResponseWithoutResult> triggerSpectralScan(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="apMac", description="AP MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="apMac") String mac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Stop environment scanning", description="Stop environment scanning")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/aps/{apMac}/spectral-scan-stop"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST, b.SETTING_OVERRIDE}, b={k.DEVICES_WRITE})
    @com.a.a.a.a.a(a=14)
    @ResponseBody
    DeferredResult<OperationResponseWithoutResult> stopSpectralScan(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="apMac", description="AP MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="apMac") String mac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get history results of environment scanning", description="Get history results of environment scanning. The results of the environment scan are compressed by the Deflate algorithm and then base64 encoded.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/spectral-scan/aps/{apMac}/spectral-scan-result/history"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.DEVICES_READ})
    @com.a.a.a.a.a(a=15)
    @ResponseBody
    DeferredResult<OperationResponse> getSpectralScanHistoryResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="apMac", description="AP MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="apMac") String mac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get current results of environment scanning", description="Get current results of environment scanning. The results of the environment scan are compressed by the Deflate algorithm and then base64 encoded.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/spectral-scan/aps/{apMac}/spectral-scan-result"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.DEVICES_READ})
    @com.a.a.a.a.a(a=16)
    @ResponseBody
    DeferredResult<OperationResponse> getSpectralScanResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="apMac", description="AP MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="apMac") String mac, @Parameter(name="times", description="The time between the requested spectral scan results.") @RequestParam(name="times") Integer times) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Query the Rogue AP scan results", description="Query the Rogue AP scan results")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/insight/rogueaps"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.INSIGHT_READ, k.SITE_ANALYZE_READ})
    @com.a.a.a.a.a(a=17)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<RogueApOpenApiVO>>> getGridRogueAps(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Scan Rogue APs", description="Scan Rogue APs")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cmd/rogueaps/scan"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.INSIGHT_WRITE, k.SITE_ANALYZE_WRITE})
    @com.a.a.a.a.a(a=18)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> scanRogueAps(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Export global Rogue AP scan results", description="Export global Rogue AP scan results")
    @PostMapping(value={"/openapi/v1/{omadacId}/files/neighbors"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.GLOBAL_DATA_EXPORT})
    @com.a.a.a.a.a(a=20)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> exportRogueApsGlobal(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody ExportRougeApOpenApiVO exportRougeApOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)exportRougeApOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get the AP list of batch interference detection", description="Get the AP list of batch interference detection")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/full-channel-detect/{historyId}/ap-list"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.SITE_ANALYZE_READ})
    @com.a.a.a.a.a(a=21)
    @ResponseBody
    DeferredResult<OperationResponse<BatchFullChannelDetectApListOpenApiVO>> getBatchFullChannelDetectApList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="historyId", description="AP MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="historyId") String historyId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the interference detection history by page", description="Get the interference detection history by page")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/full-channel-detect/grid/scan-history"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.SITE_ANALYZE_READ})
    @com.a.a.a.a.a(a=22)
    @ResponseBody
    DeferredResult<OperationResponse<BatchFullChannelDetectGridOpenApiVO<BatchFullChannelDetectHistoryOpenApiVO>>> getGridFullChannelDetectHistory(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Delete the interference detection history", description="Delete the interference detection history")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/full-channel-detect/{historyId}"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.SITE_ANALYZE_WRITE})
    @com.a.a.a.a.a(a=23)
    @ResponseBody
    DeferredResult<OperationResponseWithoutResult> deleteBatchFullChannelDetectHistory(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="historyId", description="The ID List of full channel detect") @PathVariable(name="historyId") String historyId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Delete all interference detection history", description="Delete all interference detection history")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/full-channel-detect"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.SITE_ANALYZE_WRITE})
    @com.a.a.a.a.a(a=24)
    @ResponseBody
    DeferredResult<OperationResponseWithoutResult> deleteALLBatchFullChannelDetectHistory(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the interference detection status", description="Get the interference detection status")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/full-channel-detect/status"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.SITE_ANALYZE_READ})
    @com.a.a.a.a.a(a=25)
    @ResponseBody
    DeferredResult<OperationResponse<List<BatchFullChannelDetectStatusOpenApiVO>>> getBatchFullChannelDetectStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody QueryBatchFullChannelDetectStatusVO queryBatchFullChannelDetectStatusVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryBatchFullChannelDetectStatusVO), request, response, omadacId);
    }

    @Operation(summary="Get the list of devices that can perform interference detection by page", description="Get the list of devices that can perform interference detection by page")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/grid/full-channel-detect/ap-list"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.SITE_ANALYZE_READ})
    @com.a.a.a.a.a(a=26)
    @ResponseBody
    DeferredResult<OperationResponse<List<EnableFullChannelDetectApInfoOpenApiVO>>> getGridEnableFullChannelDetectApList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Enable batch interference detection", description="Enable batch interference detection")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/full-channel-detect-start"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.SITE_ANALYZE_WRITE})
    @com.a.a.a.a.a(a=27)
    @ResponseBody
    DeferredResult<OperationResponseWithoutResult> startBatchFullChannelDetect(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody StartBatchFullChannelDetectCmdOpenApiVO startBatchFullChannelDetectCmdOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)startBatchFullChannelDetectCmdOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get WiFi interference results of batch interference detection", description="Get WiFi interference results of batch interference detection")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/full-channel-detect/{historyId}/grid/wifi-interference"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.SITE_ANALYZE_READ})
    @com.a.a.a.a.a(a=28)
    @ResponseBody
    DeferredResult<OperationResponse<GridVO<BatchWifiInterferenceOpenApiVO>>> getBatchWifiInterferencesResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="historyId", description="Customer ID") @PathVariable(name="historyId") String historyId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="filters.type", description="Filter query parameters, support field wifi-interference result type. 0: all device; 1: one device.") @RequestParam(name="filters.type", required=true) String type, @Parameter(name="filters.radioId", description="Filter query parameters, support field radio id. 0: 2.4G; 1: 5G; 3:6G.") @RequestParam(name="filters.radioId", required=false) String radioId, @Parameter(name="filters.mac", description="Filter query parameters, support field AP MAC address, like AA-BB-CC-DD-EE-FF. When parameter [filter.type] is 0, this parameter is invalid.") @RequestParam(name="filters.mac", required=false) String mac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get channel utilization results of batch interference detection", description="Get channel utilization results of batch interference detection")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/full-channel-detect/{historyId}/channel-load"})
    @a(a={b.AP_DOES_NOT_EXIST, b.DEVICE_NOT_EXIST}, b={k.SITE_ANALYZE_READ})
    @com.a.a.a.a.a(a=30)
    @ResponseBody
    DeferredResult<OperationResponse<List<ApChannelLoadResultOpenApiVO>>> getBatchChannelLoadsResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="historyId", description="Customer ID") @PathVariable(name="historyId") String historyId, @Parameter(name="mac", description="Mac Address, like AA-BB-CC-DD-EE-FF") @RequestParam(name="mac") String mac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Export batch interference detection results", description="Export batch interference detection results")
    @GetMapping(value={"/openapi/v1/{omadacId}/files/sites/{siteId}/full-channel-detect/{historyId}"})
    @a(a={b.INVALID_REQUEST_PARAMS}, b={k.SITE_ANALYZE_READ})
    @com.a.a.a.a.a(a=31)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> exportBatchFullChannelDetectResultData(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="historyId", description="Customer ID") @PathVariable(name="historyId") String historyId, @Parameter(name="format", description="export data format") @RequestParam(name="format") Integer format) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the MAC list of APs that cannot perform interference detection", description="Get the MAC list of APs that cannot perform interference detection")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/full-channel-detect/batch/info"})
    @a(a={b.INVALID_REQUEST_PARAMS, b.OBTAIN_SUPPORT_FULL_CHANNEL_DETECT_APS_FAILED}, b={k.SITE_ANALYZE_READ})
    @com.a.a.a.a.a(a=32)
    @ResponseBody
    DeferredResult<OperationResponse<DisableFullChanDetectApListOpenApiVO>> getDisableFullChannelDetectApMacList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get stack routing table", description="Get stack routing table.")
    @a(a={}, b={k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stack/{stackId}/routingTable"})
    @com.a.a.a.a.a(a=32)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<StackRoutingOpenApiVO>>> getGridStackRoutingTable(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(name="stackId") String stackId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.destinationIp", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.destinationIp", required=false) String sortsDestinationIp, @Parameter(name="filters.type", description="Filter query parameters, support field type") @RequestParam(name="filters.type", required=false) String filtersType, @Parameter(name="searchKey", description="Fuzzy query parameters, support field destinationIp") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get switch routing table", description="Get switch routing table.")
    @a(a={}, b={k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/switches/{switchMac}/routingTable"})
    @com.a.a.a.a.a(a=33)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<OswRoutingOpenApiVO>>> getGridOswRoutingTable(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="switchMac", description="Switch MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="switchMac") String mac, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.destinationIp", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.destinationIp", required=false) String sortsDestinationIp, @Parameter(name="filters.type", description="Filter query parameters, support field type") @RequestParam(name="filters.type", required=false) String filtersType, @Parameter(name="searchKey", description="Fuzzy query parameters, support field destinationIp") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

