/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.hotspot;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.portal.api.openapi.vo.CreatedResIdOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.AllTimeVoucherSummaryOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.CreateVoucherGroupOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.CurrencyCandidatesOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.EditVoucherGroupPatternOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.ExportVoucherOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.HotspotSiteSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.SelectIdsOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.SelectVoucherGroupOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.UploadVoucherGroupLogoOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherBriefOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherConfigLimitOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherDurationDistributionOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherGroupGridOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherGroupOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherStatisticsHistoryOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherUnitPriceDistributionOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.PortalPictureVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="Voucher")
@RestController
@com.a.a.a.a.b(a=11)
public class VoucherOpenApiController {
    @Autowired
    private OpenApiHandler openApiHandler;

    @com.a.a.a.a.a(a=1)
    @Operation(summary="Create a new Voucher Group", description="Create a Voucher Group with the given params.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID, b.VOUCHER_GROUP_MIXED_USE_CURRENCY, b.EMPTY_PORTAL_BIND_VOUCHER, b.VOUCHER_GROUP_NAME_DUPLICATED, b.VOUCHER_GROUP_PORTAL_NOT_EXIST, b.VOUCHER_GROUP_EXPIRATION_TIME_OVERRUN, b.VOUCHER_NUM_EXCEED, b.VOUCHER_GROUP_CURRENCY_NOT_SUPPORTED, b.RATE_LIMIT_NOT_EXIST}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups"})
    @ResponseBody
    public DeferredResult<OperationResponse<CreatedResIdOpenApiVO>> createVoucherGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateVoucherGroupOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @com.a.a.a.a.a(a=2)
    @Operation(summary="Get Voucher Group List", description="Get Voucher Group List with the given params.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups"})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<VoucherGroupOpenApiVO>>> getGridVoucherGroups(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortsName, @Parameter(name="sorts.createTime", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.createTime", required=false) String sortsCreateTime, @Parameter(name="filters.timeStart", description="Filter query parameters, support field time range: start timestamp (ms).") @RequestParam(name="filters.timeStart", required=false) Long filtersTimeStart, @Parameter(name="filters.timeEnd", description="Filter query parameters, support field time range: end timestamp (ms).") @RequestParam(name="filters.timeEnd", required=false) Long filtersTimeEnd, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=3)
    @Operation(summary="Get Voucher Group Detail", description="Get Voucher Group Detail with the given params.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups/{groupId}"})
    @ResponseBody
    public DeferredResult<OperationResponse<VoucherGroupGridOpenApiVO>> getVoucherGroupDetail(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="groupId", description="Voucher Group ID") @PathVariable(name="groupId") String groupId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.code", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.code", required=false) String sortsName, @Parameter(name="filters.status", description="Filter query parameters, support field status for vouchers in the voucher group: 0: unused vouchers, 1: in-use vouchers, 2: expired vouchers") @RequestParam(name="filters.status", required=false) Long filtersStatus, @Parameter(name="searchKey", description="Fuzzy query parameters, support field code") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=4)
    @Operation(summary="Delete an existing Voucher Group", description="Delete an existing Voucher Group with the given params.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups/{groupId}"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteVoucherGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="groupId", description="Voucher Group ID") @PathVariable(name="groupId") String groupId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=5)
    @Operation(summary="Delete selected Voucher Groups", description="Delete selected Voucher Groups with the given params.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups/batch/delete"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteSelectedVoucherGroups(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody SelectVoucherGroupOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @com.a.a.a.a.a(a=6)
    @Operation(summary="Get unused vouchers in voucher group", description="Get unused vouchers brief information in a voucher group.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups/{groupId}/print-unused"})
    @ResponseBody
    public DeferredResult<OperationResponse<List<VoucherBriefOpenApiVO>>> printVoucherGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="groupId", description="Voucher Group ID") @PathVariable(name="groupId") String groupId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=7)
    @Operation(summary="Get unused vouchers in selected voucher groups", description="Get unused vouchers brief information in selected voucher groups.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups/batch/print-unused"})
    @ResponseBody
    public DeferredResult<OperationResponse<List<VoucherBriefOpenApiVO>>> printSelectedVoucherGroups(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody SelectVoucherGroupOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @com.a.a.a.a.a(a=8)
    @Operation(summary="Get voucher summary", description="Get voucher summary of all time in the site.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/vouchers/statistics/summary"})
    @ResponseBody
    public DeferredResult<OperationResponse<AllTimeVoucherSummaryOpenApiVO>> getAllTimeVoucherSummary(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=9)
    @Operation(summary="Get voucher history statistics", description="Get voucher history statistics.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/vouchers/statistics/history"})
    @ResponseBody
    public DeferredResult<OperationResponse<VoucherStatisticsHistoryOpenApiVO>> getVoucherHistoryStatistics(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="filters.timeStart", description="Filter query parameters, support field time range: start timestamp (second).") @RequestParam(name="filters.timeStart") Long filtersTimeStart, @Parameter(name="filters.timeEnd", description="Filter query parameters, support field time range: end timestamp (second).") @RequestParam(name="filters.timeEnd") Long filtersTimeEnd) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=10)
    @Operation(summary="Get voucher distribution by price", description="Get voucher distribution by price.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/vouchers/statistics/history/distribution/unit-price"})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<VoucherUnitPriceDistributionOpenApiVO>>> getVoucherDistributionByPrice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="filters.timeStart", description="Filter query parameters, support field time range: start timestamp (second).") @RequestParam(name="filters.timeStart") Long filtersTimeStart, @Parameter(name="filters.timeEnd", description="Filter query parameters, support field time range: end timestamp (second).") @RequestParam(name="filters.timeEnd") Long filtersTimeEnd) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=11)
    @Operation(summary="Get voucher distribution by duration", description="Get voucher distribution by duration.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/vouchers/statistics/history/distribution/duration"})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<VoucherDurationDistributionOpenApiVO>>> getVoucherDistributionByDuration(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="filters.timeStart", description="Filter query parameters, support field time range: start timestamp (second).") @RequestParam(name="filters.timeStart") Long filtersTimeStart, @Parameter(name="filters.timeEnd", description="Filter query parameters, support field time range: end timestamp (second).") @RequestParam(name="filters.timeEnd") Long filtersTimeEnd) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=12)
    @Operation(summary="Get voucher currency candidates", description="Get voucher currency candidates.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups/currency-list"})
    @ResponseBody
    public DeferredResult<OperationResponse<CurrencyCandidatesOpenApiVO>> getVoucherCurrencyCandidates(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=13)
    @Operation(summary="Modify voucher currency", description="Modify voucher currency of the site.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/setting"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyHotspotSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody HotspotSiteSettingOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @com.a.a.a.a.a(a=14)
    @Operation(summary="Get a voucher", description="Get a voucher with the given params.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/vouchers/{id}"})
    @ResponseBody
    public DeferredResult<OperationResponse<VoucherOpenApiVO>> getVoucher(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="id", description="Voucher ID") @PathVariable(name="id") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=15)
    @Operation(summary="Delete an existing voucher", description="Delete an existing voucher with the given params.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/vouchers/{id}"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteVoucher(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="id", description="Voucher ID") @PathVariable(name="id") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=16)
    @Operation(summary="Delete selected vouchers", description="Delete selected vouchers with the given params.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/vouchers/batch/delete"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteVouchers(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody SelectIdsOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @com.a.a.a.a.a(a=17)
    @Operation(summary="Get selected vouchers in a voucher group", description="Get selected vouchers brief in a voucher group.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/vouchers/batch/print"})
    @ResponseBody
    public DeferredResult<OperationResponse<List<VoucherBriefOpenApiVO>>> printVouchers(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody SelectIdsOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @com.a.a.a.a.a(a=18)
    @Operation(summary="Get voucher group config limit", description="Get voucher group config limit.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups/config-limit"})
    @ResponseBody
    public DeferredResult<OperationResponse<List<VoucherConfigLimitOpenApiVO>>> getGroupConfigLimit(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=19)
    @Operation(summary="Delete expired vouchers in a voucher group", description="Delete expired vouchers in a voucher group.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups/{groupId}/clear-invalid"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> clearInvalidVouchersInaGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="groupId", description="Voucher Group ID") @PathVariable(name="groupId") String groupId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=20)
    @Operation(summary="Delete expired vouchers in voucher groups", description="Delete expired vouchers in selected voucher group.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups/batch/clear-invalid"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> clearInvalidVouchersInSelectedGroups(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody SelectVoucherGroupOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @com.a.a.a.a.a(a=21)
    @Operation(summary="Export voucher list to file", description="Export voucher list to file.")
    @a(a={b.SITE_BUSY, b.ACCESS_TOKEN_EXPIRED, b.INVALID_GRANT_TYPE, b.INVALID_SITE_ID}, b={k.DATA_EXPORT})
    @PostMapping(path={"/openapi/v1/{omadacId}/files/hotspot/sites/{siteId}/vouchers/export"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> exportVouchersWithSiteByCloudAccess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ExportVoucherOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @com.a.a.a.a.a(a=22)
    @Operation(summary="Edit voucher group pattern", description="Edit vouvhcer group pattern.")
    @a(a={b.VOUCHER_PATTERN_LOGO_NOT_EXISTS, b.SSID_FOR_PORTAL_NOT_EXIST, b.VOUCHER_PATTERN_SSID_NETWORK_INVALID, b.LAN_NETWORK_FOR_PORTAL_NOT_EXIST}, b={k.HOTSPOT_WRITE})
    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/voucher-groups/{groupId}/pattern"})
    @ResponseBody
    public DeferredResult<OperationResponse> editVoucherGroupPattern(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody EditVoucherGroupPatternOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Upload voucher logo", description="Upload voucher logo")
    @a(b={k.HOTSPOT_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/files/voucher/logos"}, consumes={"multipart/form-data"})
    @ResponseBody
    @com.a.a.a.a.a(a=23)
    public DeferredResult<OperationResponse<PortalPictureVO>> uploadVoucherLogo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestPart(name="data") @Parameter(name="data", description="File name,,need to specify Content-Type of this form part as application/json.") UploadVoucherGroupLogoOpenApiVO uploadVoucherGroupLogoOpenApiVO, @RequestPart(name="file") @Parameter(name="file", description="At least one of the file or md5 parameters needs to be passed") MultipartFile file) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)uploadVoucherGroupLogoOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get voucher logo", description="Get voucher logo")
    @a(b={k.HOTSPOT_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/files/voucher/logos/{picId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=24)
    public DeferredResult<OperationResponse<Object>> getVoucherLogo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="picId", description="Voucher logo picture id") @PathVariable(name="picId") String picId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a(null), request, response, omadacId);
    }
}

