/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.hotspot;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.portal.api.openapi.vo.CreateLocalUserOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.CreatedResIdOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.HotspotPortalsOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.LocalUserOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.ModifyLocalUserOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="Local User")
@RestController
@b(a=11)
public class LocalUserOpenApiController {
    @Autowired
    private OpenApiHandler openApiHandler;
    public static final String USER_NAME = "user_name";

    @a(a=4)
    @Operation(summary="Get local user list", description="Get local user list in a site with the given omadacId, siteId, params.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/localusers"})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<LocalUserOpenApiVO>>> getLocalUsers(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortsName, @Parameter(name="searchKey", description="Fuzzy query parameters, support field user_name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=3)
    @Operation(summary="Get a local user for given localuserId", description="Get a local user with the given omadacId, siteId, local user ID.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_SITE_ID}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/localusers/{id}"})
    @ResponseBody
    public DeferredResult<OperationResponse<LocalUserOpenApiVO>> getLocalUser(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="id", description="local user ID") @PathVariable(name="id") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=1)
    @Operation(summary="Create a new local user", description="Create a local user with the given params.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY, com.tplink.smb.omada.common.g.b.ACCESS_TOKEN_EXPIRED, com.tplink.smb.omada.common.g.b.INVALID_GRANT_TYPE, com.tplink.smb.omada.common.g.b.INVALID_SITE_ID, com.tplink.smb.omada.common.g.b.EMPTY_PORTAL_BIND_LOCALUSER, com.tplink.smb.omada.common.g.b.INVALID_PORTAL_BIND_LOCALUSER, com.tplink.smb.omada.common.g.b.LOCAL_USER_NUM_EXCEED, com.tplink.smb.omada.common.g.b.LOCAL_USER_INVALID_MAC, com.tplink.smb.omada.common.g.b.DUPLICATE_LOCAL_USER_NAME}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/localusers"})
    @ResponseBody
    public DeferredResult<OperationResponse<CreatedResIdOpenApiVO>> createLocalUser(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateLocalUserOpenApiVO createLocalUserOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)createLocalUserOpenApiVO), request, response, omadacId);
    }

    @a(a=2)
    @Operation(summary="Delete an existing localuser", description="Delete an existing local user with the given omadacId, siteId, localuserId.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY, com.tplink.smb.omada.common.g.b.ACCESS_TOKEN_EXPIRED, com.tplink.smb.omada.common.g.b.INVALID_GRANT_TYPE, com.tplink.smb.omada.common.g.b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/localusers/{id}"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteLocalUser(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="id", description="Local user ID") @PathVariable(name="id") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=5)
    @Operation(summary="Modify an existing localuser", description="Modify an existing local user with the given omadacId, siteId, localuserId.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY, com.tplink.smb.omada.common.g.b.ACCESS_TOKEN_EXPIRED, com.tplink.smb.omada.common.g.b.INVALID_GRANT_TYPE, com.tplink.smb.omada.common.g.b.INVALID_SITE_ID, com.tplink.smb.omada.common.g.b.EMPTY_PORTAL_BIND_LOCALUSER, com.tplink.smb.omada.common.g.b.INVALID_PORTAL_BIND_LOCALUSER, com.tplink.smb.omada.common.g.b.LOCAL_USER_INVALID_MAC, com.tplink.smb.omada.common.g.b.DUPLICATE_LOCAL_USER_NAME}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/localusers/{id}"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyLocalUser(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="localUserId", description="Local user ID") @PathVariable(name="id") String id, @RequestBody ModifyLocalUserOpenApiVO modifyLocalUserOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyLocalUserOpenApiVO), request, response, omadacId);
    }

    @a(a=6)
    @Operation(summary="Clear dynamic mac", description="Clear dynamic mac with the given omadacId, siteId, localuserId. The mac address binding type should be dynamic binding.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY, com.tplink.smb.omada.common.g.b.ACCESS_TOKEN_EXPIRED, com.tplink.smb.omada.common.g.b.INVALID_GRANT_TYPE, com.tplink.smb.omada.common.g.b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/localusers/{id}/clear-dynamic-mac"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> clearLocalUserDynamicMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="localUserId", description="Local user ID") @PathVariable(name="id") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=7)
    @Operation(summary="Upload local user file (excel or csv) by localhost", description="Upload local user file (excel or csv) by localhost.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY, com.tplink.smb.omada.common.g.b.EMPTY_PORTAL_BIND_LOCALUSER, com.tplink.smb.omada.common.g.b.UPLOAD_FILTER_ADDRESS_FILE_EMPTY, com.tplink.smb.omada.common.g.b.INVALID_PERMISSION, com.tplink.smb.omada.common.g.b.INVALID_REQUEST_PARAMS, com.tplink.smb.omada.common.g.b.USER_NOT_LOGIN, com.tplink.smb.omada.common.g.b.GENERAL_ERROR, com.tplink.smb.omada.common.g.b.CONTROLLER_ID_NOT_EXIST, com.tplink.smb.omada.common.g.b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/files/hotspot/local-users"})
    @ResponseBody
    public DeferredResult<OperationResponse> uploadLocalUsers(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestPart(name="config") @Parameter(name="config", description="Bound portal ID list,need to specify Content-Type of this form part as application/json.") HotspotPortalsOpenApiVO hotspotPortalsVO, @RequestPart(name="file") @Parameter(name="file") MultipartFile file) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)hotspotPortalsVO), request, response, omadacId);
    }

    @a(a=8)
    @Operation(summary="Download local user file (excel or csv) by localhost", description="Download local user file (excel or csv) by localhost.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_REQUEST_PARAMS, com.tplink.smb.omada.common.g.b.GENERAL_ERROR, com.tplink.smb.omada.common.g.b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/files/hotspot/local-users"})
    @ResponseBody
    public DeferredResult<OperationResponse> downloadLocalUsers(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="portals", description="Portal ids of the portals to download local user file from.") @RequestParam(name="portals") String portals, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name,username") @RequestParam(name="searchKey", required=false) String searchKey, @Parameter(name="fileType", description="Local user file format: csv or xlsx.") @RequestParam(name="fileType") String fileType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

