/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.hotspot;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.gridquery.OpenApiQueryDataVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.portal.api.openapi.vo.CreateFormAuthOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.CreatedResIdOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.ExportFormOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.FormAuthOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.FormAuthResultOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.FormAuthResultSelectOpenApiVO;
import io.reactivex.Single;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Form Auth Data")
@RestController
@b(a=10)
public class FormAuthOpenApiController {
    @Autowired
    private OpenApiHandler openApiHandler;

    @a(a=1)
    @Operation(summary="Create a new authentication survey", description="Create a authentication survey in a site with the given params.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY, com.tplink.smb.omada.common.g.b.ACCESS_TOKEN_EXPIRED, com.tplink.smb.omada.common.g.b.INVALID_GRANT_TYPE, com.tplink.smb.omada.common.g.b.INVALID_SITE_ID, com.tplink.smb.omada.common.g.b.FORM_AUTH_CARD_EXCEED, com.tplink.smb.omada.common.g.b.FORM_AUTH_NUM_EXCEED, com.tplink.smb.omada.common.g.b.DUPLICATE_FORM_AUTH_NAME}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/surveys"})
    @ResponseBody
    public DeferredResult<OperationResponse<CreatedResIdOpenApiVO>> createAuthForm(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateFormAuthOpenApiVO createFormAuthOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)createFormAuthOpenApiVO), request, response, omadacId);
    }

    @a(a=2)
    @Operation(summary="Delete an existing authentication survey", description="Delete an existing authentication survey by the given omadacId, siteId, surveyId.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY, com.tplink.smb.omada.common.g.b.ACCESS_TOKEN_EXPIRED, com.tplink.smb.omada.common.g.b.INVALID_GRANT_TYPE, com.tplink.smb.omada.common.g.b.FORM_AUTH_NOT_EXIST, com.tplink.smb.omada.common.g.b.FORM_AUTH_IN_USE}, b={k.HOTSPOT_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/surveys/{surveyId}"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteAuthForm(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="surveyId", description="Auth survey ID") @PathVariable(name="surveyId") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=3)
    @Operation(summary="Get an authentication survey for given surveyId", description="Get an authentication survey by the given omadacId, siteId, surveyId.")
    @com.tplink.smb.omada.common.m.a(b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/surveys/{surveyId}"})
    @ResponseBody
    public DeferredResult<OperationResponse<FormAuthOpenApiVO>> getAuthForm(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="surveyId", description="Auth survey ID") @PathVariable(name="surveyId") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=4)
    @Operation(summary="Get authentication survey list", description="Get authentication survey list in a site by the given omadacId, siteId.")
    @com.tplink.smb.omada.common.m.a(b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/surveys"})
    @ResponseBody
    public DeferredResult<OperationResponse<List<FormAuthOpenApiVO>>> getAuthForms(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortsName, @Parameter(name="sorts.createTime", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.createTime", required=false) String sortsCreateTime, @Parameter(name="sorts.answerNum", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.answerNum", required=false) String sortsAnswerNum) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=6)
    @Operation(summary="Get authentication result lists for given survey", description="Get an authentication survey's result list with given omadacId, siteId, surveyId.")
    @com.tplink.smb.omada.common.m.a(b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/surveys/{surveyId}/auth-results"})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<FormAuthResultOpenApiVO>>> getFormAuthResults(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="surveyId", description="Auth survey ID") @PathVariable(name="surveyId") String id, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.formAuth", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.formAuth", required=false) String sortsFormAuth) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=5)
    @Operation(summary="Get an authentication survey result for given surveyResultId", description="Get an authentication survey's result in a site with given omadacId, siteId, surveyResultId.")
    @com.tplink.smb.omada.common.m.a(b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/surveys/auth-results/{surveyResultId}"})
    @ResponseBody
    public DeferredResult<OperationResponse<FormAuthResultOpenApiVO>> getFormAuthResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="surveyResultId", description="Survey authentication result ID") @PathVariable(name="surveyResultId") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=7)
    @Operation(summary="Modify an authentication survey for given surveyId", description="Modify an authentication survey in a site with given omadacId, siteId, surveyId.")
    @com.tplink.smb.omada.common.m.a(b={k.HOTSPOT_WRITE})
    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/surveys/{surveyId}"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyAuthForm(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="surveyId", description="Survey authentication ID") @PathVariable(name="surveyId") String id, @Parameter(name="survey", description="Survey authentication") @RequestBody CreateFormAuthOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @a(a=8)
    @Operation(summary="Delete an authentication survey result for given surveyResultId", description="Delete an authentication survey result in a site with given omadacId, siteId, surveyResultId.")
    @com.tplink.smb.omada.common.m.a(b={k.HOTSPOT_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/surveys/auth-results/{surveyResultId}"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteFormAuthResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="surveyResultId", description="Survey authentication result ID") @PathVariable(name="surveyResultId") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=9)
    @Operation(summary="Delete selected authentication survey results for given surveyId", description="Delete selected authentication survey results in a site with given omadacId, siteId, surveyId.")
    @com.tplink.smb.omada.common.m.a(b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/surveys/{surveyId}/auth-results"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteSelectedFormAuthResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="surveyId", description="Survey authentication ID") @PathVariable(name="surveyId") String id, @Parameter(name="selector", description="Selector of survey authentication result ID") @RequestBody FormAuthResultSelectOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @a(a=10)
    @Operation(summary="Export the Form Authentication Result List", description="Export the Form Authentication Result List.")
    @com.tplink.smb.omada.common.m.a(b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/files/hotspot/form-auths/{formId}/export"})
    @ResponseBody
    public DeferredResult<Single<OperationResponse>> exportAuthForms(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="formId", description="Form auth Id.") @PathVariable(name="formId") String formId, @Parameter(name="exportFormVO", description="Export Form Parameters") @RequestBody ExportFormOpenApiVO exportFormVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)exportFormVO), request, response, omadacId);
    }

    @a(a=11)
    @Operation(summary="Get Form Authentication Result", description="Get Form Authentication Result.")
    @com.tplink.smb.omada.common.m.a(b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/form-auths/{formId}/auth-results"})
    @ResponseBody
    public DeferredResult<OperationResponse> getGridFormAuthResults(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="formId", description="Form auth Id.") @PathVariable(name="formId") String formId, @Parameter(name="queryDataVO", description="Query Data") @RequestBody OpenApiQueryDataVO queryDataVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryDataVO), request, response, omadacId);
    }
}

