/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.hotspot;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.client.api.openapi.vo.AuthClientOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.AuthedClientsDeleteFilterOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ExportAuthedClientOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ExtendOpenApiVO;
import com.tplink.smb.omada.client.api.web.vo.HotspotStatisticVO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Authorized Client")
@RestController
@b(a=12)
public class ClientHotspotOpenApiController {
    @Autowired
    private OpenApiHandler openApiHandler;
    public static final String AUTH_RECORD_CLIENT_MAC = "client_mac";
    public static final String AUTH_RECORD_CLIENT_NAME = "client_name";
    public static final String VOUCHER_CODE = "voucher.code";
    public static final String LOCAL_USER_USER_NAME = "local_user.user_name";
    public static final String FORM_NAME = "form_name";
    public static final String AUTH_ADMIN = "auth_admin";
    public static final String SSID_NAME = "ssid_name";
    public static final String NETWORK_NAME = "network_name";

    @a(a=1)
    @Operation(summary="Authentication the given client", description="Authentication this client with the given omadacId, siteId, clientMac")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_PERMISSION, com.tplink.smb.omada.common.g.b.ACCESS_TOKEN_EXPIRED, com.tplink.smb.omada.common.g.b.INVALID_GRANT_TYPE, com.tplink.smb.omada.common.g.b.USER_NOT_LOGIN, com.tplink.smb.omada.common.g.b.CONTROLLER_ID_NOT_EXIST, com.tplink.smb.omada.common.g.b.SITE_BUSY, com.tplink.smb.omada.common.g.b.FORCE_AUTH_CLIENT_FAILED, com.tplink.smb.omada.common.g.b.FORCE_AUTH_CLIENT_NOT_EXIST, com.tplink.smb.omada.common.g.b.OPERATOR_NOT_EXIST, com.tplink.smb.omada.common.g.b.HOT_SPOT_LOGIN_AUTH_FAIL}, b={k.CLIENTS_WRITE, k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/clients/{clientMac}/auth"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> authClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC, format: AA-BB-CC-DD-EE-FF.") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=2)
    @Operation(summary="Cancel authentication the given client", description="Cancel the authentication of this client with the given omadacId, siteId, clientMac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_PERMISSION, com.tplink.smb.omada.common.g.b.ACCESS_TOKEN_EXPIRED, com.tplink.smb.omada.common.g.b.INVALID_GRANT_TYPE, com.tplink.smb.omada.common.g.b.USER_NOT_LOGIN, com.tplink.smb.omada.common.g.b.CONTROLLER_ID_NOT_EXIST, com.tplink.smb.omada.common.g.b.SITE_BUSY, com.tplink.smb.omada.common.g.b.UNAUTH_BY_CLIENTID_FAILED, com.tplink.smb.omada.common.g.b.UNAUTH_FAILED_GATEWAY_NOT_EXIST, com.tplink.smb.omada.common.g.b.UNAUTH_FAILED_TRY_AGAIN, com.tplink.smb.omada.common.g.b.UNAUTH_FAILED_CLIENT_UNAUTHING}, b={k.CLIENTS_WRITE, k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/clients/{clientMac}/unauth"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> cancelAuthClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=4)
    @Operation(summary="Get authentication record list", description="Get all authentication records in a site with the given omadacId, siteId.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_PERMISSION}, b={k.HOTSPOT_READ, k.INSIGHT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/authed-records"})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<AuthClientOpenApiVO>>> getHotspotAuthedClients(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortsName, @Parameter(name="sorts.mac", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.mac", required=false) String sortsMac, @Parameter(name="sorts.ip", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.ip", required=false) String sortsIp, @Parameter(name="sorts.authType", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.authType", required=false) String sortsAuthType, @Parameter(name="sorts.ssidOrNetwork", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.ssidOrNetwork", required=false) String sortsSsidOrNetwork, @Parameter(name="sorts.download", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.download", required=false) String sortsDownload, @Parameter(name="sorts.upload", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.upload", required=false) String sortsUpload, @Parameter(name="sorts.status", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.status", required=false) String sortsStatus, @Parameter(name="sorts.start", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.start", required=false) String sortsStart, @Parameter(name="sorts.end", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.end", required=false) String sortsEnd, @Parameter(name="sorts.duration", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.duration", required=false) String sortsDuration, @Parameter(name="searchKey", description="Fuzzy query parameters, support field client_mac,client_name,voucher.code,local_user.user_name,form_name,auth_admin,ssid_name,network_name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=3)
    @Operation(summary="Modify period for given authed record", description="Extend the valid time of the authentication record with the given omadacId, siteId, authClientId.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_PERMISSION, com.tplink.smb.omada.common.g.b.ACCESS_TOKEN_EXPIRED, com.tplink.smb.omada.common.g.b.INVALID_GRANT_TYPE, com.tplink.smb.omada.common.g.b.USER_NOT_LOGIN, com.tplink.smb.omada.common.g.b.CONTROLLER_ID_NOT_EXIST}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/authed-records/{id}/period"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> extendHotspotAuthedClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="id", description="Authed record ID") @PathVariable(name="id") String authRecordId, @RequestBody ExtendOpenApiVO extendVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)extendVO), request, response, omadacId);
    }

    @a(a=5)
    @Operation(summary="Delete given authed record", description="Delete the authentication record with the given omadacId, siteId, authClientId.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_SITE_ID, com.tplink.smb.omada.common.g.b.UNAUTH_FAILED_TRY_AGAIN, com.tplink.smb.omada.common.g.b.INVALID_REQUEST_PARAMS}, b={k.HOTSPOT_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/authed-records/{id}"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteHotspotAuthedClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="id", description="Authed record ID") @PathVariable(name="id") String authRecordId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=6)
    @Operation(summary="Delete all invalid authed record", description="Delete all authentication record withs the given omadacId, siteId, authClientId.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/authed-records/delete"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteAllInvalidAuthedClients(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="DeleteFilter") @RequestBody AuthedClientsDeleteFilterOpenApiVO deleteFilterOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deleteFilterOpenApiVO), request, response, omadacId);
    }

    @a(a=7)
    @Operation(summary="Disconnect authed client ", description="Disconnect the authentication record with the given omadacId, siteId, authClientId.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.UNAUTH_FAILED_TRY_AGAIN, com.tplink.smb.omada.common.g.b.INVALID_REQUEST_PARAMS, com.tplink.smb.omada.common.g.b.INVALID_SITE_ID}, b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/authed-records/{id}/disconnect"})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> disconnectHotspotAuthedClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=8)
    @Operation(summary="Export global authed client list", description="Export global authed client list with the given omadacId, siteId.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.CLOUD_ACCESS_EXPORT_DATA_TIMES_LIMITED, com.tplink.smb.omada.common.g.b.INVALID_REQUEST_PARAMS, com.tplink.smb.omada.common.g.b.INVALID_SITE_ID}, b={k.GLOBAL_DATA_EXPORT})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/authed-client-list"})
    @ResponseBody
    public DeferredResult<OperationResponse> exportAuthedClientListGlobalByCloudAccess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody ExportAuthedClientOpenApiVO exportAuthedClientOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)exportAuthedClientOpenApiVO), request, response, omadacId);
    }

    @a(a=9)
    @Operation(summary="Get hotspot statistic", description="Get hotspot statistic with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.INVALID_REQUEST_PARAMS}, b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/dashboard/statistics"})
    @ResponseBody
    public DeferredResult<OperationResponse<HotspotStatisticVO>> getHotspotStatistic(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start", required=false) Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end", required=false) Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

