/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.global.settings;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.LocalSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.manager.configuration.api.openapi.global.vo.CertificateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.global.vo.ControllerPortOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.global.vo.LoggingLevelOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.global.vo.PortalPortOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.global.vo.UpgradePortOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.omadac.global.DeviceAccessManagementVO;
import com.tplink.smb.omada.system.api.openapi.vo.ChannelUpgradeOpenApiVO;
import com.tplink.smb.omada.system.api.openapi.vo.ChannelUpgradeResOpenApiVO;
import com.tplink.smb.omada.system.api.openapi.vo.UploadCertificateOpenApiVO;
import com.tplink.smb.omada.system.api.openapi.vo.UploadSSLKeyOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="System Settings")
@RestController
@b(a=47)
@Conditional(value={LocalSwaggerMatchCondition.class})
public class LocalSystemSettingsOpenApiController {
    @Autowired
    private OpenApiHandler openApiHandler;

    @a(a=2)
    @Operation(summary="Check for update", description="Check for update.")
    @PostMapping(path={"/openapi/v1/{omadacId}/system/setting/channel-update"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_READ})
    public DeferredResult<OperationResponse<ChannelUpgradeResOpenApiVO>> checkForUpdate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @RequestBody ChannelUpgradeOpenApiVO channelUpgradeOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)channelUpgradeOpenApiVO), request, response, omadacId);
    }

    @a(a=3)
    @Operation(summary="Get certificate", description="Get certificate.")
    @GetMapping(path={"/openapi/v1/{omadacId}/system/setting/certificate"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_READ})
    public DeferredResult<OperationResponse<CertificateOpenApiVO>> getCertificate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=4)
    @Operation(summary="Upload certificate", description="Upload certificate, can not be used in MSP mode. Only support .pem, .pfx, .pem files. Certificate name should be the same as the file name.")
    @PostMapping(path={"/openapi/v1/{omadacId}/system/setting/certificate"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE})
    public DeferredResult<OperationResponse> uploadCertificate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @RequestParam(value="cerName") String cerName, @RequestParam(name="file") MultipartFile file) {
        UploadCertificateOpenApiVO uploadCertificateOpenApiVO = new UploadCertificateOpenApiVO();
        uploadCertificateOpenApiVO.setCerName(cerName);
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)uploadCertificateOpenApiVO), request, response, omadacId);
    }

    @a(a=5)
    @Operation(summary="Delete an existing certificate", description="Delete an existing certificate.")
    @DeleteMapping(path={"/openapi/v1/{omadacId}/system/setting/certificate/{cerId}"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE})
    public DeferredResult<OperationResponse> deleteCertificate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="cerId", description="Certificate ID") @PathVariable(value="cerId") String cerId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=6)
    @Operation(summary="Get logging", description="Get logging.")
    @GetMapping(path={"/openapi/v1/{omadacId}/system/setting/logging"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_READ})
    public DeferredResult<OperationResponse<LoggingLevelOpenApiVO>> getLogging(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=7)
    @Operation(summary="Modify logging", description="Modify logging.")
    @PatchMapping(path={"/openapi/v1/{omadacId}/system/setting/logging"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE})
    public DeferredResult<OperationResponse> modifyLogging(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @RequestBody LoggingLevelOpenApiVO loggingLevelOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)loggingLevelOpenApiVO), request, response, omadacId);
    }

    @a(a=8)
    @Operation(summary="Get controller port", description="Get controller port.")
    @GetMapping(path={"/openapi/v1/{omadacId}/system/setting/controller-port"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_READ})
    public DeferredResult<OperationResponse<ControllerPortOpenApiVO>> getControllerPort(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=9)
    @Operation(summary="Modify controller port", description="Modify controller port.")
    @PatchMapping(path={"/openapi/v1/{omadacId}/system/setting/controller-port"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE})
    public DeferredResult<OperationResponse> modifyControllerPort(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @RequestBody ControllerPortOpenApiVO controllerPortOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)controllerPortOpenApiVO), request, response, omadacId);
    }

    @a(a=10)
    @Operation(summary="Get portal port", description="Get portal port.")
    @GetMapping(path={"/openapi/v1/{omadacId}/system/setting/portal-port"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_READ})
    public DeferredResult<OperationResponse<PortalPortOpenApiVO>> getPortalPort(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=11)
    @Operation(summary="Modify portal port", description="Modify portal port.")
    @PatchMapping(path={"/openapi/v1/{omadacId}/system/setting/portal-port"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE})
    public DeferredResult<OperationResponse> modifyPortalPort(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @RequestBody PortalPortOpenApiVO portalPortOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portalPortOpenApiVO), request, response, omadacId);
    }

    @a(a=12)
    @Operation(summary="Upload SSL key", description="Upload SSL key, can not be used in MSP mode. Only support .pem files.")
    @PostMapping(path={"/openapi/v1/{omadacId}/system/setting/ssl-key"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE})
    public DeferredResult<OperationResponse> uploadSSLKey(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @RequestParam(value="keyName") String keyName, @RequestParam(name="file") MultipartFile file) {
        UploadSSLKeyOpenApiVO uploadSSLKeyOpenApiVO = new UploadSSLKeyOpenApiVO();
        uploadSSLKeyOpenApiVO.setKeyName(keyName);
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)uploadSSLKeyOpenApiVO), request, response, omadacId);
    }

    @a(a=13)
    @Operation(summary="Delete an existing SSL key", description="Delete an existing SSL key.")
    @DeleteMapping(path={"/openapi/v1/{omadacId}/system/setting/ssl-key/{keyId}"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE})
    public DeferredResult<OperationResponse> deleteSSLKey(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="keyId", description="SSL Key ID") @PathVariable(value="keyId") String keyId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=14)
    @Operation(summary="Get device access management", description="Get device access management.")
    @GetMapping(path={"/openapi/v1/{omadacId}/controller/setting/services/device-access"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_READ})
    public DeferredResult<OperationResponse<DeviceAccessManagementVO>> getDeviceAccessManagement(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=15)
    @Operation(summary="Modify device access management", description="Modify device access management.")
    @PatchMapping(path={"/openapi/v1/{omadacId}/controller/setting/services/device-access"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE})
    public DeferredResult<OperationResponse> modifyDeviceAccessManagement(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @RequestBody DeviceAccessManagementVO deviceAccessManagementVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deviceAccessManagementVO), request, response, omadacId);
    }

    @a(a=16)
    @Operation(summary="Get upgrade port", description="Get upgrade port.")
    @GetMapping(path={"/openapi/v1/{omadacId}/system/setting/upgrade-port"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_READ})
    public DeferredResult<OperationResponse<UpgradePortOpenApiVO>> getUpgradePort(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=17)
    @Operation(summary="Modify upgrade port", description="Modify upgrade port.")
    @PatchMapping(path={"/openapi/v1/{omadacId}/system/setting/upgrade-port"})
    @ResponseBody
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE})
    public DeferredResult<OperationResponse> modifyUpgradePort(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @RequestBody UpgradePortOpenApiVO upgradePortOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)upgradePortOpenApiVO), request, response, omadacId);
    }
}

