/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.devicetemplate;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.SiteTemplateSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan.LanNetworkSplitOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.LanNetworkOpenApiV2GridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.BatchModifyOswPortStatusVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.BatchModifyOswPortsNameVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.BatchModifyOswPortsPoeVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.BatchModifyProfileOverrideSettingVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.ModifyOswPortNameVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.ModifyOswPortPoeVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.ModifyOswPortProfileVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.ModifyOswPortStatusVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.ModifyProfileOverrideSettingVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswNetworkBriefInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswTemplateInfoVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswVrfConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswVrfOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.CreatePortTagOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.DeletePortTagOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.OswDetailOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.PortTagOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.BatchOswPortSettingVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswLagSettingVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswMacListVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswPortAndLagNetworkVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswPortSettingVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Switch (Template)")
@RestController
@Conditional(value={SiteTemplateSwaggerMatchCondition.class})
public class SwitchTemplateOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchTemplateOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get switch template info", description="Get switch template info.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST}, b={k.SITE_TEMPLATE_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}"})
    @com.a.a.a.a.a(a=1)
    @ResponseBody
    public DeferredResult<OperationResponse<OswTemplateInfoVO>> getSwitchTemplateInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Set name for given switch template port", description="Set name for given switch template port.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/ports/{port}/name"}, method={RequestMethod.PUT})
    @com.a.a.a.a.a(a=2)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> setNameForGivenPort(HttpServletRequest request, HttpServletResponse response, @RequestBody ModifyOswPortNameVO modifyOswPortNameVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @Parameter(name="port", description="Port ID") @PathVariable(name="port") String portStr) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyOswPortNameVO), request, response, omadacId);
    }

    @Operation(summary="Batch set name for given switch template ports", description="Batch set name for given switch template ports.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/multi-ports/name"}, method={RequestMethod.PUT})
    @com.a.a.a.a.a(a=3)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> batchSetNameForGivenPorts(HttpServletRequest request, HttpServletResponse response, @RequestBody BatchModifyOswPortsNameVO batchModifyOswPortsNameVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)batchModifyOswPortsNameVO), request, response, omadacId);
    }

    @Operation(summary="Set profile for given switch template port", description="Set profile for given switch template port.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/ports/{port}/profile"}, method={RequestMethod.PUT})
    @com.a.a.a.a.a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> setProfileForGivenPort(HttpServletRequest request, HttpServletResponse response, @RequestBody ModifyOswPortProfileVO modifyOswPortsProfileVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @Parameter(name="port", description="Port ID") @PathVariable(name="port") String portStr) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyOswPortsProfileVO), request, response, omadacId);
    }

    @Operation(summary="Set profile-override for given switch template port", description="Set profile-override for given switch template port.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/ports/{port}/profile-override"}, method={RequestMethod.PUT})
    @com.a.a.a.a.a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> setProfileOverrideForGivenPort(HttpServletRequest request, HttpServletResponse response, @RequestBody ModifyProfileOverrideSettingVO modifyProfileOverrideSettingVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @Parameter(name="port", description="Port ID") @PathVariable(name="port") String portStr) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyProfileOverrideSettingVO), request, response, omadacId);
    }

    @Operation(summary="Batch set profile-override for given switch template ports", description="Batch set profile-override for given switch template ports.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/multi-ports/profile-override"}, method={RequestMethod.PUT})
    @com.a.a.a.a.a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> batchSetProfileOverrideForGivenPorts(HttpServletRequest request, HttpServletResponse response, @RequestBody BatchModifyProfileOverrideSettingVO batchModifyProfileOverrideSettingVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)batchModifyProfileOverrideSettingVO), request, response, omadacId);
    }

    @Operation(summary="Set poe mode for given switch template port", description="Set poe mode for given switch template port. Please enable profile override first to use this interface.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST, b.PROFILE_OVERRIDE_DISABLED}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/ports/{port}/poe-mode"}, method={RequestMethod.PUT})
    @com.a.a.a.a.a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> setPoeModeForGivenPort(HttpServletRequest request, HttpServletResponse response, @RequestBody ModifyOswPortPoeVO modifyOswPortPoeVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyOswPortPoeVO), request, response, omadacId);
    }

    @Operation(summary="Batch set poe mode for given switch template ports", description="Batch set poe mode for given switch template ports. Please enable profile override first to use this interface.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST, b.PROFILE_OVERRIDE_DISABLED}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/multi-ports/poe-mode"}, method={RequestMethod.PUT})
    @com.a.a.a.a.a(a=8)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> batchSetPoeModeForGivenPorts(HttpServletRequest request, HttpServletResponse response, @RequestBody BatchModifyOswPortsPoeVO batchModifyOswPortsPoeVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)batchModifyOswPortsPoeVO), request, response, omadacId);
    }

    @Operation(summary="Set port status for given switch template port", description="Set port status for given switch template port. ")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST, b.MODIFY_STATUS_CHOSEN_PORT_OPT_INVALID}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/ports/{port}/status"}, method={RequestMethod.PUT})
    @com.a.a.a.a.a(a=9)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> setPortModeForGivenPort(HttpServletRequest request, HttpServletResponse response, @RequestBody ModifyOswPortStatusVO modifyOswPortStatusVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @Parameter(name="port", description="Port") @PathVariable(name="port") String portStr) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyOswPortStatusVO), request, response, omadacId);
    }

    @Operation(summary="Batch set status for given switch template ports", description="Batch set status for given switch template ports. ")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST, b.BATCH_MODIFY_CHOSEN_PORT_OPT_INVALID}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/multi-ports/status"}, method={RequestMethod.PUT})
    @com.a.a.a.a.a(a=10)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> batchSetPortStatusForGivenPorts(HttpServletRequest request, HttpServletResponse response, @RequestBody BatchModifyOswPortStatusVO batchModifyOswPortStatusVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)batchModifyOswPortStatusVO), request, response, omadacId);
    }

    @Operation(summary="Get the paging query for the osw templates with given network id and vlan", description="Get the paging query for the osw templates with given network id and vlan")
    @a(a={b.NETWORK_IS_NOT_EXISTED}, b={k.SITE_TEMPLATE_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/{networkId}/vlans/{vlan}/switches"})
    @com.a.a.a.a.a(a=11)
    @ResponseBody
    public DeferredResult<OperationResponse> getOswForGivenLanNetworkIdAndVlanTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="networkId") @PathVariable(name="networkId") String networkId, @Parameter(name="vlan", description="vlan") @PathVariable(name="vlan") String vlan) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify switch template port", description="Modify switch template port.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/ports/{port}"}, method={RequestMethod.PATCH})
    @com.a.a.a.a.a(a=12)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifySwitchPortTemplate(HttpServletRequest request, HttpServletResponse response, @RequestBody OswPortSettingVO settingVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @Parameter(name="port", description="Port ID") @PathVariable(name="port") String portStr) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)settingVO), request, response, omadacId);
    }

    @Operation(summary="Batch modify switch template port", description="Batch modify switch template port.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/multi-ports/config"}, method={RequestMethod.PATCH})
    @com.a.a.a.a.a(a=13)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> batchModifySwitchPortTemplate(HttpServletRequest request, HttpServletResponse response, @RequestBody BatchOswPortSettingVO settingVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)settingVO), request, response, omadacId);
    }

    @Operation(summary="Modify switch template lag", description="Modify switch template lag.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/lags/{lagId}"}, method={RequestMethod.PATCH})
    @com.a.a.a.a.a(a=14)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifySwitchLagTemplate(HttpServletRequest request, HttpServletResponse response, @RequestBody OswLagSettingVO settingVO, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @Parameter(name="lag", description="Lag ID") @PathVariable(name="lagId") String lagIdStr) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)settingVO), request, response, omadacId);
    }

    @Operation(summary="Delete switch template lag", description="Delete switch template lag.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.SWITCH_PORT_NOT_EXIST}, b={k.SITE_TEMPLATE_WRITE})
    @RequestMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/lags/{lagId}"}, method={RequestMethod.DELETE})
    @com.a.a.a.a.a(a=15)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteSwitchLagTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @Parameter(name="lag", description="Lag ID") @PathVariable(name="lagId") String lagIdStr) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a(null), request, response, omadacId);
    }

    @Operation(summary="Create new template port label", description="Create new template port label.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/port-tag"})
    @com.a.a.a.a.a(a=16)
    @ResponseBody
    public DeferredResult<PortTagOpenApiVO> addPortTagTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @RequestBody CreatePortTagOpenApiVO portTagOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portTagOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify an existing template port label", description="Modify an existing template port label.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/port-tag"})
    @com.a.a.a.a.a(a=17)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyPortTagTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @RequestBody PortTagOpenApiVO portTagOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portTagOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing template port label", description="Delete an existing template port label.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/port-tag"})
    @com.a.a.a.a.a(a=18)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deletePortTagTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @RequestBody DeletePortTagOpenApiVO portTagOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portTagOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get template port label list", description="Get template port label list.")
    @a(b={k.SITE_TEMPLATE_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/port-tag"})
    @com.a.a.a.a.a(a=19)
    @ResponseBody
    public DeferredResult<List<PortTagOpenApiVO>> getPortTagTemplates(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the networks used on switch template's ports and LAGs", description="Get the networks used on switch template's ports and LAGs.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST}, b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/port-lag-networks"})
    @com.a.a.a.a.a(a=20)
    @ResponseBody
    public DeferredResult<GridVO<OswNetworkBriefInfoOpenApiVO>> getGridPortAndLagNetworks(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the switch template's ports and LAGs that the network affects", description="Get the switch template's ports and LAGs that the network affects.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST, b.NETWORK_IS_NOT_EXISTED}, b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/port-lag-networks/{networkId}/vlan/{vlan}"})
    @com.a.a.a.a.a(a=21)
    @ResponseBody
    public DeferredResult<OswPortAndLagNetworkVO> getPortAndLagNetwork(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @Parameter(name="networkId", description="Switch network ID.") @PathVariable(name="networkId") String networkId, @Parameter(name="vlan", description="VLAN.") @PathVariable(name="vlan") String vlanStr) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the networks existing on the switch template", description="Get the networks existing on the switch template.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST}, b={k.SITE_TEMPLATE_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/exist-network"})
    @com.a.a.a.a.a(a=22)
    @ResponseBody
    public DeferredResult<OperationResponse<LanNetworkOpenApiV2GridVO<LanNetworkSplitOpenApiVO>>> getSwitchTemplateExistNetworks(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the networks intersections existing on multiple switch templates", description="Get the networks intersections existing on multiple switch templates.")
    @a(a={b.DEVICE_TEMPLATE_NOT_EXIST}, b={k.SITE_TEMPLATE_READ})
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/exist-network"})
    @com.a.a.a.a.a(a=23)
    @ResponseBody
    public DeferredResult<OperationResponse<LanNetworkOpenApiV2GridVO<LanNetworkSplitOpenApiVO>>> getBatchSwitchTemplateExistNetworks(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @RequestBody OswMacListVO macListVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)macListVO), request, response, omadacId);
    }

    @Operation(summary="Get the details of osw templates with given omadacid, siteid and macs and stackIds.", description="Get the details of osw templates with given omadacid, siteid and macs and stackIds.")
    @a(a={}, b={k.SITE_TEMPLATE_READ})
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switches/details"})
    @com.a.a.a.a.a(a=24)
    @ResponseBody
    public DeferredResult<OperationResponse> getOswsDetailsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @RequestBody OswDetailOpenApiVO oswDetailOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)oswDetailOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get the vrfs on the switch template", description="Get the vrfs on the switch template.")
    @a(a={}, b={k.SITE_TEMPLATE_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/vrfs"})
    @com.a.a.a.a.a(a=25)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<OswVrfOpenApiVO>>> getGridVrfTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new vrf template", description="Create new vrf template.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/vrfs"})
    @com.a.a.a.a.a(a=26)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createOswVrfTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @RequestBody OswVrfConfigOpenApiVO vrfConfigOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vrfConfigOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify vrf template", description="Modify vrf template.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/vrfs/{vrfId}"})
    @com.a.a.a.a.a(a=27)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyOswVrfTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @Parameter(name="vrfId", description="VRF ID") @PathVariable(name="vrfId") String vrfId, @RequestBody OswVrfConfigOpenApiVO vrfConfigOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vrfConfigOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete vrf template", description="Delete vrf template.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switchtemplates/{deviceTemplateId}/vrfs/{vrfId}"})
    @com.a.a.a.a.a(a=28)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteOswVrfTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(value="siteTemplateId") String siteTemplateId, @Parameter(name="deviceTemplateId", description="Device Template ID") @PathVariable(name="deviceTemplateId") String deviceTemplateId, @Parameter(name="vrfId", description="VRF ID") @PathVariable(name="vrfId") String vrfId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

