/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.device.devicemanagement;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.AllSitesOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.AutoCheckUpgradeCreateOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.AutoCheckUpgradeOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.CreateAutoCheckResVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.CreateFailedDeviceUpgradePlanResOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.CreateUpgradePlanResVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.CriticalModelNumOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.EditUpgradeFirmwareInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.FailedDeviceUpgradeFwInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.FailedModelPlanUpgradeCreateOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.FirmwareInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.ModelFirmwarePoolGridOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.ModelFwOemReleaseNoteOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.ModelFwReleaseNoteReqOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.ModelLatestFwInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.ModelTypeInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.ModelUpgradeInfoReqOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.ModelUpgradeSiteOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.ModelUpgradeSiteReqOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.PlanFirmwareUpgradeCreateOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.PlanUpgradeCreateOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.PlanUpgradeEditOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.PlanUpgradeModelInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.PlanUpgradeModelListOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.PlanUpgradeOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.RollbackCreateOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.UpgradeFailedDeviceInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.UpgradeFirmwareInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.UpgradeLogOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.UpgradeSettingTryBetaOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.UpgradeSiteModelOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.UpgradeSiteModelReqOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.UploadFirmwareResOpenApiVO;
import io.micrometer.common.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="Firmware")
@RestController
@com.a.a.a.a.b(a=36)
public class FirmwareUpgradeOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirmwareUpgradeOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get the number of critical models", description="You can get the number of critical models.")
    @GetMapping(path={"/openapi/v1/{omadacId}/upgrade/overview/critical"})
    @com.a.a.a.a.a(a=1)
    @a(a={b.PLATFORM_SERVER_ERROR}, b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<CriticalModelNumOpenApiVO>> getcriticalModelNum(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get firmware upgrade logs", description="Paging to get firmware upgrade logs.")
    @GetMapping(value={"/openapi/v1/{omadacId}/upgrade/overview/logs"})
    @com.a.a.a.a.a(a=2)
    @a(a={b.CONTROLLER_ID_NOT_EXIST}, b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<UpgradeLogOpenApiVO>>> getGridUpgradeLogs(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.upgradeTime", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.upgradeTime", required=false) String sortsUpgradeTime, @Parameter(name="sorts.modelTypeInfo", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.modelTypeInfo", required=false) String sortsModelTypeInfo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the list of devices which upgrade failed", description="Get the list of devices which upgrade failed through upgrade logs")
    @GetMapping(path={"/openapi/v1/{omadacId}/logs/{upgradeLogId}/upgrade/overview/failed-devices"})
    @com.a.a.a.a.a(a=3)
    @a(b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<UpgradeFailedDeviceInfoOpenApiVO>>> getUpgradeFailedDeviceInfos(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="upgradeLogId", description=" The Upgrade log ID obtained from the interface (Get firmware upgrade logs)") @PathVariable(name="upgradeLogId") String upgradeLogId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create rollback plan", description="You can choose a specific time to create a rollback plan")
    @PostMapping(value={"/openapi/v1/{omadacId}/logs/{upgradeLogId}/upgrade/overview/rollback"})
    @com.a.a.a.a.a(a=4)
    @a(a={b.CONTROLLER_ID_NOT_EXIST}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createRollback(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="upgradeLogId", description=" The Upgrade log ID obtained from the interface (Get firmware upgrade logs)") @PathVariable(name="upgradeLogId") String upgradeLogId, @RequestBody RollbackCreateOpenApiVO rollbackCreateOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)rollbackCreateOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get firmware upgrade plans", description="Paging to get firmware upgrade plans.")
    @GetMapping(value={"/openapi/v1/{omadacId}/upgrade/overview/plans"})
    @com.a.a.a.a.a(a=5)
    @a(b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<PlanUpgradeOpenApiVO>>> getGridUpgradePlans(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.scheduledUpgradeTime", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.scheduledUpgradeTime", required=false) String sortsScheduledUpgradeTime, @Parameter(name="sorts.modelTypeInfo", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.modelTypeInfo", required=false) String sortsModelTypeInfo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create firmware upgrade plan", description="Create firmware upgrade plan.")
    @PostMapping(value={"/openapi/v1/{omadacId}/upgrade/overview/plans"})
    @com.a.a.a.a.a(a=6)
    @a(a={b.SYSTEM_BUSY}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponse<CreateUpgradePlanResVO>> createUpgradePlan(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody PlanUpgradeCreateOpenApiVO planUpgradeCreateOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)planUpgradeCreateOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Edit firmware upgrade plan", description="Edit firmware upgrade plan.")
    @PatchMapping(value={"/openapi/v1/{omadacId}/plans/{planId}/upgrade/overview"})
    @com.a.a.a.a.a(a=7)
    @a(a={b.INVALID_PERMISSION, b.SYSTEM_BUSY}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> editUpgradePlan(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="planId", description="Upgrade Plan ID") @PathVariable(name="planId") String planId, @RequestBody PlanUpgradeEditOpenApiVO planUpgradeEditOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)planUpgradeEditOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete firmware upgrade plan", description="Delete firmware upgrade plan.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/plans/{planId}/upgrade/overview"})
    @com.a.a.a.a.a(a=8)
    @a(a={b.SYSTEM_BUSY}, b={k.DEVICES_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteUpgradePlan(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="planId", description="Upgrade Plan ID") @PathVariable(name="planId") String planId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get try-beta switch status", description="You can get try-beta switch status")
    @GetMapping(path={"/openapi/v1/{omadacId}/upgrade/overview/try-beta"})
    @com.a.a.a.a.a(a=9)
    @a(b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<UpgradeSettingTryBetaOpenApiVO>> getTryBetaStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify try-beta switch status", description="You can modify the try-beta switch status")
    @PatchMapping(path={"/openapi/v1/{omadacId}/upgrade/overview/try-beta"})
    @com.a.a.a.a.a(a=10)
    @a(a={b.FIRMWARE_UPGRADE_TRY_BETA_CANNOT_TURN_OFF}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyTryBetaStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody UpgradeSettingTryBetaOpenApiVO upgradeSettingTryBetaOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)upgradeSettingTryBetaOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get firmware pool list", description="Paging to get firmware pool list")
    @GetMapping(path={"/openapi/v1/{omadacId}/upgrade/overview/firmwares"})
    @com.a.a.a.a.a(a=11)
    @a(a={b.PLATFORM_SERVER_ERROR}, b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<ModelFirmwarePoolGridOpenApiVO<ModelLatestFwInfoOpenApiVO>>> getGridFirmwarePoolList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="channel", description="Channel should be a value as follows: 0: stable; 1: Release Candidate(RC); 2: Beta.") @RequestParam(name="channel") Integer channel, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.modelTypeInfo", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.modelTypeInfo", required=false) String sortsModelTypeInfo, @Parameter(name="sorts.releaseTime", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.releaseTime", required=false) String sortsReleaseTime) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get release notes information", description="Get release notes information of a firmware series")
    @PostMapping(path={"/openapi/v1/{omadacId}/upgrade/overview/firmwares/release-note"})
    @com.a.a.a.a.a(a=12)
    @a(a={b.PLATFORM_SERVER_ERROR}, b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<ModelFwOemReleaseNoteOpenApiVO>> getModelFirmwareReleaseNotes(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody ModelFwReleaseNoteReqOpenApiVO modelFwReleaseNoteReqOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modelFwReleaseNoteReqOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get the list of models", description="Get the list of models on the Controller upgrade plan page.")
    @GetMapping(value={"/openapi/v1/{omadacId}/upgrade/plan/models"})
    @com.a.a.a.a.a(a=13)
    @a(a={b.PLATFORM_SERVER_ERROR}, b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<PlanUpgradeModelListOpenApiVO>>> getGridPlanUpgradeModelList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.modelTypeInfo", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.modelTypeInfo", required=false) String sortsModelTypeInfo, @Parameter(name="searchKey", description="Fuzzy query parameters, support field upgrade") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the upgradeable information of the selected model", description="Get the upgradeable information of the selected model.")
    @PostMapping(value={"/openapi/v1/{omadacId}/upgrade/plan/firmware"})
    @com.a.a.a.a.a(a=14)
    @a(a={b.PLATFORM_SERVER_ERROR}, b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<PlanUpgradeModelInfoOpenApiVO>> getPlanUpgradeModelInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody ModelUpgradeInfoReqOpenApiVO modelUpgradeInfoReqOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modelUpgradeInfoReqOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get the sites of the selected model", description="Paging to get the sites of the selected model")
    @PostMapping(value={"/openapi/v1/{omadacId}/upgrade/plan/sites"})
    @com.a.a.a.a.a(a=15)
    @a(b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<ModelUpgradeSiteOpenApiVO>> getGridPlanUpgradeSiteList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody ModelUpgradeSiteReqOpenApiVO modelUpgradeSiteReqOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modelUpgradeSiteReqOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get autocheck upgrade plan", description="Paging to get autocheck upgrade plan")
    @GetMapping(path={"/openapi/v1/{omadacId}/upgrade/autoCheck"})
    @com.a.a.a.a.a(a=16)
    @a(a={b.CONTROLLER_ID_NOT_EXIST}, b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<AutoCheckUpgradeOpenApiVO>>> getGridAutoCheckUpgrade(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.autoCheckTime", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.autoCheckTime", required=false) String sortsAutoCheckTime, @Parameter(name="searchKey", description="Fuzzy query parameters, support field upgrade") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create autocheck upgrade plan", description="Create autocheck upgrade plan")
    @PostMapping(path={"/openapi/v1/{omadacId}/upgrade/autoCheck"})
    @com.a.a.a.a.a(a=17)
    @a(a={b.SYSTEM_BUSY, b.CONTROLLER_ID_NOT_EXIST, b.EMPTY_SELECT_SITE_LIST}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponse<CreateAutoCheckResVO>> createAutoCheckUpgrade(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody AutoCheckUpgradeCreateOpenApiVO autoCheckUpgradeCreateOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)autoCheckUpgradeCreateOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Edit autoCheck upgrade plan", description="Edit autoCheck upgrade plan")
    @PatchMapping(path={"/openapi/v1/{omadacId}/autoCheck/{autoCheckId}/upgrade"})
    @com.a.a.a.a.a(a=18)
    @a(a={b.INVALID_PERMISSION}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> editAutoCheckUpgrade(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="autoCheckId", description="Auto Check ID") @PathVariable(name="autoCheckId") String autoCheckId, @RequestBody AutoCheckUpgradeCreateOpenApiVO autoCheckUpgradeCreateOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)autoCheckUpgradeCreateOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete autoCheck upgrade plan", description="Delete autoCheck upgrade plan")
    @DeleteMapping(path={"/openapi/v1/{omadacId}/autoCheck/{autoCheckId}/upgrade"})
    @com.a.a.a.a.a(a=19)
    @a(a={b.SYSTEM_BUSY, b.CONTROLLER_ID_NOT_EXIST, b.INVALID_PERMISSION}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteAutoCheckUpgrade(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="autoCheckId", description="Auto Check ID") @PathVariable(name="autoCheckId") String autoCheckId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the model of the specified site", description="Get the model of the specified site. If no site is specified, it defaults to all authorized sites")
    @PostMapping(path={"/openapi/v1/{omadacId}/upgrade/models"})
    @com.a.a.a.a.a(a=20)
    @a(b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<UpgradeSiteModelOpenApiVO>> getModelBySites(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody UpgradeSiteModelReqOpenApiVO upgradeSiteModelReqOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)upgradeSiteModelReqOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get the uploaded firmware list", description="Paging to get the uploaded firmware list")
    @GetMapping(path={"/openapi/v1/{omadacId}/upgrade/firmwares"})
    @com.a.a.a.a.a(a=21)
    @a(b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<FirmwareInfoOpenApiVO>>> getGridFirmwareList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.modelTypeInfo", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.modelTypeInfo", required=false) String sortsModelTypeInfo, @Parameter(name="sorts.uploadTime", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.uploadTime", required=false) String sortsUploadTime, @Parameter(name="searchKey", description="Fuzzy query parameters, support field upgrade") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Upload upgrade firmware", description="Upload upgrade firmware")
    @PostMapping(path={"/openapi/v1/{omadacId}/files/upgrade/firmware"})
    @com.a.a.a.a.a(a=22)
    @a(a={b.UPGRADE_INCORRECT_FIRMWARE, b.UPGRADE_FILE_TOO_LARGE, b.UPLOAD_FILE_FAILED}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponse<UploadFirmwareResOpenApiVO>> uploadUpgradeFirmware(@RequestPart(value="file", required=false) @Parameter(name="file", description="Firmware file.") MultipartFile file, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="description", description="Description of upload firmware") @RequestParam(name="description") String description, @Parameter(name="showModel", description="ShowModel of upload firmware, you can also get this field throw: \"Get the model of the specified site\"") @RequestParam(name="showModel") String showModel, @Parameter(name="compoundModel", description="CompoundModel of upload firmware, you can also get this field throw: \"Get the model of the specified site\"") @RequestParam(name="compoundModel") String compoundModel, @Parameter(name="targetEnable", description="Do the sites set up specified firmware, it should be a value as follows: true, false") @RequestParam(name="targetEnable") Boolean targetEnable, @Parameter(name="targetSites", description="A string of target site IDs separated by commas, exists when 'targetEnable' is true.") @RequestParam(name="targetSites", required=false) String targetSites) {
        ModelTypeInfoOpenApiVO modelTypeInfoOpenApiVO = new ModelTypeInfoOpenApiVO();
        modelTypeInfoOpenApiVO.setShowModel(showModel);
        modelTypeInfoOpenApiVO.setCompoundModel(compoundModel);
        UpgradeFirmwareInfoOpenApiVO upgradeFirmwareInfoOpenApiVO = new UpgradeFirmwareInfoOpenApiVO();
        upgradeFirmwareInfoOpenApiVO.setDescription(description);
        upgradeFirmwareInfoOpenApiVO.setModelTypeInfo(modelTypeInfoOpenApiVO);
        upgradeFirmwareInfoOpenApiVO.setTargetEnable(targetEnable);
        if (StringUtils.isNotEmpty((String)targetSites)) {
            String[] targetSitesSplit = targetSites.split(",");
            List<String> targetSitesList = Arrays.asList(targetSitesSplit);
            upgradeFirmwareInfoOpenApiVO.setTargetSites(targetSitesList);
        }
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)upgradeFirmwareInfoOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Create firmware upgrade plan based on manually uploaded firmware", description="Create an upgrade plan based on manually uploaded firmware")
    @PostMapping(path={"/openapi/v1/{omadacId}/firmwares/{firmwareId}/upgrade/plan"})
    @com.a.a.a.a.a(a=23)
    @a(a={b.SYSTEM_BUSY, b.UPGRADE_FILE_IS_NULL, b.CONTROLLER_ID_NOT_EXIST, b.EMPTY_SELECT_SITE_LIST}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponse<CreateUpgradePlanResVO>> createFirmwareUpgradePlan(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="firmwareId", description="Firmware ID") @PathVariable(name="firmwareId") String firmwareId, @RequestBody PlanFirmwareUpgradeCreateOpenApiVO planFirmwareUpgradeCreateOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)planFirmwareUpgradeCreateOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete upgrade firmware", description="Delete the manually uploaded firmware")
    @DeleteMapping(path={"/openapi/v1/{omadacId}/firmwares/{firmwareId}/upgrade"})
    @com.a.a.a.a.a(a=24)
    @a(a={b.SYSTEM_BUSY}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteUpgradeFirmware(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="firmwareId", description="Firmware ID") @PathVariable(name="firmwareId") String firmwareId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get firmware information about the failed device to be upgraded", description="Get firmware information about the failed device to be upgraded")
    @GetMapping(path={"/openapi/v1/{omadacId}/logs/{upgradeLogId}/upgrade/overview/failed-model-firmware"})
    @com.a.a.a.a.a(a=25)
    @a(a={b.SYSTEM_BUSY, b.INVALID_REQUEST_PARAMS, b.FIRMWARE_EXIST_TARGET}, b={k.FIRMWARE_MANAGER_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<FailedDeviceUpgradeFwInfoOpenApiVO>> getUpgradeFailedDeviceFirmwareInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="upgradeLogId", description=" The Upgrade log ID obtained from the interface (Get firmware upgrade logs)") @PathVariable(name="upgradeLogId") String upgradeLogId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create Upgrade Plan for Failed Device", description="Create Upgrade Plan for Failed Device")
    @PostMapping(path={"/openapi/v1/{omadacId}/logs/{upgradeLogId}/upgrade/overview/failed-model-plan"})
    @com.a.a.a.a.a(a=26)
    @a(a={b.SYSTEM_BUSY, b.INVALID_PERMISSION, b.INVALID_REQUEST_PARAMS, b.UPGRADE_FIRMWARE_HAS_BEEN_DELETED}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponse<CreateFailedDeviceUpgradePlanResOpenApiVO>> createFailedDeviceModelPlan(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="upgradeLogId", description=" The Upgrade log ID obtained from the interface (Get firmware upgrade logs)") @PathVariable(name="upgradeLogId") String upgradeLogId, @RequestBody FailedModelPlanUpgradeCreateOpenApiVO failedModelPlanUpgradeCreateOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)failedModelPlanUpgradeCreateOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Check the limit of the firmware pool", description="Check the limit of the firmware pool")
    @PostMapping(path={"/openapi/v1/{omadacId}/upgrade/firmware-size/{firmwareSize}"})
    @com.a.a.a.a.a(a=27)
    @a(a={b.FIRMWARE_FILE_SIZE_EXCEEDED_LIMIT, b.INVALID_REQUEST_PARAMS}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> checkUploadUpgradeFirmwareLimit(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="firmwareSize", description="firmwareSize") @PathVariable(name="firmwareSize") String firmwareSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Edit the uploaded firmware", description="Edit the uploaded firmware")
    @PostMapping(path={"/openapi/v1/{omadacId}/upgrade/firmwares/{firmwareId}"})
    @com.a.a.a.a.a(a=28)
    @a(a={b.SYSTEM_BUSY, b.UPGRADE_FILE_IS_NULL, b.INVALID_REQUEST_PARAMS}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> editFirmwareUpgrade(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="firmwareId", description="Firmware ID") @PathVariable(name="firmwareId") String firmwareId, @RequestBody EditUpgradeFirmwareInfoOpenApiVO editUpgradeFirmwareInfoOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)editUpgradeFirmwareInfoOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get all sites of target firmware", description="Get all sites of target firmware")
    @GetMapping(path={"/openapi/v1/{omadacId}/upgrade/firmwares/{firmwareId}/target-sites"})
    @com.a.a.a.a.a(a=29)
    @a(a={b.UPGRADE_FILE_IS_NULL, b.INVALID_REQUEST_PARAMS}, b={k.FIRMWARE_MANAGER_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponse<AllSitesOpenApiVO>> getTargetFirmwareAllSites(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="firmwareId", description="Firmware ID") @PathVariable(name="firmwareId") String firmwareId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

