/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.device.devicemanagement;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.controller.device.devicemanagement.DeviceFirmwareOpenApiVO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.CheckFirmwareResOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.ManuallyUpgradeReqOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.ManuallyUpgradeResOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.OnlineRollingUpgradeOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.OnlineUpgradeResOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.RollingUpgradeResOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.UpgradeTaskOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.UploadUpgradeFileResOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="Device")
@RestController
@b(a=22)
public class DeviceUpgradeOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceUpgradeOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Start check latest firmware for all devices", description="Start a task to query the latest firmware of all devices in the cloud.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/all-devices/start-check-latest-firmware"})
    @a(a=101)
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponse<UpgradeTaskOpenApiVO>> onlineCheckUpgrade(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the result of the given check latest firmware task", description="Get the result of the firmware update task, containing a list of devices with firmware updates")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/all-devices/check-latest-firmware-tasks/{taskId}"})
    @a(a=102)
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponse<CheckFirmwareResOpenApiVO>> getCheckFirmwareTaskResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="taskId", description="Task ID. The ID is the return value of 'Start check latest firmware for all devices' interface") @PathVariable(name="taskId") String taskId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the latest firmware info of the device", description="Get latest firmware info of the device, including the latest firmware version and release logs.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.DEVICE_NOT_EXIST}, b={k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/latest-firmware-info"})
    @a(a=103)
    @ResponseBody
    public DeferredResult<OperationResponse<DeviceFirmwareOpenApiVO>> getFirmwareInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Start online upgrade", description="Upgrade the device with the latest firmware in the cloud. It is suggested to check firmware update before the operation, or the firmware might not be the latest")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.UPGRADE_UNSUPPORT_VER_ERROR, com.tplink.smb.omada.common.g.b.UPGRADE_NO_DEVICE_READY}, b={k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/start-online-upgrade"})
    @a(a=104)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> onlineUpgrade(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get online upgrade result", description="Get the result of the online upgrade.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/online-upgrade-result"})
    @a(a=105)
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponse<OnlineUpgradeResOpenApiVO>> getOnlineUpgradeRes(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Start batch rolling upgrade", description="Batch online upgrade the devices in a certain order in the site. It is suggested to check firmware update before the operation, or the firmware might not be the latest")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.UPGRADE_NO_DEVICE_READY}, b={k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/multi-devices/start-rolling-upgrade"})
    @a(a=106)
    @ResponseBody
    public DeferredResult<OperationResponse<UpgradeTaskOpenApiVO>> onlineRollingUpgrade(@RequestBody OnlineRollingUpgradeOpenApiVO deviceList, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deviceList), request, response, omadacId);
    }

    @Operation(summary="End the rolling upgrade task", description="Cancel the rolling upgrade task in the site. But the devices which have completed the upgrade will not be rolled back to the old version")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/multi-devices/rolling-upgrade-tasks/{taskId}"})
    @a(a=108)
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> cancelRollingUpgrade(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="taskId", description="Task ID. The ID is the return value of 'Start batch rolling upgrade' interface.") @PathVariable(name="taskId") String taskId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the result of the given rolling upgrade task", description="Get the result of the rolling upgrade task. The results include whether the task is finished and how many devices have not completed the upgrade.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/multi-devices/rolling-upgrade-tasks/{taskId}"})
    @a(a=107)
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponse<RollingUpgradeResOpenApiVO>> getRollingUpgradeRes(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="taskId", description="Task ID. The ID is the return value of 'Start batch rolling upgrade' interface.") @PathVariable(name="taskId") String taskId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Upload device firmware", description="Upload device firmware for manually upgrade.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.UPGRADE_FILE_IS_NULL, com.tplink.smb.omada.common.g.b.UPGRADE_FILE_TOO_LARGE}, b={k.MANUAL_UPGRADE_ACCESS})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/upgrade-file"}, consumes={"multipart/form-data"})
    @a(a=109)
    @ResponseBody
    public DeferredResult<OperationResponse<UploadUpgradeFileResOpenApiVO>> uploadUpgradeFile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestPart(value="file") @Parameter(description="Upload a file in request body.", required=true) MultipartFile file) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Start manually upgrade", description="Manually upgrade the devices of the same model in the site. The firmware needs to be uploaded first. Note: Each site can only execute one multi-device upgrade task at a time, and there is a number limit of the tasks that can be executed simultaneously in the controller.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.UPGRADE_NO_DEVICE_READY, com.tplink.smb.omada.common.g.b.FILE_EXPIRED, com.tplink.smb.omada.common.g.b.DEVICE_NOT_EXIST}, b={k.MANUAL_UPGRADE_ACCESS})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/multi-devices/start-manually-upgrade"})
    @a(a=110)
    @ResponseBody
    public DeferredResult<OperationResponse<UpgradeTaskOpenApiVO>> manuallyUpgrade(@RequestBody ManuallyUpgradeReqOpenApiVO req, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)req), request, response, omadacId);
    }

    @Operation(summary="Get the result of the given manually upgrade task", description="Get the result of the manually upgrade task. The results include whether the task is finished and how many devices have not completed the upgrade.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/multi-devices/manually-upgrade-tasks/{taskId}"})
    @a(a=111)
    @com.tplink.smb.omada.common.m.a(b={k.MANUAL_UPGRADE_ACCESS})
    @ResponseBody
    public DeferredResult<OperationResponse<ManuallyUpgradeResOpenApiVO>> getManuallyUpgradeRes(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="taskId", description="Task ID. The ID is the return value of 'Start manually upgrade' interface.") @PathVariable(name="taskId") String taskId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Start batch rolling upgrade By Query", description="Perform batch online upgrades of devices in a specific order within the site, and filter them using filter conditions. It is recommended to check the firmware update status before the operation, otherwise the firmware may not be the latest version")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.UPGRADE_NO_DEVICE_READY}, b={k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cmd/devices/onlineRollingUpgrade"})
    @a(a=112)
    @ResponseBody
    public DeferredResult<OperationResponse<UpgradeTaskOpenApiVO>> onlineRollingUpgradeByQuery(@RequestBody OnlineRollingUpgradeOpenApiVO deviceList, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="filters.ecspFirstVersion", description="Filter query parameters, support field ecsp first version. 1: ecsp v1; 2: ecsp v2") @RequestParam(name="filters.ecspFirstVersion", required=false) String ecspFirstVersion) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deviceList), request, response, omadacId);
    }
}

