/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.device.devicemanagement;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.stack.DeviceRememberConfigOpenApiVO;
import com.tplink.smb.omada.manager.device.api.TimeIntervalQueryOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.AdoptDeviceOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.AdoptResultOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.DeviceCopyConfigurationOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.DeviceLocateOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.DeviceMoveSiteOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.DeviceOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.ExportGlobalDeviceListOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.GlobalKnownDeviceOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.GlobalUnknownDeviceOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.TimelineOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.UnSupportRadSecOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting.ApMoveSiteOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.AdoptTipOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.BatchAdoptDeviceOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.BatchTagRespOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.BriefDeviceInfoDetailForBatchAdoptOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.DeleteTagOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.DeviceUplinkOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.GlobalDeviceStatOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.GlobalSearchResultOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.LocateOswPortsOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.LocateOswPortsResultOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.ModifyTagOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.MoveSiteIdOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.QueryDeviceListOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.QueryDeviceUplinkOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.SetTagOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.TagOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.TagRespOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.device.WhiteDeviceInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.device.dto.AdoptedDeviceGridVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Device")
@RestController
@com.a.a.a.a.b(a=23)
public class DeviceManageOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceManageOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get site device list", description="Get site device list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices"})
    @a(b={k.DEVICES_READ, k.MSP_DEVICES_READ})
    @com.a.a.a.a.a(a=1)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<DeviceOpenApiVO>>> getDeviceList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortName, @Parameter(name="sorts.status", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.status", required=false) String sortStatus, @Parameter(name="sorts.ip", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.ip", required=false) String sortIp, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name,mac,ip") @RequestParam(name="searchKey", required=false) String searchKey, @Parameter(name="filters.tag", description="Filter query parameters, support field tag name") @RequestParam(name="filters.tag", required=false) String filterTagName) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Start adopt device", description="Start adopt device.This interface does not return the actual adoptive result, you need to use the interface:Get device adopt result to obtain the adoptive result")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/start-adopt"})
    @a(b={k.ADOPT})
    @com.a.a.a.a.a(a=2)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> adoptDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @RequestBody AdoptDeviceOpenApiVO adoptDeviceOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)adoptDeviceOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get device adopt result", description="Get device adopt result.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/adopt-result"})
    @com.a.a.a.a.a(a=3)
    @a(b={k.ADOPT})
    @ResponseBody
    public DeferredResult<OperationResponse<AdoptResultOpenApiVO>> getDeviceAdoptResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Forget device", description="Forget device.")
    @a(a={b.DELETE_DEVICE_NOT_EXIST, b.FORGET_DEVICE_UPGRADING, b.FORGET_DEVICE_FAILED, b.FORGET_DEVICE_RESET_FAILED}, b={k.DEVICES_WRITE, k.MSP_DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/forget"})
    @com.a.a.a.a.a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> forgetDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Reboot device", description="Reboot device.")
    @a(a={b.REBOOT_DEVICE_NOT_EXIST, b.REBOOT_DEVICE_DISCONNECTED, b.REBOOT_DEVICE_REBOOTING, b.REBOOT_DEVICE_UPGRADING, b.REBOOT_DEVICE_SYNCING_CONFIG, b.REBOOT_DEVICE_PROVISIONING, b.SEND_REBOOT_COMMAND_TIMEOUT}, b={k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/reboot"})
    @com.a.a.a.a.a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> rebootDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Locate device", description="Locate device.")
    @a(a={b.DEVICE_SET_NOT_CONNCTED, b.LOCATE_PORT_NOT_SUPPORT}, b={k.DEVICES_WRITE, k.CLIENTS_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/locate"})
    @com.a.a.a.a.a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> locateDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @RequestBody DeviceLocateOpenApiVO deviceLocateOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deviceLocateOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get global known device list", description="Get global known device list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/devices/known-devices"})
    @a(b={k.DEVICES_READ, k.MSP_DEVICES_READ})
    @com.a.a.a.a.a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<GlobalKnownDeviceOpenApiVO>>> getGlobalKnownDeviceList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.mac", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.mac", required=false) String sortMac, @Parameter(name="searchMacs", description="Fuzzy query parameters, support field mac") @RequestParam(name="searchMacs", required=false) String searchMacs, @Parameter(name="searchNames", description="Fuzzy query parameters, support field name") @RequestParam(name="searchNames", required=false) String searchNames, @Parameter(name="searchModels", description="Fuzzy query parameters, support field model") @RequestParam(name="searchModels", required=false) String searchModels, @Parameter(name="searchSns", description="Fuzzy query parameters, support field sn") @RequestParam(name="searchSns", required=false) String searchSns, @Parameter(name="filters.tag", description="Filter query parameters, support field tag ID") @RequestParam(name="filters.tag", required=false) String filterTagId, @Parameter(name="filters.deviceSeriesType", description="Filter query parameters, support field Device series type. 0: basic; 1: pro.") @RequestParam(name="filters.deviceSeriesType", required=false) String deviceSeriesType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get global unknown device list", description="Get global unknown device list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/devices/unknown-devices"})
    @a(b={k.DEVICES_READ, k.MSP_DEVICES_READ})
    @com.a.a.a.a.a(a=8)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<GlobalUnknownDeviceOpenApiVO>>> getGlobalUnknownDeviceList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.mac", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.mac", required=false) String sortMac, @Parameter(name="searchMacs", description="Fuzzy query parameters, support field mac") @RequestParam(name="searchMacs", required=false) String searchMacs, @Parameter(name="searchNames", description="Fuzzy query parameters, support field name") @RequestParam(name="searchNames", required=false) String searchNames, @Parameter(name="searchModels", description="Fuzzy query parameters, support field model") @RequestParam(name="searchModels", required=false) String searchModels) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new tag", description="Create new tag.")
    @a(b={k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/tag"})
    @com.a.a.a.a.a(a=9)
    @ResponseBody
    public DeferredResult<TagRespOpenApiVO> addTag(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody TagOpenApiVO tagOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)tagOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify an existing tag", description="Modify an existing tag.")
    @a(b={k.DEVICES_WRITE})
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/tag"})
    @com.a.a.a.a.a(a=10)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyTag(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ModifyTagOpenApiVO tagOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)tagOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing tag", description="Delete an existing tag.")
    @a(b={k.DEVICES_WRITE})
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/tag"})
    @com.a.a.a.a.a(a=11)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteTag(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody DeleteTagOpenApiVO tagOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)tagOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get tag list", description="Get tag list.")
    @a(b={k.DEVICES_READ, k.MAP_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/tag"})
    @com.a.a.a.a.a(a=12)
    @ResponseBody
    public DeferredResult<List<TagRespOpenApiVO>> getTags(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Set device tag for given devices", description="Set device tag for given devices.")
    @a(b={k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/multi-devices/tag"})
    @com.a.a.a.a.a(a=13)
    @ResponseBody
    public DeferredResult<BatchTagRespOpenApiVO> updateDeviceTag(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody SetTagOpenApiVO setTagOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)setTagOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Copy configuration", description="Copy the configuration of one device to another device of the same model. Only for switch and access point.")
    @a(a={b.DEVICE_NOT_EXIST, b.SOURCE_DEVICE_NOT_EXIST, b.DEVICE_MODEL_IS_NOT_SAME}, b={k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/copy"})
    @com.a.a.a.a.a(a=14)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> copyDeviceConfiguration(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody DeviceCopyConfigurationOpenApiVO deviceCopyConfigurationOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deviceCopyConfigurationOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Move site", description="Move the device to another site. If you want to move a networked bridge AP, use the \"batch move ap site\" interface to move all APs in the bridge network at the same time.")
    @a(a={b.DEVICE_NOT_EXIST, b.INVALID_SITE_ID, b.GATEWAY_ALREADY_EXIST, b.MOVE_SITE_OSG_MODEL_DISMATCH, b.PRO_SITE_ONLY_MANAGE_PRO_DEVICE, b.NON_PRO_SITE_ONLY_MANAGE_NON_PRO_DEVICE, b.BRIDGE_MOVE_SITE_TOGETHER, b.DEVICE_NOT_SUPPORT_CLUSTER, b.MOVE_DEVICE_ALREADY_IN_DST_SITE}, b={k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/site-move"})
    @com.a.a.a.a.a(a=15)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> moveSite(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @RequestBody DeviceMoveSiteOpenApiVO deviceMoveSiteOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deviceMoveSiteOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Force provision device", description="Force provision device.")
    @a(a={b.GENERAL_ERROR, b.USER_NOT_LOGIN, b.INVALID_REQUEST_PARAMS, b.DEVICE_BUSY, b.DEVICE_NOT_EXIST}, b={k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/force-provision"})
    @com.a.a.a.a.a(a=16)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> forceProvisionDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get device remember Config", description="Get device remember Config")
    @a(a={}, b={k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/remember"})
    @com.a.a.a.a.a(a=17)
    @ResponseBody
    public DeferredResult<OperationResponse<DeviceRememberConfigOpenApiVO>> getDeviceRememberMe(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify device remember Config", description="Modify device remember Config")
    @a(a={}, b={k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/remember"})
    @com.a.a.a.a.a(a=18)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyDeviceRememberMe(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @RequestBody DeviceRememberConfigOpenApiVO deviceRememberConfig) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deviceRememberConfig), request, response, omadacId);
    }

    @Operation(summary="Get forget process of device", description="Get forget process of one device from batch-forget. The expire time of result for each device is 300 seconds.")
    @a(a={b.GENERAL_ERROR, b.USER_NOT_LOGIN, b.INVALID_REQUEST_PARAMS, b.DEVICE_NOT_EXIST, b.OPERATION_PARAM_NOT_EXIST_OR_EXPIRED}, b={k.DEVICES_WRITE})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/forget/{forgetId}/status"})
    @com.a.a.a.a.a(a=19)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> getSingleForgetProcess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @Parameter(name="forgetId", description="Forget ID") @PathVariable(name="forgetId") String forgetId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get move site process of device", description="Get move site process of one device from batch-move-site. The expire time of result for each device is 300 seconds")
    @a(a={b.GENERAL_ERROR, b.USER_NOT_LOGIN, b.INVALID_REQUEST_PARAMS, b.DEVICE_NOT_EXIST, b.OPERATION_PARAM_NOT_EXIST_OR_EXPIRED}, b={k.DEVICES_WRITE})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/move/{moveSiteId}/status"})
    @com.a.a.a.a.a(a=20)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> getSingleMoveSiteProcess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @Parameter(name="moveSiteId", description="Move Site ID") @PathVariable(name="moveSiteId") String moveSiteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get batch forget process", description="Get process of the batch forget operation. The expire time of result is 300 seconds.")
    @a(a={b.GENERAL_ERROR, b.USER_NOT_LOGIN, b.INVALID_REQUEST_PARAMS, b.OPERATION_PARAM_NOT_EXIST_OR_EXPIRED}, b={k.DEVICES_WRITE})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/forget/{forgetId}/status"})
    @com.a.a.a.a.a(a=21)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> getForgetProcess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="forgetId", description="Forget ID") @PathVariable(name="forgetId") String forgetId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get batch move site process", description="Get process of the batch move site operation. The expire time of result is 300 seconds.")
    @a(a={b.GENERAL_ERROR, b.USER_NOT_LOGIN, b.INVALID_REQUEST_PARAMS, b.OPERATION_PARAM_NOT_EXIST_OR_EXPIRED}, b={k.DEVICES_WRITE})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/move/{moveSiteId}/status"})
    @com.a.a.a.a.a(a=22)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> getMoveSiteProcess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="moveSiteId", description="Move Site ID") @PathVariable(name="moveSiteId") String moveSiteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="batch adopt device", description="batch adopt device.This interface does not return the actual adoptive result,you need to use the interface:Get device adopt result to obtain the adoptive result")
    @a(b={k.ADOPT, k.ADD_ADOPT_DEVICE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cmd/devices/batch-adopt"})
    @com.a.a.a.a.a(a=23)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> batchAdopt(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody BatchAdoptDeviceOpenApiVO batchAdoptDeviceOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)batchAdoptDeviceOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Forget one device in MSP view.", description="Forget one device in MSP view.")
    @a(b={k.MSP_DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/msp/{mspId}/customers/{customerId}/sites/{siteId}/devices/{deviceMac}/forget"})
    @com.a.a.a.a.a(a=24)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> forgetDeviceForMsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="customerId", description="Customer ID") @PathVariable(name="customerId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Batch get info of adopted device in global view.", description="Batch get info of adopted device in global view.")
    @a(b={k.ADOPT, k.ADD_ADOPT_DEVICE})
    @GetMapping(value={"/openapi/v1/{omadacId}/devices/batch/info"})
    @com.a.a.a.a.a(a=25)
    @ResponseBody
    public DeferredResult<OperationResponse<List<BriefDeviceInfoDetailForBatchAdoptOpenApiVO>>> getAdoptAbleDevicesForGlobalBatchAdopt(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortName, @Parameter(name="sorts.status", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.status", required=false) String sortStatus, @Parameter(name="sorts.ip", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.ip", required=false) String sortIp, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name,mac,ip") @RequestParam(name="searchKey", required=false) String searchKey, @Parameter(name="filters.tag", description="Filter query parameters, support field tag name") @RequestParam(name="filters.tag", required=false) String filterTagName) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Batch get info of adopted device in MSP view.", description="Batch get info of adopted device in MSP view.")
    @a(b={k.MSP_ADOPT, k.MSP_ADD_ADOPT_DEVICE})
    @GetMapping(value={"/openapi/v1/msp/{mspId}/devices/batch/info"})
    @com.a.a.a.a.a(a=26)
    @ResponseBody
    public DeferredResult<OperationResponse<List<BriefDeviceInfoDetailForBatchAdoptOpenApiVO>>> getAdoptAbleDevicesForMspBatchAdopt(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortName, @Parameter(name="sorts.status", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.status", required=false) String sortStatus, @Parameter(name="sorts.ip", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.ip", required=false) String sortIp, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name,mac,ip") @RequestParam(name="searchKey", required=false) String searchKey, @Parameter(name="filters.tag", description="Filter query parameters, support field tag name") @RequestParam(name="filters.tag", required=false) String filterTagName) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Get device list info.", description="Get device list info.")
    @a(b={k.DEVICES_READ, k.DASHBOARD_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/all"})
    @com.a.a.a.a.a(a=27)
    @ResponseBody
    public DeferredResult<OperationResponse<List<DeviceOpenApiVO>>> getAllDeviceBySite(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Global search for devices returns the devices under the sites that have permissions.", description="Global search for devices returns the devices under the sites that have permissions.")
    @a(b={k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/devices"})
    @com.a.a.a.a.a(a=28)
    @ResponseBody
    public DeferredResult<OperationResponse<GlobalSearchResultOpenApiVO>> searchGlobalDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="searchKey", description="searchKey") @RequestParam(name="searchKey") String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the whitelist list of devices.", description="Get the whitelist list of devices.")
    @a(b={k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/device-white-list"})
    @com.a.a.a.a.a(a=29)
    @ResponseBody
    public DeferredResult<OperationResponse<List<WhiteDeviceInfoOpenApiVO>>> getDeviceWhiteList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Query the statistics for the list of global adopted devices.", description="Query the statistics for the list of global adopted devices.")
    @a(b={k.DEVICES_READ, k.MSP_DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/devices/stat"})
    @com.a.a.a.a.a(a=30)
    @ResponseBody
    public DeferredResult<OperationResponse<GlobalDeviceStatOpenApiVO>> getGridAdoptedDevicesStatByGlobal(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get auto select devices in quick-config page.", description="Get auto select devices in quick-config page.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/quick-action/network-wizard/auto-select-devices"})
    @com.a.a.a.a.a(a=31)
    @a(b={k.SITE_HOME_READ, k.DASHBOARD_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<QueryDeviceListOpenApiVO>> getAutoSelectDevices(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody QueryDeviceListOpenApiVO queryDeviceListOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryDeviceListOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Export device list in GLOBAL view", description="Export device list in GLOBAL view.")
    @a(b={k.GLOBAL_DATA_EXPORT})
    @PostMapping(value={"/openapi/v1/{omadacId}/devices/export"})
    @com.a.a.a.a.a(a=32)
    @ResponseBody
    public DeferredResult<OperationResponse> exportGlobalDeviceList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody ExportGlobalDeviceListOpenApiVO exportGlobalDeviceListOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)exportGlobalDeviceListOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Export device list of site", description="Export device list of site.")
    @a(b={k.DATA_EXPORT})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/export"})
    @com.a.a.a.a.a(a=33)
    @ResponseBody
    public DeferredResult<OperationResponse> exportSiteDeviceList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ExportGlobalDeviceListOpenApiVO exportGlobalDeviceListOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)exportGlobalDeviceListOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Export preconfigured devices of site.", description="Export preconfigured devices of site.")
    @a(b={k.GLOBAL_SETTING_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/migrate/exportPreDevice"})
    @com.a.a.a.a.a(a=34)
    @ResponseBody
    public DeferredResult<OperationResponse> exportPreConfigDevices(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Export preconfigured devices in GLOBAL view.", description="Export preconfigured devices in GLOBAL view.")
    @a(b={k.GLOBAL_SETTING_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/migrate/exportPreDevice"})
    @com.a.a.a.a.a(a=35)
    @ResponseBody
    public DeferredResult<OperationResponse> exportPreConfigDevicesGlobal(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Export the device file that failed to add in GLOBAL view.", description="Export the device file that failed to add in GLOBAL view. Format should be a number as follows. 0 means CSV , 1 means XLSX.")
    @a(b={k.ADD_DEVICES})
    @GetMapping(value={"/openapi/v1/{omadacId}/devices/add/{operateId}/export"})
    @com.a.a.a.a.a(a=36)
    @ResponseBody
    public DeferredResult<OperationResponse> exportAddFailDevices(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="operateId", description="Operation ID") @PathVariable(name="operateId") String operateId, @Parameter(name="format", description="File format. 0: CSV, 1: XLSX") @RequestParam(name="format") Integer format) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Export the device file that failed to add in MSP view.", description="Export the device file that failed to add in MSP view. Format should be a value as follows. 0 means CSV , 1 means XLSX.")
    @a(b={k.MSP_ADD_DEVICES, k.MSP_ADD_ADOPT_DEVICE})
    @GetMapping(value={"/openapi/v1/msp/{mspId}/customers/{customerId}/devices/add/{operateId}/export"})
    @com.a.a.a.a.a(a=37)
    @ResponseBody
    public DeferredResult<OperationResponse> exportMspAddFailDevices(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="customerId", description="Customer ID") @PathVariable(name="customerId") String omadacId, @Parameter(name="operateId", description="Operation ID") @PathVariable(name="operateId") String operateId, @Parameter(name="format", description="File format. 0: CSV, 1: XLSX") @RequestParam(name="format") Integer format) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Download device information.", description="Download device information.")
    @a(b={k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cmd/devices/{deviceMac}/downloadDeviceInfo/{type}"})
    @com.a.a.a.a.a(a=38)
    @ResponseBody
    public DeferredResult<OperationResponse> downloadDeviceInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @Parameter(name="type", description="Device Type. Supported type: ap, gateway, switch, olt.") @PathVariable(name="type") String deviceType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get Bridge group grouped devices", description="Get Bridge group grouped devices.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/grid/bridge-devices/adopted"})
    @a(b={k.DEVICES_READ})
    @com.a.a.a.a.a(a=39)
    @ResponseBody
    public DeferredResult<OperationResponse<AdoptedDeviceGridVO<DeviceOpenApiVO>>> getGridAdoptedBridgeDevicesBySite(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.mac", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.mac", required=false) String sortMac, @Parameter(name="searchMacs", description="Fuzzy query parameters, support field mac") @RequestParam(name="searchMacs", required=false) String searchMacs, @Parameter(name="searchNames", description="Fuzzy query parameters, support field name") @RequestParam(name="searchNames", required=false) String searchNames, @Parameter(name="searchModels", description="Fuzzy query parameters, support field model") @RequestParam(name="searchModels", required=false) String searchModels, @Parameter(name="searchSns", description="Fuzzy query parameters, support field sn") @RequestParam(name="searchSns", required=false) String searchSns, @Parameter(name="filters.tag", description="Filter query parameters, support field tag ID") @RequestParam(name="filters.tag", required=false) String filterTagId, @Parameter(name="filters.deviceSeriesType", description="Filter query parameters, support field Device series type. 0: basic; 1: pro.") @RequestParam(name="filters.deviceSeriesType", required=false) String deviceSeriesType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get Bridge group ungrouped devices", description="Get Bridge group ungrouped devices.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/grid/bridge-devices/pending"})
    @a(b={k.DEVICES_READ})
    @com.a.a.a.a.a(a=40)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<DeviceOpenApiVO>>> getGridPendingBridgeDevicesBySite(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.mac", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.mac", required=false) String sortMac, @Parameter(name="searchMacs", description="Fuzzy query parameters, support field mac") @RequestParam(name="searchMacs", required=false) String searchMacs, @Parameter(name="searchNames", description="Fuzzy query parameters, support field name") @RequestParam(name="searchNames", required=false) String searchNames, @Parameter(name="searchModels", description="Fuzzy query parameters, support field model") @RequestParam(name="searchModels", required=false) String searchModels, @Parameter(name="searchSns", description="Fuzzy query parameters, support field sn") @RequestParam(name="searchSns", required=false) String searchSns, @Parameter(name="filters.tag", description="Filter query parameters, support field tag ID") @RequestParam(name="filters.tag", required=false) String filterTagId, @Parameter(name="filters.deviceSeriesType", description="Filter query parameters, support field Device series type. 0: basic; 1: pro.") @RequestParam(name="filters.deviceSeriesType", required=false) String deviceSeriesType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Move aps to another site", description="Move aps to another site. If you want to move networked bridge APs, ensure all APs in the bridge network are in movable state and move them at the same time. This interface will not move non-AP devices.")
    @a(a={b.INVALID_PERMISSION, b.DEVICE_NOT_EXIST, b.INVALID_SITE_ID, b.DEVICE_NOT_SUPPORT_CLUSTER, b.MOVE_DEVICE_ALREADY_IN_DST_SITE, b.PRO_SITE_ONLY_MANAGE_PRO_DEVICE, b.NON_PRO_SITE_ONLY_MANAGE_NON_PRO_DEVICE, b.BRIDGE_MOVE_SITE_TOGETHER}, b={k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/aps/site-move"})
    @com.a.a.a.a.a(a=41)
    @ResponseBody
    public DeferredResult<OperationResponse<MoveSiteIdOpenApiVO>> moveSiteForAps(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ApMoveSiteOpenApiVO apMoveSiteOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)apMoveSiteOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get adoptable device list of target site", description="Get adoptable device list of target site.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/grid/devices/pending"})
    @a(b={k.DEVICES_READ})
    @com.a.a.a.a.a(a=42)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<DeviceOpenApiVO>>> getGridPendingDevicesBySite(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="searchKey") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get device online timeline", description="Get device online timeline")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/{deviceMac}/timeline"})
    @a(b={k.DEVICES_READ})
    @com.a.a.a.a.a(a=43)
    @ResponseBody
    public DeferredResult<OperationResponse<TimelineOpenApiVO>> getOnlineTimeline(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @ModelAttribute TimeIntervalQueryOpenApiVO dto) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)dto), request, response, omadacId);
    }

    @Operation(summary="Locate multiple ports of multiple switches", description="Locate multiple ports of multiple switches")
    @a(a={b.LOCATE_PORT_NOT_SUPPORT, b.DEVICE_SET_NOT_CONNCTED}, b={k.DEVICES_WRITE, k.SITE_DEVICE_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/locate/switch-ports"})
    @com.a.a.a.a.a(a=44)
    @ResponseBody
    public DeferredResult<OperationResponse<LocateOswPortsResultOpenApiVO>> locatePorts(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody LocateOswPortsOpenApiVO locateOswPortsOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)locateOswPortsOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Query uplink information for specified device MAC addresses under the site.", description="Query uplink information for specified device MAC addresses under the site.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/uplink-info"})
    @a(b={k.DEVICES_READ, k.MSP_DEVICES_READ, k.ANOMALY_READ})
    @com.a.a.a.a.a(a=44)
    @ResponseBody
    public DeferredResult<OperationResponse<List<DeviceUplinkOpenApiVO>>> getUplinkDeviceInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody QueryDeviceUplinkOpenApiVO queryDeviceUplinkOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryDeviceUplinkOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Check for unsupported RadSec devices.", description="Get the result of detecting devices that do not support the RadSec feature.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/devices/un-support-radsec"})
    @a(b={k.DEVICES_READ})
    @com.a.a.a.a.a(a=45)
    @ResponseBody
    public DeferredResult<OperationResponse<UnSupportRadSecOpenApiVO>> existUnSupportRadSecDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get adopt tip", description="Get adopt tip")
    @a(b={k.ADOPT, k.ADD_ADOPT_DEVICE})
    @GetMapping(value={"/openapi/v1/{omadacId}/adopt-tip"})
    @com.a.a.a.a.a(a=46)
    @ResponseBody
    public DeferredResult<OperationResponse<AdoptTipOpenApiVO>> getAdoptTip(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

