/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.device;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.stack.vo.OswStackConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.stack.vo.OswStackLocateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.stack.vo.OswStackRebootOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswCableTestLogOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswCableTestTestingPortOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswDDMInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.device.dto.LocateResultVO;
import com.tplink.smb.omada.manager.device.api.web.device.dto.RebootResultVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswCableTestResultWithStatusVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswStackCableTestVO;
import com.tplink.smb.omada.manager.stack.api.web.dto.OswStackSwitchVO;
import com.tplink.smb.omada.manager.stack.api.web.dto.OswStackVO;
import io.reactivex.Single;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Stack")
@RestController
@b(a=48)
public class OswStackOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswStackOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get stack list", description="Get stack list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stacks"})
    @com.tplink.smb.omada.common.m.a(a={}, b={k.DEVICES_READ})
    @a(a=1)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<OswStackVO>>> getGridOswStackList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create Switch Stack", description="Create Switch Stack.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stacks"})
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.DEVICE_NAME_IS_TOO_LONG, com.tplink.smb.omada.common.g.b.SWITCH_DOES_NOT_EXIST, com.tplink.smb.omada.common.g.b.LAG_MEMBER_INVALID, com.tplink.smb.omada.common.g.b.PORT_ALREADY_USED, com.tplink.smb.omada.common.g.b.INCOMPATIBLE_STACK_DEVICE_EXIST, com.tplink.smb.omada.common.g.b.STACK_MEMBER_NUMBER_EXCEED_LIMIT})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponseWithoutResult> createOswStack(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @RequestBody OswStackConfigOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify Switch Stack", description="Modify Switch Stack.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stacks/{stackId}"})
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.SWITCH_DOES_NOT_EXIST, com.tplink.smb.omada.common.g.b.STACK_MEMBER_NUMBER_EXCEED_LIMIT, com.tplink.smb.omada.common.g.b.DEVICE_NAME_IS_TOO_LONG, com.tplink.smb.omada.common.g.b.LAG_MEMBER_INVALID, com.tplink.smb.omada.common.g.b.PORT_ALREADY_USED, com.tplink.smb.omada.common.g.b.STACK_UNIT_CONFLICT, com.tplink.smb.omada.common.g.b.INCOMPATIBLE_STACK_DEVICE_EXIST, com.tplink.smb.omada.common.g.b.DETECT_MEMBER_HAS_BEEN_ADOPTED_IN_OTHER_SITE, com.tplink.smb.omada.common.g.b.STACK_DETECT_MEMBER_ADOPT_BUSY})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponseWithoutResult> modifyOswStack(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId, @RequestBody OswStackConfigOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete Switch Stack", description="Delete Switch Stack.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stacks/{stackId}"})
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE}, a={})
    @ResponseBody
    @a(a=4)
    public DeferredResult<OperationResponseWithoutResult> deleteOswStack(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get discovery stack list", description="Get discovery stack list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stacks/discovery"})
    @com.tplink.smb.omada.common.m.a(a={}, b={k.DEVICES_READ})
    @a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> getGridDiscoveryStackList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get stackable switches", description="Get stackable switches.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stacks/switches"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.STACK_NOT_EXIST}, b={k.DEVICES_READ})
    @a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponse<OswStackSwitchVO>> getStackableSwitches(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @RequestParam(value="stackId") String stackId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Detect switch stack members", description="Detect switch stack members.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stacks/detect/{stackId}"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.STACK_NOT_EXIST}, b={k.DEVICES_WRITE})
    @a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> detectSwitchStackMembers(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Detect switch stacks members for all stacks", description="Detect switch stacks members for all stacks.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stacks/detect"})
    @com.tplink.smb.omada.common.m.a(a={}, b={k.DEVICES_WRITE})
    @a(a=8)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> detectSwitchStackMembersForAllStacks(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Reboot switch stack", description="Reboot switch stack.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cmd/stacks/{stackId}/reboot"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.MASTER_NOT_CONNECT_CANNOT_REBOOT, com.tplink.smb.omada.common.g.b.SEND_REBOOT_COMMAND_TIMEOUT}, b={k.DEVICES_WRITE})
    @a(a=9)
    @ResponseBody
    public DeferredResult<OperationResponse<List<RebootResultVO>>> rebootOswStack(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId, @RequestBody OswStackRebootOpenApiVO vo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @Operation(summary="Locate switch stack", description="Locate switch stack.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cmd/stacks/{stackId}/locate"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.MASTER_NOT_CONNECT_CANNOT_LOCATE}, b={k.DEVICES_WRITE, k.CLIENTS_WRITE})
    @a(a=10)
    @ResponseBody
    public DeferredResult<OperationResponse<LocateResultVO>> locateOswStack(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId, @RequestBody OswStackLocateOpenApiVO vo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @Operation(summary="Get stack ddm info.", description="Get stack ddm info.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stack/{stackId}/ddm/info"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.STACK_NOT_EXIST}, b={k.DEVICES_READ})
    @a(a=11)
    @ResponseBody
    public DeferredResult<OperationResponse<List<OswDDMInfoOpenApiVO>>> getOswStackDDMInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Download stack device info.", description="Download stack device info.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/stack/{stackId}/downloadDeviceInfo"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.STACK_NOT_EXIST}, b={k.DEVICES_READ})
    @a(a=12)
    @ResponseBody
    public DeferredResult<Single<OperationResponse>> downloadStackDeviceInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the port list of stack used for cable test", description="Get the port list of stack used for cable test.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cable-test/stacks/{stackId}/ports"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.STACK_NOT_EXIST}, b={k.DEVICES_READ})
    @a(a=13)
    @ResponseBody
    public DeferredResult<OperationResponse<OswStackCableTestVO>> getStackCableTestPorts(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get stack cable test full results", description="Get stack cable test full results.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cable-test/stacks/{stackId}/full-results"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.STACK_NOT_EXIST}, b={k.DEVICES_READ})
    @a(a=14)
    @ResponseBody
    public DeferredResult<OperationResponse<OswCableTestResultWithStatusVO>> getStackCableTestFullResults(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get stack cable test increment results", description="Get stack cable test increment results.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cable-test/stacks/{stackId}/increment-results"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.STACK_NOT_EXIST}, b={k.DEVICES_READ})
    @a(a=15)
    @ResponseBody
    public DeferredResult<OperationResponse<OswCableTestResultWithStatusVO>> getStackCableTestIncrementResults(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get stack cable test logs", description="Get stack cable test logs.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cable-test/stacks/{stackId}/logs"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.STACK_NOT_EXIST}, b={k.DEVICES_READ})
    @a(a=16)
    @ResponseBody
    public DeferredResult<OperationResponse<List<OswCableTestLogOpenApiVO>>> getStackCableTestLogs(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Start stack cable test", description="Start stack cable test.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cable-test/stacks/{stackId}/start"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.STACK_NOT_EXIST, com.tplink.smb.omada.common.g.b.CABLE_TEST_SWITCH_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.SWITCH_PORT_NOT_EXIST, com.tplink.smb.omada.common.g.b.CABLE_TEST_UPLINK_PORT_CAN_NOT_SELECT, com.tplink.smb.omada.common.g.b.CABLE_TEST_SFP_PORT_CAN_NOT_SELECT, com.tplink.smb.omada.common.g.b.CABLE_TEST_DISABLE_PORT_CAN_NOT_SELECT, com.tplink.smb.omada.common.g.b.CABLE_TEST_STACK_PORT_CAN_NOT_SELECT, com.tplink.smb.omada.common.g.b.CABLE_TEST_SWITCH_RUNNING}, b={k.DEVICES_WRITE})
    @a(a=17)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> startStackCableTest(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId, @RequestBody OswCableTestTestingPortOpenApiVO oswCableTestTestingPortOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)oswCableTestTestingPortOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Cancel stack cable test", description="Cancel stack cable test.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cable-test/stacks/{stackId}/cancel"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.STACK_NOT_EXIST, com.tplink.smb.omada.common.g.b.CABLE_TEST_SWITCH_NOT_SUPPORT}, b={k.DEVICES_WRITE})
    @a(a=18)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> cancelStackCableTest(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(value="stackId") String stackId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

