/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.device;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.mlag.MlagConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.mlag.MlagLocateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.mlag.MlagRebootOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.mlag.MlagSupportOswVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.mlag.OswMlagCccVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.mlag.OswMlagVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Mlag")
@RestController
@b(a=49)
public class OswMlagOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswMlagOpenApiController.class);
    @Resource
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get M-LAG group list", description="Get M-LAG group list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/mlag"})
    @com.tplink.smb.omada.common.m.a(a={}, b={k.DEVICES_READ})
    @a(a=1)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<OswMlagVO>>> getGridMlagGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create M-LAG group", description="Create M-LAG group.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/mlag"})
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.DUPLICATE_MLAG_NAME, com.tplink.smb.omada.common.g.b.SWITCH_DOES_NOT_EXIST, com.tplink.smb.omada.common.g.b.SWITCH_NOT_SUPPORT_MLAG})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponseWithoutResult> createMlagGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @RequestBody MlagConfigOpenApiVO mlagConfigOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)mlagConfigOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete M-LAG group", description="Delete M-LAG group.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/mlag/{mlagId}"})
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE}, a={})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponseWithoutResult> deleteMlagGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="mlagId", description="M-LAG group ID") @PathVariable(value="mlagId") String mlagId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify M-LAG group", description="Modify M-LAG group.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/mlag/{mlagId}"})
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.DUPLICATE_MLAG_NAME, com.tplink.smb.omada.common.g.b.SWITCH_DOES_NOT_EXIST, com.tplink.smb.omada.common.g.b.SWITCH_NOT_SUPPORT_MLAG})
    @ResponseBody
    @a(a=4)
    public DeferredResult<OperationResponseWithoutResult> modifyMlagGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="mlagId", description="M-LAG group ID") @PathVariable(value="mlagId") String mlagId, @RequestBody MlagConfigOpenApiVO mlagConfigOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)mlagConfigOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get support M-LAG group switch list", description="Get support M-LAG group switch list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/mlag/switches"})
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_READ}, a={})
    @ResponseBody
    @a(a=5)
    public DeferredResult<OperationResponse<MlagSupportOswVO>> listSupportMlagGroupOsws(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the configuration consistency check result of the M-LAG Group", description="Get the configuration consistency check result of the M-LAG Group.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/mlag/{mlagId}/mlag-ccc/{type}"})
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_READ}, a={})
    @ResponseBody
    @a(a=6)
    public DeferredResult<OperationResponse<Map<String, OswMlagCccVO>>> getMlagCccResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="mlagId", description="M-LAG group ID") @PathVariable(value="mlagId") String mlagId, @Parameter(name="type", description="The level of configuration consistency check should be a value as follows: 0:Critical & Significant 1: Critical; 2: Significant") @PathVariable(value="type") String cccType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Locate M-LAG group", description="Locate M-LAG group.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cmd/mlag/{mlagId}/locate"})
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.MLAG_GROUP_MEMBER_NOT_CONNECT})
    @ResponseBody
    @a(a=7)
    public DeferredResult<OperationResponseWithoutResult> locateMlag(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="mlagId", description="M-LAG group ID") @PathVariable(value="mlagId") String mlagId, @RequestBody MlagLocateOpenApiVO mlagLocateOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)mlagLocateOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Reboot M-LAG group", description="Reboot M-LAG group.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cmd/mlag/{mlagId}/reboot"})
    @com.tplink.smb.omada.common.m.a(b={k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.MLAG_GROUP_MEMBER_NOT_CONNECT})
    @ResponseBody
    @a(a=8)
    public DeferredResult<OperationResponseWithoutResult> rebootMlag(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="mlagId", description="M-LAG group ID") @PathVariable(value="mlagId") String mlagId, @RequestBody MlagRebootOpenApiVO mlagRebootOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)mlagRebootOpenApiVO), request, response, omadacId);
    }
}

