/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.client;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.client.api.openapi.vo.ClientBatchSettingOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientDetailOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientExportOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientFilteringOptionsOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientIpSettingOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientJourneyOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientLockToApSettingOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientNameSettingOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientQueryDataOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientRateLimitSettingOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientRebootOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ClientsDeleteFilterOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.DeviceClientNumOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.ExportClientListOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.GlobalDevicesQueryOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.MspDeviceClientNumOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.MspDevicesQueryOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.MultiSiteClientExportOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.OmadacClientSettingOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.clientstat.ClientStatQueryOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.clientstat.GetClientDetailStatResultOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.timeline.ClientTimelineSessionOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.topology.ClientTopologyNodeOpenApiVO;
import com.tplink.smb.omada.client.api.web.vo.ClientCorrectionOptionListVO;
import com.tplink.smb.omada.client.api.web.vo.ClientGridVO;
import com.tplink.smb.omada.client.api.web.vo.ClientHistoryVO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Client")
@RestController
@com.a.a.a.a.b(a=13)
public class ClientManageOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientManageOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;
    public static final String AUTH_RECORD_CLIENT_MAC = "client_mac";
    public static final String AUTH_RECORD_CLIENT_NAME = "client_name";
    public static final String VOUCHER_CODE = "voucher.code";
    public static final String LOCAL_USER_USER_NAME = "local_user.user_name";
    public static final String FORM_NAME = "form_name";
    public static final String AUTH_ADMIN = "auth_admin";
    public static final String SSID_NAME = "ssid_name";
    public static final String NETWORK_NAME = "network_name";

    @Operation(summary="Get client list", description="Get all clients.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients"})
    @a(b={k.CLIENTS_READ, k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=1)
    public DeferredResult<OperationResponse<ClientGridVO<ClientOpenApiVO>>> getGridActiveClients(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortsName, @Parameter(name="sorts.mac", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.mac", required=false) String sortsMac, @Parameter(name="sorts.ip", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.ip", required=false) String sortsIp, @Parameter(name="filters.wireless", description="Filter query parameters, support field wireless: true/false.") @RequestParam(name="filters.wireless", required=false) String filtersWireless, @Parameter(name="filters.radioId", description="Filter query parameters, support field radioId: 0: 2G, 1: 5G1, 2: 5G2, 3: 6G") @RequestParam(name="filters.radioId", required=false) String filtersRadioId, @Parameter(name="filters.apMac", description="Filter query parameters, support field ap mac") @RequestParam(name="filters.apMac", required=false) String filtersApMac, @Parameter(name="filters.switchMac", description="Filter query parameters, support field switch mac") @RequestParam(name="filters.switchMac", required=false) String filtersSwitchMac, @Parameter(name="filters.gatewayMac", description="Filter query parameters, support field gateway mac") @RequestParam(name="filters.gatewayMac", required=false) String filtersGatewayMac, @Parameter(name="searchKey", description="Fuzzy query parameters, support field clientName,clientMac,ip,channel,ssid,apName,apMac,switchMac,switchName,gatewayMac,gatewayName.") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get all client list", description="Get all clients, including online offline blocked and all list.")
    @PostMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/clients"})
    @a(b={k.CLIENTS_READ, k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=1)
    public DeferredResult<OperationResponse<ClientGridVO<ClientOpenApiVO>>> getGridAllClients(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ClientQueryDataOpenApiVO clientQueryDataOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)clientQueryDataOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get client info", description="Get client info.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}"})
    @a(b={k.CLIENTS_READ, k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=2)
    public DeferredResult<OperationResponse<ClientDetailOpenApiVO>> getClientDetail(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Block the client", description="Block the client.")
    @a(a={b.CLIENT_BLOCK_FAILED, b.LOCKED_CLIENT_CAN_NOT_BLOCK, b.REACHED_THE_MAXIUM_NUMBER_OF_BLOCK_CLIENTS, b.CAN_NOT_BLOCK_MANAGED_CLIENT, b.EASY_MANAGE_NOT_SUPPORT_BLOCK_CLIENT}, b={k.CLIENTS_WRITE, k.INSIGHT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/block"})
    @ResponseBody
    @com.a.a.a.a.a(a=7)
    public DeferredResult<OperationResponseWithoutResult> blockClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Unblock the client", description="Unblock the client.")
    @a(a={b.CLIENT_UNBLOCK_FAILED}, b={k.CLIENTS_WRITE, k.INSIGHT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/unblock"})
    @ResponseBody
    @com.a.a.a.a.a(a=8)
    public DeferredResult<OperationResponseWithoutResult> unblockClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Reconnect the client", description="Reconnect the client.")
    @a(a={b.CLIENT_NOT_EXIST, b.CAN_NOT_RECONNECT_WIRED_CLIENT}, b={k.CLIENTS_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/reconnect"})
    @ResponseBody
    @com.a.a.a.a.a(a=6)
    public DeferredResult<OperationResponseWithoutResult> reconnectClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Set name for given client", description="Set name for given client.")
    @a(a={b.CLIENT_NOT_EXIST}, b={k.CLIENTS_WRITE})
    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/name"})
    @ResponseBody
    @com.a.a.a.a.a(a=3)
    public DeferredResult<OperationResponseWithoutResult> updateClientName(@RequestBody ClientNameSettingOpenApiVO nameSetting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)nameSetting), request, response, omadacId);
    }

    @Operation(summary="Set ratelimit setting for given client", description="Set ratelimit setting for given client.")
    @a(a={b.CLIENT_NOT_EXIST, b.RATE_LIMIT_NOT_EXIST, b.REACHED_THE_MAXIUM_NUMBER_OF_CLIENT_RATE_LIMIT}, b={k.CLIENTS_WRITE})
    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/ratelimit"})
    @ResponseBody
    @com.a.a.a.a.a(a=4)
    public DeferredResult<OperationResponseWithoutResult> updateClientRateLimitSetting(@RequestBody ClientRateLimitSettingOpenApiVO rateLimitSetting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)rateLimitSetting), request, response, omadacId);
    }

    @Operation(summary="Set ip setting for given client", description="Set ip setting for given client.")
    @a(b={k.CLIENTS_WRITE})
    @PatchMapping(path={"/openapi/v1/{omadacId}/network/sites/{siteId}/cmd/clients/{clientMac}/update-ipSetting"})
    @ResponseBody
    @com.a.a.a.a.a(a=4)
    public DeferredResult<OperationResponseWithoutResult> modifyClientIpSetting(@RequestBody ClientIpSettingOpenApiVO ipSetting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ipSetting), request, response, omadacId);
    }

    @Operation(summary="Lock the given client to aps", description="Lock the given client to aps.")
    @a(a={b.CLIENT_NOT_EXIST, b.LOCK_TO_AP_CLIENT_REQUEST_WIRLESS, b.BLOCKED_CLIENT_CAN_NOT_LOCK_TO_AP, b.LOCK_TO_CLIENTS_REACHED_LIMIT}, b={k.CLIENTS_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/lock-to-ap"})
    @ResponseBody
    @com.a.a.a.a.a(a=5)
    public DeferredResult<OperationResponseWithoutResult> updateClientLockToApSetting(@RequestBody ClientLockToApSettingOpenApiVO lockToApSetting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lockToApSetting), request, response, omadacId);
    }

    @Operation(summary="Get client list filtering options", description="Get client list filtering options.")
    @a(b={k.CLIENTS_READ, k.DEVICES_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/search-fields-options"})
    @ResponseBody
    @com.a.a.a.a.a(a=9)
    public DeferredResult<OperationResponse<ClientFilteringOptionsOpenApiVO>> getClientFilteringOptions(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Disconnect the client", description="Disconnect the client.")
    @a(a={b.CLIENT_NOT_EXIST, b.CAN_NOT_DISCONNECT_WIRED_CLIENT}, b={k.CLIENTS_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/disconnect"})
    @ResponseBody
    @com.a.a.a.a.a(a=9)
    public DeferredResult<OperationResponseWithoutResult> disconnectClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Delete client", description="Delete client.")
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}"})
    @a(b={k.CLIENTS_WRITE, k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=9)
    public DeferredResult<OperationResponseWithoutResult> deleteClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Batch delete clients", description="Batch delete clients.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/delete"})
    @a(b={k.CLIENTS_WRITE, k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=10)
    public DeferredResult<OperationResponse<ClientDetailOpenApiVO>> deleteClients(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ClientsDeleteFilterOpenApiVO deleteFilterVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deleteFilterVO), request, response, omadacId);
    }

    @Operation(summary="Batch config clients", description="Batch config clients.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/config"})
    @a(b={k.CLIENTS_WRITE, k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=11)
    public DeferredResult<OperationResponse<ClientDetailOpenApiVO>> batchModifyClientSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ClientBatchSettingOpenApiVO batchSettingVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)batchSettingVO), request, response, omadacId);
    }

    @Operation(summary="Reboot the client", description="Reboot the client.")
    @a(a={b.INVALID_REQUEST_PARAMS, b.REBOOT_CLIENT_FAILED}, b={k.CLIENTS_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/reboot"})
    @ResponseBody
    @com.a.a.a.a.a(a=12)
    public DeferredResult<OperationResponse> rebootClient(@RequestBody ClientRebootOpenApiVO rebootOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)rebootOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get client correction options list", description="Get client correction options list")
    @a(b={k.CLIENTS_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/correction-list"})
    @ResponseBody
    @com.a.a.a.a.a(a=13)
    public DeferredResult<OperationResponse<ClientCorrectionOptionListVO>> getClientCorrectionList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Export client list", description="Export client list.")
    @a(b={k.CLIENTS_READ, k.DATA_EXPORT}, a={b.XLSX_DATA_EXPORT_EXCEED_LIMIT})
    @PostMapping(path={"/openapi/v1/{omadacId}/files/sites/{siteId}/clients/export"})
    @ResponseBody
    @com.a.a.a.a.a(a=12)
    public DeferredResult<OperationResponseWithoutResult> exportClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ClientExportOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Export global client list.", description="Export global client list.")
    @PostMapping(path={"/openapi/v1/{omadacId}/files/client-list"})
    @a(b={k.GLOBAL_DATA_EXPORT})
    @ResponseBody
    @com.a.a.a.a.a(a=13)
    public DeferredResult<OperationResponse> exportClientListGlobalByCloudAccess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody ExportClientListOpenApiVO exportClientListOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)exportClientListOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get History data retention config.", description="Get history data retention config.")
    @GetMapping(path={"/openapi/v1/{omadacId}/controller/client/history-enable"})
    @a(b={k.GLOBAL_SETTING_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=14)
    public DeferredResult<OperationResponse<OmadacClientSettingOpenApiVO>> getClientHistoryDataEnable(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary=" Get Client history.", description="Get Client history.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/client-history"})
    @a(b={k.CLIENTS_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=15)
    public DeferredResult<OperationResponse<GridVO<ClientHistoryVO>>> getGridClientHistory(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortsName, @Parameter(name="sorts.mac", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.mac", required=false) String sortsMac, @Parameter(name="sorts.ip", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.ip", required=false) String sortsIp, @Parameter(name="sorts.authType", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.authType", required=false) String sortsAuthType, @Parameter(name="sorts.ssidOrNetwork", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.ssidOrNetwork", required=false) String sortsSsidOrNetwork, @Parameter(name="sorts.download", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.download", required=false) String sortsDownload, @Parameter(name="sorts.upload", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.upload", required=false) String sortsUpload, @Parameter(name="sorts.status", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.status", required=false) String sortsStatus, @Parameter(name="sorts.start", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.start", required=false) String sortsStart, @Parameter(name="sorts.end", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.end", required=false) String sortsEnd, @Parameter(name="sorts.duration", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.duration", required=false) String sortsDuration, @Parameter(name="searchKey", description="Fuzzy query parameters, support field client_mac,client_name,voucher.code,local_user.user_name,form_name,auth_admin,ssid_name,network_name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get client link topology", description="Get client link topology.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/client-link-topology"})
    @a(b={k.CLIENTS_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=15)
    public DeferredResult<OperationResponse<List<ClientTopologyNodeOpenApiVO>>> getClientTopology(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get client connection histories", description="Get client connection histories.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/client-connection"})
    @a(b={k.CLIENTS_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=16)
    DeferredResult<OperationResponse<ClientJourneyOpenApiVO>> getClientJourney(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac, @Parameter(name="start", description="Start timestamp, unit: ms") @RequestParam(name="start", required=true) Long start, @Parameter(name="end", description="End timestamp, unit: ms") @RequestParam(name="end", required=true) Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get client timeline events", description="Get client timeline events.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/clients/{clientMac}/client-timeline"})
    @a(b={k.CLIENTS_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=17)
    DeferredResult<OperationResponse<List<ClientTimelineSessionOpenApiVO>>> getClientTimeline(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac, @Parameter(name="start", description="Start timestamp, unit: ms") @RequestParam(name="start", required=true) Long start, @Parameter(name="end", description="End timestamp, unit: ms") @RequestParam(name="end", required=true) Long end, @Parameter(name="type", description="Query type, 0: Connection Timeline; 1: Association; 2: Roaming; 3: Disconnection.") @RequestParam(name="type", required=true) Integer type) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Export all client list in GLOBAL view", description="Export all client list in GLOBAL view, .")
    @PostMapping(path={"/openapi/v1/{omadacId}/files/all-client-list"})
    @a(b={k.GLOBAL_DATA_EXPORT}, a={b.XLSX_DATA_EXPORT_EXCEED_LIMIT})
    @ResponseBody
    @com.a.a.a.a.a(a=18)
    DeferredResult<OperationResponse> globalExportAllClientList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody MultiSiteClientExportOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Get client statistical data details at a 5-minute interval.", description="Get client statistical data details at a 5-minute interval.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/client-stat-detail/{clientMac}/5Min"})
    @a(b={k.CLIENTS_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=19)
    public DeferredResult<OperationResponse<GetClientDetailStatResultOpenApiVO>> getClientDetailStat5Min(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac, @RequestBody ClientStatQueryOpenApiVO clientStatQueryVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)clientStatQueryVO), request, response, omadacId);
    }

    @Operation(summary="Get client statistical data details at a hourly interval.", description="Get client statistical data details at a hourly interval.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/client-stat-detail/{clientMac}/hourly"})
    @a(b={k.CLIENTS_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=20)
    public DeferredResult<OperationResponse<GetClientDetailStatResultOpenApiVO>> getClientDetailStatHourly(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac, @RequestBody ClientStatQueryOpenApiVO clientStatQueryVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)clientStatQueryVO), request, response, omadacId);
    }

    @Operation(summary="Get client statistical data details at a daily interval.", description="Get client statistical data details at a daily interval.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/client-stat-detail/{clientMac}/daily"})
    @a(b={k.CLIENTS_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=21)
    public DeferredResult<OperationResponse<GetClientDetailStatResultOpenApiVO>> getClientDetailStatDaily(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client MAC") @PathVariable(name="clientMac") String clientMac, @RequestBody ClientStatQueryOpenApiVO clientStatQueryVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)clientStatQueryVO), request, response, omadacId);
    }

    @Operation(summary="Get VIGI device link topology", description="Get VIGI device link topology.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/vigis/{vigiMac}/vigi-link-topology"})
    @a(b={k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=22)
    public DeferredResult<OperationResponse<List<ClientTopologyNodeOpenApiVO>>> getVigiTopology(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="vigiMac", description="VIGI device MAC") @PathVariable(name="vigiMac") String vigiMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get VIGI device connection histories", description="Get VIGI device connection histories.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/vigis/{vigiMac}/vigi-connection"})
    @a(b={k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=23)
    DeferredResult<OperationResponse<ClientJourneyOpenApiVO>> getVigiJourney(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="vigiMac", description="VIGI device MAC") @PathVariable(name="vigiMac") String vigiMac, @Parameter(name="start", description="Start timestamp, unit: ms") @RequestParam(name="start", required=true) Long start, @Parameter(name="end", description="End timestamp, unit: ms") @RequestParam(name="end", required=true) Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get VIGI device timeline events", description="Get VIGI device timeline events.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/vigis/{vigiMac}/vigi-timeline"})
    @a(b={k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=24)
    DeferredResult<OperationResponse<List<ClientTimelineSessionOpenApiVO>>> getVigiTimeline(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="vigiMac", description="VIGI device MAC") @PathVariable(name="vigiMac") String vigiMac, @Parameter(name="start", description="Start timestamp, unit: ms") @RequestParam(name="start", required=true) Long start, @Parameter(name="end", description="End timestamp, unit: ms") @RequestParam(name="end", required=true) Long end, @Parameter(name="type", description="Query type, 0: Connection Timeline; 1: Association; 2: Roaming; 3: Disconnection.") @RequestParam(name="type", required=true) Integer type) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get VIGI device statistical data details at a 5-minute interval.", description="Get VIGI device statistical data details at a 5-minute interval.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/vigi-stat-detail/{vigiMac}/5Min"})
    @a(b={k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=25)
    public DeferredResult<OperationResponse<GetClientDetailStatResultOpenApiVO>> getVigiDetailStat5Min(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="vigiMac", description="VIGI device MAC") @PathVariable(name="vigiMac") String vigiMac, @RequestBody ClientStatQueryOpenApiVO clientStatQueryVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)clientStatQueryVO), request, response, omadacId);
    }

    @Operation(summary="Get VIGI device statistical data details at a hourly interval.", description="Get VIGI device statistical data details at a hourly interval.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/vigi-stat-detail/{vigiMac}/hourly"})
    @a(b={k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=26)
    public DeferredResult<OperationResponse<GetClientDetailStatResultOpenApiVO>> getVigiDetailStatHourly(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="vigiMac", description="VIGI device MAC") @PathVariable(name="vigiMac") String vigiMac, @RequestBody ClientStatQueryOpenApiVO clientStatQueryVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)clientStatQueryVO), request, response, omadacId);
    }

    @Operation(summary="Get VIGI device statistical data details at a daily interval.", description="Get VIGI device statistical data details at a daily interval.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/vigi-stat-detail/{vigiMac}/daily"})
    @a(b={k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=27)
    public DeferredResult<OperationResponse<GetClientDetailStatResultOpenApiVO>> getVigiDetailStatDaily(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="vigiMac", description="VIGI device MAC") @PathVariable(name="vigiMac") String vigiMac, @RequestBody ClientStatQueryOpenApiVO clientStatQueryVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)clientStatQueryVO), request, response, omadacId);
    }

    @Operation(summary="Get global client statistics by device.", description="Get global client statistics by device.")
    @PostMapping(path={"/openapi/v1/{omadacId}/clients/stat/devices"})
    @a(b={k.DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=28)
    public DeferredResult<OperationResponse<List<DeviceClientNumOpenApiVO>>> globalClientStatByDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody GlobalDevicesQueryOpenApiVO queryVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryVO), request, response, omadacId);
    }

    @Operation(summary="Get msp client statistics by device.", description="Get Msp level client statistics by device.")
    @PostMapping(path={"/openapi/v1/msp/{mspId}/clients/stat/devices"})
    @a(b={k.MSP_DEVICES_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=29)
    public DeferredResult<OperationResponse<List<MspDeviceClientNumOpenApiVO>>> mspClientStatByDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @RequestBody MspDevicesQueryOpenApiVO queryVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryVO), request, response, mspId);
    }
}

