/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.client;

import com.a.a.a.a.a;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.client.api.openapi.vo.ClientHistoryOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.CustomerQueryOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.DeviceClientStatQueryOpenApiVO;
import com.tplink.smb.omada.client.api.web.vo.ActiveClientBubbleVO;
import com.tplink.smb.omada.client.api.web.vo.ActiveClientVO;
import com.tplink.smb.omada.client.api.web.vo.ClientActivitiesVO;
import com.tplink.smb.omada.client.api.web.vo.ClientAssociationTimeDistributionVO;
import com.tplink.smb.omada.client.api.web.vo.ClientRssiChannelDistributionVO;
import com.tplink.smb.omada.client.api.web.vo.ClientSignalDistributionVO;
import com.tplink.smb.omada.client.api.web.vo.ClientSummaryVO;
import com.tplink.smb.omada.client.api.web.vo.CustomerListClientNumVO;
import com.tplink.smb.omada.client.api.web.vo.DashboardDistributionVO;
import com.tplink.smb.omada.client.api.web.vo.DeviceClientStatVO;
import com.tplink.smb.omada.client.api.web.vo.EapRssiChannelDistributionVO;
import com.tplink.smb.omada.client.api.web.vo.KnownClientVO;
import com.tplink.smb.omada.client.api.web.vo.MspClientOverallVO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Client Insight")
@RestController
class ClientInsightOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientInsightOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    ClientInsightOpenApiController() {
    }

    @Operation(summary="Get client past connection list", description="Get client past connection list.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/insight/past-connection"})
    @com.tplink.smb.omada.common.m.a(b={k.INSIGHT_READ, k.CLIENTS_READ})
    @ResponseBody
    @a(a=1)
    public DeferredResult<OperationResponse<GridVO<ClientHistoryOpenApiVO>>> getGridPastConnections(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.lastSeen", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.lastSeen", required=false) String sortsLastSeen, @Parameter(name="filters.timeStart", description="Filter query parameters, support field time range: start timestamp (ms).") @RequestParam(name="filters.timeStart", required=false) String filtersTimeStart, @Parameter(name="filters.timeEnd", description="Filter query parameters, support field time range: end timestamp (ms).") @RequestParam(name="filters.timeEnd", required=false) String filtersTimeEnd, @Parameter(name="filters.guest", description="Filter query parameters, support field guest: true/false.") @RequestParam(name="filters.guest", required=false) String filtersGuest, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name,mac,ssid.") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get known clients list", description="Get known clients list.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/insight/clients"})
    @com.tplink.smb.omada.common.m.a(b={k.INSIGHT_READ, k.CLIENTS_READ})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponse<GridVO<KnownClientVO>>> getGridKnownClients(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.lastSeen", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.lastSeen", required=false) String sortsLastSeen, @Parameter(name="filters.timeStart", description="Filter query parameters, support field time range: start timestamp (ms).") @RequestParam(name="filters.timeStart", required=false) String filtersTimeStart, @Parameter(name="filters.timeEnd", description="Filter query parameters, support field time range: end timestamp (ms).") @RequestParam(name="filters.timeEnd", required=false) String filtersTimeEnd, @Parameter(name="filters.guest", description="Filter query parameters, support field guest: true/false.") @RequestParam(name="filters.guest", required=false) String filtersGuest, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name,mac,ssid.") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=3)
    @Operation(summary="Get client activity", description="Get client activity with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/client-activity"})
    @ResponseBody
    public DeferredResult<OperationResponse<List<ClientActivitiesVO>>> getClientActivity(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start", required=false) Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end", required=false) Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=4)
    @Operation(summary="Get past client number.", description="Get past client number with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/past-client-num"})
    @ResponseBody
    public DeferredResult<OperationResponse<ClientSummaryVO>> getPastClientNum(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=5)
    @Operation(summary="Get client distribution.", description="Get client distribution with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/client-distribution"})
    @ResponseBody
    public DeferredResult<OperationResponse<DashboardDistributionVO>> getClientsDistribution(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=6)
    @Operation(summary="Get most active client.", description="Get most active clients with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/active-clients"})
    @ResponseBody
    public DeferredResult<OperationResponse<List<ActiveClientVO>>> getMostActiveClients(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=7)
    @Operation(summary="Get device client 5 min stat.", description="Obtain the 5-minute sampling statistics of the clients.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.STATICS_READ})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/stat/{deviceMac}/client-stat-5min"})
    @ResponseBody
    DeferredResult<OperationResponse<List<? extends DeviceClientStatVO>>> getDeviceClient5MinStat(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @Parameter(name="deviceType", description="Device type.") @RequestParam(name="type") String deviceType, @RequestBody DeviceClientStatQueryOpenApiVO queryVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryVO), request, response, omadacId);
    }

    @a(a=8)
    @Operation(summary="Get the msp overview diagram of client.", description="Get the msp overview diagram of client")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.MSP_DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/msp/{mspId}/dashboard/client/overview-diagram"})
    @ResponseBody
    DeferredResult<OperationResponse<MspClientOverallVO>> getMspDashboardOverall(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @a(a=9)
    @Operation(summary="Get the Msp customers' client count.", description="Get the Msp customers' client count.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.MSP_DASHBOARD_READ})
    @PostMapping(path={"/openapi/v1/msp/{mspId}/customers/client-count"})
    @ResponseBody
    DeferredResult<OperationResponse<List<CustomerListClientNumVO>>> getClientNumberForCustomerList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @RequestBody CustomerQueryOpenApiVO queryOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryOpenApiVO), request, response, mspId);
    }

    @a(a=10)
    @Operation(summary="Get current client number.", description="Get current client number with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/current-client-num"})
    @ResponseBody
    DeferredResult<OperationResponse<ClientSummaryVO>> getCurrentClientNum(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=11)
    @Operation(summary="Get clients ssid distribution.", description="Get clients ssid distribution with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/client-ssid-distribution"})
    @ResponseBody
    DeferredResult<OperationResponse<ClientSummaryVO>> getClientsSsidDistribution(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=12)
    @Operation(summary="Get clients freq distribution.", description="Get clients freq distribution with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/client-freq-distribution"})
    @ResponseBody
    DeferredResult<OperationResponse<ClientSummaryVO>> getClientsFreqDistribution(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=13)
    @Operation(summary="Get longest client uptime.", description="Get longest client uptime with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/longest-uptime"})
    @ResponseBody
    DeferredResult<OperationResponse<ClientSummaryVO>> getLongestClientUptime(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=14)
    @Operation(summary="Get clients association activities.", description="Get clients association activities with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/client-association-activities"})
    @ResponseBody
    DeferredResult<OperationResponse<ClientSummaryVO>> getClientsAssociationActivities(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=15)
    @Operation(summary="Get clients rssi distribution.", description="Get clients rssi distribution with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/client-rssi-distribution"})
    @ResponseBody
    DeferredResult<OperationResponse<ClientRssiChannelDistributionVO>> getClientsRssiDistribution(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=16)
    @Operation(summary="Get clients bubble.", description="Get clients bubble with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/clients-bubble"})
    @ResponseBody
    public DeferredResult<OperationResponse<List<ActiveClientBubbleVO>>> getClientsBubble(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=17)
    @Operation(summary="Get ap density.", description="Get ap density with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/ap-density"})
    @ResponseBody
    public DeferredResult<OperationResponse<EapRssiChannelDistributionVO>> getApDensity(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=18)
    @Operation(summary="Get stack client stat.", description="Obtain the sampling statistics of the clients.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.STATICS_READ})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/stat/stacks/{stackId}/client-stat"})
    @ResponseBody
    DeferredResult<OperationResponse<List<DeviceClientStatVO>>> getStackClientStat(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="stackId", description="Stack ID") @PathVariable(name="stackId") String stackId, @RequestBody DeviceClientStatQueryOpenApiVO queryVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryVO), request, response, omadacId);
    }

    @a(a=19)
    @Operation(summary="Get clients signal distribution.", description="Get clients signal distribution with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/client-signal-distribution"})
    @ResponseBody
    DeferredResult<OperationResponse<ClientSignalDistributionVO>> getClientsBandDistribution(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=20)
    @Operation(summary="Get clients association time distribution.", description="Get clients association time distribution with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/client-association-time-distribution"})
    @ResponseBody
    DeferredResult<OperationResponse<ClientAssociationTimeDistributionVO>> getClientsAssociationTimeDistribution(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

