/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.analyze;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.analyze.api.openapi.CaptureInfoOpenApiVO;
import com.tplink.smb.omada.manager.analyze.api.openapi.CaptureResultOpenApiVO;
import com.tplink.smb.omada.manager.analyze.api.openapi.DeviceCaptureOpenApiVO;
import com.tplink.smb.omada.manager.analyze.api.openapi.DeviceInterfacesOpenApiVO;
import com.tplink.smb.omada.manager.analyze.api.openapi.DownloadCaptureFileOpenApiVO;
import com.tplink.smb.omada.manager.analyze.api.openapi.PackageCaptureOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Network Analyze")
@RestController
@b(a=60)
public class NetworkAnalyzeOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkAnalyzeOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get devices that can capture packages", description="Get the grid of devices that can capture packages.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/capture/all-devices/device-type/{deviceType}"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY}, b={k.SITE_ANALYZE_READ})
    @a(a=1)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<DeviceCaptureOpenApiVO>>> getAllCaptureDevices(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceType", description="Device type, and should be a value in [ap, switch, gateway].") @PathVariable(value="deviceType") String deviceType, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Start package capturing", description="Start package capturing.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/capture/device-type/{deviceType}/{deviceMac}/start"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY}, b={k.SITE_ANALYZE_WRITE})
    @a(a=2)
    @ResponseBody
    public DeferredResult<OperationResponse<CaptureInfoOpenApiVO>> startPackageCapture(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceType", description="Device type, and should be a value in [ap, switch, gateway].") @PathVariable(value="deviceType") String deviceType, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @RequestBody PackageCaptureOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Query package capture status", description="Query package capture status.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/capture/device-type/{deviceType}/{deviceMac}/{requestId}/status"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY}, b={k.SITE_ANALYZE_READ})
    @a(a=3)
    @ResponseBody
    public DeferredResult<OperationResponse<CaptureResultOpenApiVO>> queryPackageCaptureStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceType", description="Device type, and should be a value in [ap, switch, gateway].") @PathVariable(value="deviceType") String deviceType, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @Parameter(name="requestId", description="A GUID based on the timestamp.") @PathVariable(name="requestId") String requestId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a(null), request, response, omadacId);
    }

    @Operation(summary="Stop package capturing", description="Stop package capturing.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/capture/device-type/{deviceType}/{deviceMac}/stop"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY}, b={k.SITE_ANALYZE_WRITE})
    @a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> stopPackageCapture(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceType", description="Device type, and should be a value in [ap, switch, gateway].") @PathVariable(value="deviceType") String deviceType, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a(null), request, response, omadacId);
    }

    @Operation(summary="Download package capture file", description="Download package capture file.")
    @PostMapping(value={"/openapi/v1/{omadacId}/files/sites/{siteId}/capture/device-type/{deviceType}/{deviceMac}/download"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY}, b={k.SITE_ANALYZE_WRITE})
    @a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> downloadCaptureFile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceType", description="Device type, and should be a value in [ap, switch, gateway].") @PathVariable(value="deviceType") String deviceType, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac, @RequestBody DownloadCaptureFileOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Get device interfaces", description="Get device interfaces.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/capture/device-type/{deviceType}/{deviceMac}/interfaces"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY}, b={k.SITE_ANALYZE_READ})
    @a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponse<DeviceInterfacesOpenApiVO>> getDeviceInterfaces(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceType", description="Device type, and should be a value in [ap, switch, gateway].") @PathVariable(value="deviceType") String deviceType, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get last capture device", description="Get last capture device.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/capture/lastDevice"})
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SITE_BUSY}, b={k.SITE_ANALYZE_READ})
    @a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponse<DeviceInterfacesOpenApiVO>> getLastCaptureDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

