/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi;

import com.tplink.smb.omada.apigateway.openapi.interceptor.OpenApiRateLimiterHandler;
import com.tplink.smb.omada.apigateway.openapi.utils.OpenApiUtils;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.dispatcher.RestDispatcher;
import com.tplink.smb.omada.dispatcher.chain.AttributeRequestEntity;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.common.util.UserIpUtils;
import com.tplink.smb.omada.dispatcher.response.ApiHttpServletResponseWrapper;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.OauthTokenCacheDTO;
import com.tplink.smb.omada.identityaccess.api.internal.m;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class OpenApiHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenApiHandler.class);
    @Autowired
    private RestDispatcher restDispatcher;
    @Autowired
    private OpenApiRateLimiterHandler openApiRateLimiterHandler;
    @Autowired
    private m openApiInternalApiService;
    private static String REQUEST_BY_APP = "requestByApp";
    private static String REQUEST_SOURCE = "Omada-Request-Source";
    private static String APP_REMOTE = "app-remote";
    private static String APP_LOCAL = "app-local";
    private static String WEB_REMOTE = "web-remote";
    private static String WEB_LOCAL = "web-local";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleOpenApi(String body, HttpServletRequest request, HttpServletResponse response, String omadacId) {
        DeferredResult deferredResult = new DeferredResult();
        try {
            AttributeRequestEntity<String> requestEntity;
            Object requestAccessToken;
            UserIpUtils.setLocalUserIp((String)OpenApiUtils.getRemoteAddress(request));
            UserIpUtils.setOpenApiAddr((String)"open-api");
            String token = null;
            if (this.openApiRateLimiterHandler.limitedByUrlOrUser(request, omadacId)) {
                deferredResult.setResult((Object)new com.tplink.smb.omada.common.access.OperationResponse(b.aB));
                DeferredResult deferredResult2 = deferredResult;
                return deferredResult2;
            }
            if (!this.isRequestFromApp(request) && !this.isRequestFromWeb(request)) {
                String accessTokenFromHeader = request.getHeader("Authorization");
                String accessTokenFromRequest = request.getParameter("Authorization");
                if (T.a((String)accessTokenFromHeader) && T.a((String)accessTokenFromRequest)) {
                    deferredResult.setResult((Object)new com.tplink.smb.omada.common.access.OperationResponse(b.NC));
                    DeferredResult deferredResult3 = deferredResult;
                    return deferredResult3;
                }
                requestAccessToken = !T.c((String)accessTokenFromHeader) ? accessTokenFromHeader : accessTokenFromRequest;
                String accessToken = null;
                Map<String, String> map = OpenApiHandler.getAttributes((String)requestAccessToken);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!T.a((String)entry.getKey(), (String)"AccessToken")) continue;
                    accessToken = entry.getValue();
                }
                com.tplink.smb.omada.common.access.OperationResponse accessResp = this.openApiInternalApiService.c(accessToken);
                if (!accessResp.success() || Objects.isNull(accessResp.getResult())) {
                    deferredResult.setResult((Object)new com.tplink.smb.omada.common.access.OperationResponse(b.NB));
                    DeferredResult deferredResult2 = deferredResult;
                    return deferredResult2;
                }
                OauthTokenCacheDTO oauthTokenCacheDTO = (OauthTokenCacheDTO)accessResp.getResult();
                if (!this.openApiRateLimiterHandler.openApiPreHandle(request, oauthTokenCacheDTO.getOmadacId())) {
                    deferredResult.setResult((Object)new com.tplink.smb.omada.common.access.OperationResponse(b.aB));
                    DeferredResult deferredResult3 = deferredResult;
                    return deferredResult3;
                }
                token = accessToken;
            }
            try {
                requestEntity = OpenApiUtils.getStringAttributeRequestEntityThrowException(body, request);
                request.setAttribute("OMADA_REST_DISPATCHER_ATTRIBUTES", (Object)requestEntity.getAttributes());
            }
            catch (URISyntaxException e2) {
                log.warn("Resolve open api request failed", (Throwable)e2);
                deferredResult.setResult((Object)new com.tplink.smb.omada.common.access.OperationResponse(b.d, e2.getMessage(), null));
                requestAccessToken = deferredResult;
                UserIpUtils.setLocalUserIp(null);
                UserIpUtils.setOpenApiAddr(null);
                return requestAccessToken;
            }
            request.setAttribute("OMADA_REST_DISPATCHER_ATTRIBUTES", (Object)requestEntity.getAttributes());
            Map multipartFileMap = null;
            if (request instanceof MultipartHttpServletRequest) {
                multipartFileMap = ((MultipartHttpServletRequest)request).getFileMap();
            }
            Object result = this.restDispatcher.dispatchOpenApi(requestEntity, OpenApiUtils.getSessionId(request), omadacId, multipartFileMap, (ApiResponseWrapper)new ApiHttpServletResponseWrapper(response), token);
            Object object = this.tryEraseFileDownloadResponse(request, response, result);
            return object;
        }
        finally {
            UserIpUtils.setLocalUserIp(null);
            UserIpUtils.setOpenApiAddr(null);
        }
    }

    private boolean isRequestFromApp(HttpServletRequest request) {
        boolean appApiRequest = false;
        if ("true".equalsIgnoreCase(request.getHeader(REQUEST_BY_APP))) {
            appApiRequest = true;
        }
        if (APP_REMOTE.equalsIgnoreCase(request.getHeader(REQUEST_SOURCE)) || APP_LOCAL.equalsIgnoreCase(request.getHeader(REQUEST_SOURCE))) {
            appApiRequest = true;
        }
        return appApiRequest;
    }

    private boolean isRequestFromWeb(HttpServletRequest request) {
        boolean webApiRequest = false;
        if (WEB_REMOTE.equalsIgnoreCase(request.getHeader(REQUEST_SOURCE)) || WEB_LOCAL.equalsIgnoreCase(request.getHeader(REQUEST_SOURCE))) {
            webApiRequest = true;
        }
        return webApiRequest;
    }

    @Nullable
    private Object tryEraseFileDownloadResponse(HttpServletRequest request, HttpServletResponse response, Object result) {
        DeferredResult deferredResult = new DeferredResult();
        if (result instanceof OperationResponse) {
            if (((OperationResponse)result).success() && response.containsHeader("Content-Disposition")) {
                log.trace("Successfully downloaded file, ignoring OperationResponse:{}", result);
                deferredResult.setResult(null);
                return deferredResult;
            }
            OperationResponse dispatcherResult = (OperationResponse)result;
            com.tplink.smb.omada.common.access.OperationResponse operationResponse = new com.tplink.smb.omada.common.access.OperationResponse(dispatcherResult.getErrorCode(), dispatcherResult.getMsg(), dispatcherResult.getResult());
            deferredResult.setResult((Object)operationResponse);
            return deferredResult;
        }
        if (result instanceof DeferredResult) {
            ((DeferredResult)result).setResultHandler(res -> {
                if (!(res instanceof OperationResponse)) {
                    deferredResult.setResult((Object)com.tplink.smb.omada.common.access.OperationResponse.GENERAL_ERROR);
                    log.error("Failed to handle request: {}, unknown async result type: {}", (Object)request.getServletPath(), res.getClass());
                    return;
                }
                if (((OperationResponse)res).success() && response.containsHeader("Content-Disposition")) {
                    log.trace("Successfully downloaded file, ignoring DeferredResult OperationResponse:{}", res);
                    deferredResult.setResult(null);
                } else {
                    log.info("---------------deferredResult----------------{}", (Object)deferredResult);
                    OperationResponse dispatcherResult = (OperationResponse)res;
                    com.tplink.smb.omada.common.access.OperationResponse operationRes = new com.tplink.smb.omada.common.access.OperationResponse(dispatcherResult.getErrorCode(), dispatcherResult.getMsg(), dispatcherResult.getResult());
                    deferredResult.setResult((Object)operationRes);
                }
            });
            return deferredResult;
        }
        log.error("Failed to handle request: {}, unknown result type {}", (Object)request.getServletPath(), result.getClass());
        deferredResult.setResult((Object)com.tplink.smb.omada.common.access.OperationResponse.GENERAL_ERROR);
        return deferredResult;
    }

    private static Map<String, String> getAttributes(String attributes) {
        HashMap<String, String> attr = new HashMap<String, String>();
        Matcher m2 = Pattern.compile("(\\w+)=(.*?)(?=,\\w+=|$)").matcher(attributes);
        while (m2.find()) {
            attr.put(m2.group(1), m2.group(2));
        }
        return attr;
    }
}

