/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi;

import com.tplink.smb.omada.apigateway.openapi.dto.batch.ActionDTO;
import com.tplink.smb.omada.apigateway.openapi.dto.batch.BatchRequestDTO;
import com.tplink.smb.omada.apigateway.openapi.dto.batch.BatchResponseDTO;
import com.tplink.smb.omada.apigateway.openapi.interceptor.OpenApiRateLimiterHandler;
import com.tplink.smb.omada.apigateway.openapi.utils.OpenApiUtils;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.dispatcher.cache.ApiServiceCache;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.AttributeRequestEntity;
import com.tplink.smb.omada.dispatcher.chain.HandlerChainManager;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.common.util.UserIpUtils;
import com.tplink.smb.omada.dispatcher.response.ApiHttpServletResponseWrapper;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ExistCustomerDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.OauthTokenCacheDTO;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import com.tplink.smb.omada.identityaccess.api.internal.m;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.EnumerationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.util.UriTemplate;

@Service
public class BatchHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchHandler.class);
    public static final String ACCESS_TOKEN_KEY_PATTERN = "(\\w+)=(.*?)(?=,\\w+=|$)";
    private final UriTemplate openApiOmadacTemplate = new UriTemplate("/openapi/v{verNum}/{omadacId}");
    private final UriTemplate openApiMspTemplate = new UriTemplate("/openapi/v{verNum}/msp/{mspId}");
    private static final String REQUEST_BY_APP = "requestByApp";
    private static final String REQUEST_SOURCE = "Omada-Request-Source";
    private static final String APP_REMOTE = "app-remote";
    private static final String APP_LOCAL = "app-local";
    @Autowired
    private m openApiInternalApiService;
    @Autowired
    private OpenApiRateLimiterHandler openApiRateLimiterHandler;
    @Autowired
    private HandlerChainManager handlerChainManager;
    @Autowired
    private ApiServiceCache apiServiceCache;
    @Autowired
    private l omadacInternalApiService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResponse batchApiHandler(String omadacId, BatchRequestDTO body, HttpServletRequest request, HttpServletResponse response) {
        try {
            UserIpUtils.setLocalUserIp((String)OpenApiUtils.getRemoteAddress(request));
            UserIpUtils.setOpenApiAddr((String)"open-api");
            String token = null;
            boolean fromApp = this.isRequestFromApp(request);
            if (!fromApp) {
                String accessTokenFromHeader = request.getHeader("Authorization");
                String accessTokenFromRequest = request.getParameter("Authorization");
                if (T.a((String)accessTokenFromHeader) && T.a((String)accessTokenFromRequest)) {
                    OperationResponse operationResponse = new OperationResponse(b.NC);
                    return operationResponse;
                }
                String requestAccessToken = !T.c((String)accessTokenFromHeader) ? accessTokenFromHeader : accessTokenFromRequest;
                String accessToken = null;
                Map<String, String> map = BatchHandler.getAttributes(requestAccessToken);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!T.a((String)entry.getKey(), (String)"AccessToken")) continue;
                    accessToken = entry.getValue();
                }
                OperationResponse accessResp = this.openApiInternalApiService.c(accessToken);
                if (!accessResp.success() || Objects.isNull(accessResp.getResult())) {
                    OperationResponse operationResponse = new OperationResponse(b.NB);
                    return operationResponse;
                }
                OauthTokenCacheDTO oauthTokenCacheDTO = (OauthTokenCacheDTO)accessResp.getResult();
                if (!this.openApiRateLimiterHandler.openApiPreHandle(request, oauthTokenCacheDTO.getOmadacId())) {
                    OperationResponse operationResponse = new OperationResponse(b.aB);
                    return operationResponse;
                }
                token = accessToken;
            }
            AttributeRequestEntity<String> requestEntity = OpenApiUtils.getStringAttributeRequestEntity(x.a((Object)body), request);
            request.setAttribute("OMADA_REST_DISPATCHER_ATTRIBUTES", (Object)requestEntity.getAttributes());
            OperationResponse result = this.dispatchBatchApi(body, (ApiResponseWrapper<?>)new ApiHttpServletResponseWrapper(response), request, token, omadacId, false, fromApp);
            log.trace("Finish handle Batch API, response: {}", (Object)result);
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            UserIpUtils.setLocalUserIp(null);
            UserIpUtils.setOpenApiAddr(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResponse mspBatchApiHandler(String mspId, BatchRequestDTO body, HttpServletRequest request, HttpServletResponse response) {
        try {
            UserIpUtils.setLocalUserIp((String)OpenApiUtils.getRemoteAddress(request));
            UserIpUtils.setOpenApiAddr((String)"open-api");
            String token = null;
            boolean fromApp = this.isRequestFromApp(request);
            if (!fromApp) {
                String accessTokenFromHeader = request.getHeader("Authorization");
                String accessTokenFromRequest = request.getParameter("Authorization");
                if (T.a((String)accessTokenFromHeader) && T.a((String)accessTokenFromRequest)) {
                    OperationResponse operationResponse = new OperationResponse(b.NC);
                    return operationResponse;
                }
                String requestAccessToken = !T.c((String)accessTokenFromHeader) ? accessTokenFromHeader : accessTokenFromRequest;
                String accessToken = null;
                Map<String, String> map = BatchHandler.getAttributes(requestAccessToken);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!T.a((String)entry.getKey(), (String)"AccessToken")) continue;
                    accessToken = entry.getValue();
                }
                OperationResponse accessResp = this.openApiInternalApiService.c(accessToken);
                if (!accessResp.success() || Objects.isNull(accessResp.getResult())) {
                    OperationResponse operationResponse = new OperationResponse(b.NB);
                    return operationResponse;
                }
                OauthTokenCacheDTO oauthTokenCacheDTO = (OauthTokenCacheDTO)accessResp.getResult();
                if (!this.openApiRateLimiterHandler.openApiPreHandle(request, oauthTokenCacheDTO.getOmadacId())) {
                    OperationResponse operationResponse = new OperationResponse(b.aB);
                    return operationResponse;
                }
                token = accessToken;
            }
            AttributeRequestEntity<String> requestEntity = OpenApiUtils.getStringAttributeRequestEntity(x.a((Object)body), request);
            request.setAttribute("OMADA_REST_DISPATCHER_ATTRIBUTES", (Object)requestEntity.getAttributes());
            OperationResponse result = this.dispatchBatchApi(body, (ApiResponseWrapper<?>)new ApiHttpServletResponseWrapper(response), request, token, mspId, true, fromApp);
            log.trace("Finish handle Batch API, response: {}", (Object)result);
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            UserIpUtils.setLocalUserIp(null);
            UserIpUtils.setOpenApiAddr(null);
        }
    }

    private boolean isRequestFromApp(HttpServletRequest request) {
        boolean appApiRequest = false;
        if ("true".equalsIgnoreCase(request.getHeader(REQUEST_BY_APP))) {
            appApiRequest = true;
        }
        if (APP_REMOTE.equalsIgnoreCase(request.getHeader(REQUEST_SOURCE)) || APP_LOCAL.equalsIgnoreCase(request.getHeader(REQUEST_SOURCE))) {
            appApiRequest = true;
        }
        return appApiRequest;
    }

    private OperationResponse dispatchBatchApi(BatchRequestDTO batchBody, ApiResponseWrapper<?> responseWrapper, HttpServletRequest request, String accessToken, String omadacId, boolean isMsp, boolean fromApp) {
        OperationResponse batchBodyRes = this.checkBatchRequest(batchBody, omadacId, isMsp, fromApp);
        if (!batchBodyRes.success() || CollectionUtils.isEmpty((Collection)batchBody.getActions())) {
            return batchBodyRes;
        }
        boolean isInterrupt = batchBody.getInterrupt();
        List actions = batchBody.getActions();
        ArrayList responses = new ArrayList();
        boolean isAllSuccess = true;
        OperationResponse firstErrorRes = null;
        for (ActionDTO action : actions) {
            com.tplink.smb.omada.dispatcher.common.access.HttpMethod method;
            String path;
            ServiceMethodInfo serviceMethodInfo;
            boolean isSuccess = this.handleAction(action, responses, serviceMethodInfo = this.apiServiceCache.resolveMethod(path = action.getPath(), method = com.tplink.smb.omada.dispatcher.common.access.HttpMethod.resolve((String)action.getMethod())), responseWrapper, request, accessToken, omadacId);
            if (isSuccess) continue;
            if (isAllSuccess) {
                String errMsg = "Error occurred while executing path: " + action.getPath() + ", method: " + action.getMethod() + ".\n Error message: " + ((com.tplink.smb.omada.dispatcher.common.access.OperationResponse)responses.get(responses.size() - 1)).getMsg();
                firstErrorRes = new OperationResponse(b.F, errMsg, null);
                isAllSuccess = false;
            }
            if (!isInterrupt) continue;
            break;
        }
        return this.buildResponse(responses, firstErrorRes, isAllSuccess, isInterrupt, actions.size());
    }

    private OperationResponse checkBatchRequest(BatchRequestDTO batchBody, String omadacId, boolean isMsp, boolean fromApp) {
        OperationResponse checkBatchBody = batchBody.check(fromApp);
        if (!checkBatchBody.success() || CollectionUtils.isEmpty((Collection)batchBody.getActions())) {
            return new OperationResponse(checkBatchBody.getErrorCode(), checkBatchBody.getMsg(), null);
        }
        for (ActionDTO action : batchBody.getActions()) {
            OperationResponse isCustomer;
            String path = action.getPath();
            com.tplink.smb.omada.dispatcher.common.access.HttpMethod method = com.tplink.smb.omada.dispatcher.common.access.HttpMethod.resolve((String)action.getMethod());
            String errMsg = "Unsupported request in actions, path: " + path + ", method: " + method + ".";
            if (isMsp && !omadacId.equals(this.resolveMspId(path)) && !(isCustomer = this.omadacInternalApiService.a(new ExistCustomerDTO(omadacId, this.resolveOmadacId(path)))).success()) {
                log.debug("Unsupported path in Batch API cause different mspId and not customer, path:{}, method:{}", (Object)path, (Object)method);
                return new OperationResponse(new OperationResponse(b.u, errMsg, null));
            }
            if (!isMsp && !omadacId.equals(this.resolveOmadacId(path))) {
                log.debug("Unsupported path in Batch API cause different omadacId, path:{}, method:{}", (Object)path, (Object)method);
                return new OperationResponse(new OperationResponse(b.u, errMsg, null));
            }
            ServiceMethodInfo serviceMethodInfo = this.apiServiceCache.resolveMethod(path, method);
            if (serviceMethodInfo != null) continue;
            log.debug("Unsupported path in Batch API, path:{}, method:{}", (Object)path, (Object)method);
            return new OperationResponse(new OperationResponse(b.u, errMsg, null));
        }
        return OperationResponse.SUCCESS;
    }

    private boolean handleAction(ActionDTO action, List<com.tplink.smb.omada.dispatcher.common.access.OperationResponse<?>> responses, ServiceMethodInfo serviceMethodInfo, ApiResponseWrapper<?> responseWrapper, HttpServletRequest request, String accessToken, String omadacId) {
        String path = action.getPath();
        com.tplink.smb.omada.dispatcher.common.access.HttpMethod method = com.tplink.smb.omada.dispatcher.common.access.HttpMethod.resolve((String)action.getMethod());
        AttributeRequestEntity<String> requestEntity = this.buildActionRequestEntity(action, request, action.getMethod());
        Object response = this.handlerChainManager.createHandlerChain(method, serviceMethodInfo, requestEntity, OpenApiUtils.getSessionId(request), omadacId, null, responseWrapper, true, accessToken).execute();
        log.trace("Batch API action execution completed, path: {}, response: {}", (Object)path, response);
        if (response instanceof com.tplink.smb.omada.dispatcher.common.access.OperationResponse) {
            responses.add((com.tplink.smb.omada.dispatcher.common.access.OperationResponse)response);
            return ((com.tplink.smb.omada.dispatcher.common.access.OperationResponse)response).success();
        }
        if (response instanceof DeferredResult) {
            try {
                CompletableFuture future = new CompletableFuture();
                DeferredResult deferredResult = (DeferredResult)response;
                deferredResult.onTimeout(() -> {
                    responses.add((com.tplink.smb.omada.dispatcher.common.access.OperationResponse<?>)OperationResponse.GENERAL_ERROR);
                    log.error("Handle Batch API DeferredResult response timeout, path: {}, method: {}.", (Object)path, (Object)action.getMethod());
                });
                deferredResult.onError(throwable -> {
                    responses.add((com.tplink.smb.omada.dispatcher.common.access.OperationResponse<?>)OperationResponse.GENERAL_ERROR);
                    log.error("Handle Batch API DeferredResult response error, path: {}, method: {}.", new Object[]{path, action.getMethod(), throwable});
                });
                deferredResult.onCompletion(() -> log.trace("Handle Batch API DeferredResult response success, path: {}, method: {}.", (Object)path, (Object)action.getMethod()));
                deferredResult.setResultHandler(res -> future.complete((OperationResponse)res));
                com.tplink.smb.omada.dispatcher.common.access.OperationResponse operationResponse = (com.tplink.smb.omada.dispatcher.common.access.OperationResponse)future.get();
                responses.add(operationResponse);
                return operationResponse.success();
            }
            catch (InterruptedException e2) {
                responses.add((com.tplink.smb.omada.dispatcher.common.access.OperationResponse<?>)OperationResponse.GENERAL_ERROR);
                log.error("Failed to handle Batch API DeferredResult response, path: {}, method: {}.", new Object[]{path, action.getMethod(), e2});
                Thread.currentThread().interrupt();
                return false;
            }
            catch (Exception e3) {
                responses.add((com.tplink.smb.omada.dispatcher.common.access.OperationResponse<?>)OperationResponse.GENERAL_ERROR);
                log.error("Failed to handle Batch API DeferredResult response, path: {}, method: {}.", new Object[]{path, action.getMethod(), e3});
                return false;
            }
        }
        log.error("Failed to handle Batch API response, path: {}, method: {}.", (Object)path, (Object)action.getMethod());
        responses.add((com.tplink.smb.omada.dispatcher.common.access.OperationResponse<?>)OperationResponse.GENERAL_ERROR);
        return false;
    }

    private OperationResponse buildResponse(List<com.tplink.smb.omada.dispatcher.common.access.OperationResponse<?>> responses, OperationResponse firstErrorRes, boolean isAllSuccess, boolean isInterrupt, int size) {
        while (!isAllSuccess && isInterrupt && responses.size() < size) {
            responses.add((com.tplink.smb.omada.dispatcher.common.access.OperationResponse<?>)new OperationResponse(b.E));
            if (responses.size() != 20) continue;
        }
        BatchResponseDTO batchResponse = new BatchResponseDTO(responses);
        if (isAllSuccess) {
            return OperationResponse.success((Object)batchResponse);
        }
        return new OperationResponse(firstErrorRes.getErrorCode(), firstErrorRes.getMsg(), (Object)batchResponse);
    }

    private AttributeRequestEntity<String> buildActionRequestEntity(ActionDTO action, HttpServletRequest request, String method) {
        HttpHeaders headers = new HttpHeaders();
        Enumeration e2 = request.getHeaderNames();
        while (e2.hasMoreElements()) {
            String headerName = (String)e2.nextElement();
            headers.put(headerName, EnumerationUtils.toList((Enumeration)request.getHeaders(headerName)));
        }
        String remoteAddress = OpenApiUtils.getRemoteAddress(request);
        if (T.b((String)remoteAddress)) {
            headers.put("Omada-Remote-IP-Address", Collections.singletonList(remoteAddress));
        }
        String accessToken = OpenApiUtils.getAccessToken(request);
        log.trace("getStringRequestEntity by open api, accessToken:{}, request:{}", (Object)accessToken, (Object)request.getHeader("Authorization"));
        if (T.b((String)accessToken)) {
            headers.put("Omada-OpenApi-Access-Token", Collections.singletonList(accessToken));
        }
        RequestEntity entity = null;
        try {
            URI url = action.getQuery() != null ? new URI(action.getPath() + action.getQuery()) : new URI(action.getPath());
            entity = new RequestEntity((Object)action.getBody(), (MultiValueMap)headers, HttpMethod.valueOf((String)method), url, String.class);
        }
        catch (URISyntaxException e3) {
            log.warn(e3.toString(), (Throwable)e3);
        }
        if (entity == null) {
            log.warn("Batch API build action requestEntity failed, entity is null. Action: {}", (Object)action);
            return null;
        }
        return new AttributeRequestEntity(entity);
    }

    private static Map<String, String> getAttributes(String attributes) {
        HashMap<String, String> attr = new HashMap<String, String>();
        Matcher m2 = Pattern.compile(ACCESS_TOKEN_KEY_PATTERN).matcher(attributes);
        while (m2.find()) {
            attr.put(m2.group(1), m2.group(2));
        }
        return attr;
    }

    @Nullable
    private String resolveOmadacId(String path) {
        Map omadacUriMap = this.openApiOmadacTemplate.match(path);
        String omadacId = null;
        if (omadacUriMap.containsKey("omadacId")) {
            omadacId = (String)omadacUriMap.get("omadacId");
        }
        return omadacId;
    }

    @Nullable
    private String resolveMspId(String path) {
        Map mspUriMap = this.openApiMspTemplate.match(path);
        String mspId = null;
        if (mspUriMap.containsKey("mspId")) {
            mspId = (String)mspUriMap.get("mspId");
        }
        return mspId;
    }
}

