/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.cluster.domain.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.b.b;
import com.tplink.smb.omada.common.util.system.NodeInfo;
import com.tplink.smb.omada.common.util.system.c;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.cluster.api.internal.a.a.e;
import com.tplink.smb.omada.manager.cluster.api.internal.a.b.a;
import com.tplink.smb.omada.manager.cluster.api.internal.dto.ClusterReqDTO;
import com.tplink.smb.omada.manager.cluster.api.internal.dto.ClusterRespDTO;
import com.tplink.smb.omada.manager.cluster.api.internal.i;
import com.tplink.smb.omada.manager.cluster.api.web.dto.NodeInfoVO;
import com.tplink.smb.omada.manager.cluster.domain.model.m;
import com.tplink.smb.omada.manager.device.domain.model.omadac.g;
import com.tplink.smb.omada.manager.device.domain.model.omadac.o;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class l {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(l.class);
    private static final int b = 1;
    @Autowired
    private i c;
    @Autowired
    private g d;

    public boolean a(Map<String, NodeInfo> nodeInfoDBMap) {
        if (!com.tplink.smb.omada.common.util.system.a.c()) {
            return true;
        }
        int nodeTimeNotSyncCount = 0;
        int nodeTimeRespCount = 1;
        int nodeNotConnectCount = 0;
        int nodeRespCount = 0;
        for (NodeInfo nodeInfo : nodeInfoDBMap.values()) {
            if (nodeInfo.getRole() != null && nodeInfo.getRole() == 1) {
                ++nodeRespCount;
            }
            if (Objects.equals(nodeInfo.getNodeId(), com.tplink.smb.omada.common.util.system.a.h())) continue;
            boolean reachAble = this.a(nodeInfo.getNodeIp());
            if (!reachAble && nodeInfo.getRole() != null && nodeInfo.getRole() == 1) {
                ++nodeNotConnectCount;
                continue;
            }
            OperationResponse<ClusterRespDTO> monitorInfoResp = this.a(nodeInfo);
            Long otherNodeSysTime = Optional.ofNullable(monitorInfoResp).map(OperationResponse::getResult).map(ClusterRespDTO::getSysTime).orElse(null);
            if (otherNodeSysTime == null) continue;
            ++nodeTimeRespCount;
            if (!NodeInfoVO.checkTimeOutOfSync((Long)otherNodeSysTime)) continue;
            ++nodeTimeNotSyncCount;
        }
        if (nodeTimeNotSyncCount > nodeTimeRespCount / 2) {
            a.warn("failed to reBalance, current node time is not sync.");
            return false;
        }
        if (nodeNotConnectCount > nodeRespCount / 2) {
            a.warn("failed to reBalance, current node is disconnected from more than half of the mixed nodes in the cluster.");
            return false;
        }
        return true;
    }

    public OperationResponse<ClusterRespDTO> a(NodeInfo nodeInfo) {
        OperationResponse monitorInfoResp = null;
        if (com.tplink.smb.omada.common.util.system.c.a().containsKey(nodeInfo.getNodeId())) {
            monitorInfoResp = this.c.c(new ClusterReqDTO().setNodeId(nodeInfo.getNodeId()));
        } else if (Boolean.TRUE.equals(nodeInfo.getEnable())) {
            monitorInfoResp = this.b(nodeInfo);
        }
        return monitorInfoResp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResponse<ClusterRespDTO> b(NodeInfo nodeInfo) {
        ManagedChannel channelForNode = ManagedChannelBuilder.forAddress((String)nodeInfo.getNodeIp(), (int)9098).usePlaintext().build();
        try {
            a.c stub = (a.c)com.tplink.smb.omada.manager.cluster.api.internal.a.b.a.b((Channel)channelForNode).withDeadlineAfter(1L, TimeUnit.SECONDS);
            com.tplink.smb.omada.manager.cluster.api.internal.a.a.b request = com.tplink.smb.omada.manager.cluster.api.internal.a.a.b.e().a(com.tplink.smb.omada.common.util.b.b.c((String)x.a((Object)new ClusterReqDTO().setNodeId(nodeInfo.getNodeId())))).f();
            e response = stub.c(request);
            OperationResponse operationResponse = (OperationResponse)x.a((String)com.tplink.smb.omada.common.util.b.b.e((String)response.b()), (TypeReference)new m(this));
            return operationResponse;
        }
        catch (Exception e2) {
            a.info("can not get nodeInfo for node:{}, {}", (Object)nodeInfo.getNodeId(), (Object)e2.getMessage());
            OperationResponse operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.b);
            return operationResponse;
        }
        finally {
            channelForNode.shutdown();
        }
    }

    public boolean a(String nodeIp) {
        boolean reachable = false;
        try {
            InetAddress address = InetAddress.getByName(nodeIp);
            reachable = address.isReachable(1000);
        }
        catch (Exception e2) {
            a.info("Node {} is not reachable: {}", (Object)nodeIp, (Object)e2.getMessage());
        }
        return reachable;
    }

    public com.tplink.smb.omada.manager.j.a.a.c a() {
        o spec = this.d.a().orElse(null);
        if (spec instanceof o.d) {
            return spec.a();
        }
        if (spec instanceof o.b) {
            return ((o.b)spec).e();
        }
        return null;
    }
}

