/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.radius.d;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.manager.configuration.api.internal.site.authentication.b;
import com.tplink.smb.omada.manager.configuration.api.internal.site.authentication.dto.RadiusProfileDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.authentication.dto.embed.RadiusAcctServerDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.authentication.dto.embed.RadiusAuthServerDTO;
import com.tplink.smb.omada.portal.port.radius.proxy.RadiusProxyConnectionCacheDTO;
import com.tplink.smb.omada.portal.port.radius.proxy.a;
import com.tplink.smb.omada.portal.radius.d.c;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.tinyradius.attribute.IntegerAttribute;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.attribute.StringAttribute;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusUtil;

public class e
implements Runnable {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(e.class);
    private ChannelHandlerContext b;
    private RadiusPacket c;
    private String d;
    private Integer e;
    private String f;
    private c g;
    private b h;
    private a i;

    public e(ChannelHandlerContext ctx, RadiusPacket radiusPacket, String sourceIp, Integer sourcePort, c forwardType, String proxyId) {
        this.b = ctx;
        this.c = radiusPacket;
        this.d = sourceIp;
        this.e = sourcePort;
        this.f = proxyId;
        this.g = forwardType;
        this.h = (b)com.tplink.smb.omada.common.spring.a.b(b.class);
        this.i = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
    }

    @Override
    public void run() {
        try {
            if (Objects.equals((Object)com.tplink.smb.omada.portal.radius.d.c.a, (Object)this.g)) {
                this.a();
            } else if (Objects.equals((Object)com.tplink.smb.omada.portal.radius.d.c.b, (Object)this.g)) {
                this.b();
            }
        }
        catch (Exception e2) {
            a.error("Failed to run {} : {}", new Object[]{this.getClass(), e2.getMessage(), e2});
        }
    }

    private void a() {
        if (this.f == null) {
            a.warn("Invalid proxyId, drop radius proxy message {}", (Object)this.c);
            return;
        }
        OperationResponse response = this.h.a(this.f);
        if (!response.success() || response.getResult() == null) {
            a.warn("Unable to find radius profile {}, Drop invalid proxy radius packet {}", (Object)this.f, (Object)this.c);
            return;
        }
        RadiusProfileDTO radiusProfile = (RadiusProfileDTO)response.getResult();
        if (!Boolean.TRUE.equals(radiusProfile.getProxyEnable())) {
            a.warn("Radius profile {} does not support proxy.", (Object)this.f);
            return;
        }
        int packetType = this.c.getPacketType();
        if (packetType != 1 && packetType != 4) {
            a.warn("Unable to forward packet of type code {}", (Object)packetType);
            return;
        }
        this.a(radiusProfile, packetType);
    }

    private void a(RadiusProfileDTO radiusProfile, int packetType) {
        StringAttribute radiusServer = (StringAttribute)this.c.getAttribute("TPLink-Radius-Server");
        IntegerAttribute radiusServerPort = (IntegerAttribute)this.c.getAttribute("TPLink-Radius-Server-Port");
        if (radiusServer == null || radiusServer.getAttributeValue() == null) {
            a.debug("Unable to find VSA:TPLink-Radius-Server, drop message");
            return;
        }
        String serverAddress = null;
        Integer serverPort = null;
        String secrect = null;
        if (packetType == 1 && !CollectionUtils.isEmpty((Collection)radiusProfile.getAuthServer())) {
            for (RadiusAuthServerDTO authServer : radiusProfile.getAuthServer()) {
                if (radiusServerPort != null && Objects.equals(authServer.getRadiusServerIp(), radiusServer.getAttributeValue()) && Objects.equals(authServer.getRadiusPort(), radiusServerPort.getAttributeValueInt())) {
                    serverAddress = authServer.getRadiusServerIp();
                    serverPort = authServer.getRadiusPort();
                    secrect = authServer.getRadiusPwd();
                } else {
                    if (radiusServerPort != null || !Objects.equals(authServer.getRadiusServerIp(), radiusServer.getAttributeValue())) continue;
                    serverAddress = authServer.getRadiusServerIp();
                    serverPort = authServer.getRadiusPort();
                    secrect = authServer.getRadiusPwd();
                }
                break;
            }
        } else if (packetType == 4 && !CollectionUtils.isEmpty((Collection)radiusProfile.getAcctServer())) {
            for (RadiusAcctServerDTO acctServer : radiusProfile.getAcctServer()) {
                if (radiusServerPort != null && Objects.equals(acctServer.getAccountingServerIp(), radiusServer.getAttributeValue()) && Objects.equals(acctServer.getAccountingServerPort(), radiusServerPort.getAttributeValueInt())) {
                    serverAddress = acctServer.getAccountingServerIp();
                    serverPort = acctServer.getAccountingServerPort();
                    secrect = acctServer.getAccountingServerPwd();
                } else {
                    if (radiusServerPort != null || !Objects.equals(acctServer.getAccountingServerIp(), radiusServer.getAttributeValue())) continue;
                    serverAddress = acctServer.getAccountingServerIp();
                    serverPort = acctServer.getAccountingServerPort();
                    secrect = acctServer.getAccountingServerPwd();
                }
                break;
            }
        }
        if (serverAddress == null || serverPort == null || secrect == null) {
            a.warn("Unable to find remote radius server {} from profile {}", (Object)radiusServer.getAttributeValue(), (Object)radiusProfile);
            return;
        }
        try {
            byte[] originRequestAuthenticator = new byte[16];
            System.arraycopy(this.c.getAuthenticator(), 0, originRequestAuthenticator, 0, 16);
            RadiusProxyConnectionCacheDTO cacheDTO = new RadiusProxyConnectionCacheDTO();
            cacheDTO.setDeviceIp(this.d);
            cacheDTO.setDevicePort(this.e);
            cacheDTO.setRadiusServerIp(serverAddress);
            cacheDTO.setRadiusServerPort(serverPort);
            cacheDTO.setSecret(secrect);
            cacheDTO.setRequestPacket(this.c);
            cacheDTO.setOriginRequestAuthenticator(originRequestAuthenticator);
            String proxyStateStr = ObjectId.get().toString();
            this.c.addAttribute(new RadiusAttribute(33, proxyStateStr.getBytes()));
            this.i.a(proxyStateStr, cacheDTO);
            if (packetType == 1) {
                DatagramPacket outPutPacket = this.a(this.c, secrect, serverPort, serverAddress);
                this.b.writeAndFlush((Object)outPutPacket);
            } else if (packetType == 4) {
                DatagramPacket outPutPacket = this.b(this.c, secrect, serverPort, serverAddress);
                this.b.writeAndFlush((Object)outPutPacket);
            }
        }
        catch (IOException e2) {
            a.debug("IOException occurs when connecting Radius server:{}", (Object)e2.getMessage(), (Object)e2);
        }
    }

    private void b() {
        List proxyStates = this.c.getAttributes(33);
        if (CollectionUtils.isEmpty((Collection)proxyStates)) {
            return;
        }
        RadiusAttribute proxyState = (RadiusAttribute)proxyStates.get(proxyStates.size() - 1);
        String stateString = new String(proxyState.getAttributeData());
        RadiusProxyConnectionCacheDTO radiusProxyConnection = this.i.a(stateString);
        if (radiusProxyConnection == null) {
            a.warn("Received response packet unable to find proxy connection of state {}", (Object)stateString);
            return;
        }
        a.debug("forward response packet to {}:{}", (Object)radiusProxyConnection.getDeviceIp(), (Object)radiusProxyConnection.getDevicePort());
        this.c.removeAttributes(33);
        RadiusPacket forwardPacket = new RadiusPacket(this.c.getPacketType(), this.c.getPacketIdentifier(), this.c.getAttributes());
        try {
            RadiusAttribute messageAuthenticator = forwardPacket.getAttribute(80);
            if (messageAuthenticator != null) {
                forwardPacket.removeAttributes(80);
                forwardPacket.setSignPacket(true);
            }
            if (radiusProxyConnection.getRequestPacket() != null) {
                radiusProxyConnection.getRequestPacket().setAuthenticator(radiusProxyConnection.getOriginRequestAuthenticator());
            }
            DatagramPacket outPutPacket = com.tplink.smb.omada.portal.radius.c.c.a(forwardPacket, radiusProxyConnection.getDevicePort(), radiusProxyConnection.getDeviceIp(), radiusProxyConnection.getSecret(), radiusProxyConnection.getRequestPacket());
            this.b.writeAndFlush((Object)outPutPacket);
        }
        catch (IOException e2) {
            a.debug("IOException occurs when connecting Radius server:{}", (Object)e2.getMessage(), (Object)e2);
        }
    }

    private DatagramPacket a(RadiusPacket radiusPacket, String secrect, Integer serverPort, String serverAddress) throws IOException {
        RadiusAttribute messageAuthenticator = radiusPacket.getAttribute(80);
        if (messageAuthenticator != null) {
            radiusPacket.removeAttributes(80);
            radiusPacket.setSignPacket(true);
            com.tplink.smb.omada.portal.radius.c.c.a(radiusPacket, radiusPacket, secrect);
        }
        return com.tplink.smb.omada.portal.radius.c.c.a(radiusPacket, serverPort, serverAddress);
    }

    private DatagramPacket b(RadiusPacket radiusPacket, String secrect, Integer serverPort, String serverAddress) throws IOException {
        ByteArrayOutputStream attrBos = new ByteArrayOutputStream(4096);
        for (RadiusAttribute a2 : radiusPacket.getAttributes()) {
            attrBos.write(a2.writeAttribute());
        }
        attrBos.flush();
        byte[] attributes = attrBos.toByteArray();
        int packetLength = 20 + attributes.length;
        byte[] zeroOctets = new byte[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            zeroOctets[i2] = 0;
        }
        MessageDigest md5 = DigestUtils.getMd5Digest();
        md5.reset();
        md5.update((byte)radiusPacket.getPacketType());
        md5.update((byte)radiusPacket.getPacketIdentifier());
        md5.update((byte)(packetLength >> 8));
        md5.update((byte)(packetLength & 0xFF));
        md5.update(zeroOctets, 0, zeroOctets.length);
        md5.update(attributes, 0, attributes.length);
        md5.update(RadiusUtil.getUtf8Bytes((String)secrect));
        radiusPacket.setAuthenticator(md5.digest());
        return com.tplink.smb.omada.portal.radius.c.c.a(radiusPacket, serverPort, serverAddress);
    }
}

