/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.radius.c;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.socket.DatagramPacket;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.dictionary.AttributeType;
import org.tinyradius.dictionary.DefaultDictionary;
import org.tinyradius.dictionary.MemoryDictionary;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusException;

public class c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);

    public static RadiusAttribute a(int attributeTypeCode, int vendorId) {
        RadiusAttribute attribute = new RadiusAttribute();
        MemoryDictionary dictionary = (MemoryDictionary)DefaultDictionary.getDefaultDictionary();
        AttributeType attributeInfo = dictionary.getAttributeTypeByCode(vendorId, attributeTypeCode);
        if (attributeInfo != null && attributeInfo.getAttributeClass() != null) {
            try {
                attribute = (RadiusAttribute)attributeInfo.getAttributeClass().newInstance();
            }
            catch (Exception e2) {
                a.warn(e2.toString(), (Throwable)e2);
            }
        }
        attribute.setAttributeType(attributeTypeCode);
        attribute.setVendorId(vendorId);
        return attribute;
    }

    public static RadiusPacket a(ByteBuf byteBuf) throws RadiusException {
        int attributeLength;
        int offset;
        int attributeLength2;
        ByteBuffer content = byteBuf.nioBuffer();
        int typeCode = Byte.toUnsignedInt(content.get());
        int identifier = Byte.toUnsignedInt(content.get());
        short length = content.getShort();
        if (length < 20) {
            throw new RadiusException("bad packet: packet too short (" + length + " bytes)");
        }
        if (length > 4096) {
            throw new RadiusException("bad packet: packet too long (" + length + " bytes)");
        }
        byte[] authenticator = new byte[16];
        byte[] attributeData = new byte[length - 20];
        content.get(authenticator);
        if (content.remaining() != length - 20) {
            throw new RadiusException("bad packet: packet length mismatch");
        }
        content.get(attributeData);
        for (offset = 0; offset < attributeData.length; offset += attributeLength2) {
            if (offset + 1 >= attributeData.length) {
                throw new RadiusException("bad packet: attribute length mismatch");
            }
            attributeLength2 = Byte.toUnsignedInt(attributeData[offset + 1]);
            if (attributeLength2 >= 2) continue;
            throw new RadiusException("bad packet: invalid attribute length");
        }
        if (offset != attributeData.length) {
            throw new RadiusException("bad packet: attribute length mismatch");
        }
        RadiusPacket radiusPacket = new RadiusPacket();
        radiusPacket.setPacketType(typeCode);
        radiusPacket.setPacketIdentifier(identifier);
        radiusPacket.setAuthenticator(authenticator);
        for (offset = 0; offset < attributeData.length; offset += attributeLength) {
            int attributeTypeCode = Byte.toUnsignedInt(attributeData[offset]);
            attributeLength = Byte.toUnsignedInt(attributeData[offset + 1]);
            RadiusAttribute attribute = c.a(attributeTypeCode, -1);
            attribute.readAttribute(attributeData, offset, attributeLength);
            radiusPacket.addAttribute(attribute);
        }
        a.debug("Radius-Request packet:{}", (Object)radiusPacket);
        return radiusPacket;
    }

    public static DatagramPacket a(RadiusPacket packet, int port, String hostName, String sharedSecret, RadiusPacket requestPacket) throws IOException {
        InetSocketAddress remoteAddress;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        packet.encodeResponsePacket((OutputStream)bos, sharedSecret, requestPacket);
        byte[] data = bos.toByteArray();
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeBytes(data);
        InetAddress address = null;
        try {
            address = InetAddress.getByName(hostName);
            remoteAddress = new InetSocketAddress(address, port);
        }
        catch (UnknownHostException e2) {
            a.debug("UnknownHostException occurs when makeResponseDatagramPacket:{},{},{}", new Object[]{hostName, address, port});
            throw e2;
        }
        return new DatagramPacket(byteBuf, remoteAddress);
    }

    public static DatagramPacket a(RadiusPacket packet, int port, String hostName, String sharedSecret) throws IOException {
        InetSocketAddress remoteAddress;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        packet.encodeRequestPacket((OutputStream)bos, sharedSecret);
        byte[] data = bos.toByteArray();
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeBytes(data);
        InetAddress address = null;
        try {
            address = InetAddress.getByName(hostName);
            remoteAddress = new InetSocketAddress(address, port);
        }
        catch (UnknownHostException e2) {
            a.debug("UnknownHostException occurs when makeRequestDatagramPacket:{},{},{}", new Object[]{hostName, address, port});
            throw e2;
        }
        return new DatagramPacket(byteBuf, remoteAddress);
    }

    public static DatagramPacket a(RadiusPacket packet, int port, String hostName) throws IOException {
        InetSocketAddress remoteAddress;
        ByteArrayOutputStream attrBos = new ByteArrayOutputStream(4096);
        for (RadiusAttribute a2 : packet.getAttributes()) {
            attrBos.write(a2.writeAttribute());
        }
        attrBos.flush();
        byte[] attributes = attrBos.toByteArray();
        int packetLength = 20 + attributes.length;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeByte(packet.getPacketType());
        dos.writeByte(packet.getPacketIdentifier());
        dos.writeShort(packetLength);
        dos.write(packet.getAuthenticator());
        dos.write(attributes);
        dos.flush();
        byte[] data = bos.toByteArray();
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeBytes(data);
        InetAddress address = null;
        try {
            address = InetAddress.getByName(hostName);
            remoteAddress = new InetSocketAddress(address, port);
        }
        catch (UnknownHostException e2) {
            a.debug("UnknownHostException occurs when encodeDatagramPacket:{},{},{}", new Object[]{hostName, address, port});
            throw e2;
        }
        return new DatagramPacket(byteBuf, remoteAddress);
    }

    public static void a(RadiusPacket origin, RadiusPacket request, String sharedSecret) {
        RadiusAttribute msgAuthenticator = origin.getAttribute(80);
        if (msgAuthenticator == null) {
            msgAuthenticator = new RadiusAttribute(80, new byte[16]);
            origin.addAttribute(msgAuthenticator);
        }
        ByteBuffer buf = ByteBuffer.allocate(4096);
        buf.put((byte)origin.getPacketType());
        buf.put((byte)request.getPacketIdentifier());
        buf.mark();
        buf.putShort((short)0);
        buf.put(request.getAuthenticator());
        for (RadiusAttribute attr : origin.getAttributes()) {
            buf.put(attr.writeAttribute());
        }
        int size = buf.position();
        buf.reset();
        buf.putShort((short)size);
        buf.position(size);
        buf.flip();
        try {
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(new SecretKeySpec(sharedSecret.getBytes(), "HMAC-MD5"));
            mac.update(buf);
            byte[] signature = new byte[16];
            System.arraycopy(mac.doFinal(), 0, signature, 0, signature.length);
            msgAuthenticator.setAttributeData(signature);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }
}

