/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.radius.a;

import com.tplink.smb.omada.client.common.domain.a.h;
import com.tplink.smb.omada.client.common.domain.model.shared.r;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.portal.domain.model.b.i;
import com.tplink.smb.omada.portal.domain.model.c.f;
import com.tplink.smb.omada.portal.domain.model.c.q;
import com.tplink.smb.omada.portal.domain.service.auth.l;
import com.tplink.smb.omada.portal.radius.a.a;
import com.tplink.smb.omada.portal.radius.a.c;
import com.tplink.smb.omada.portal.radius.b.d;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.socket.DatagramPacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.tinyradius.attribute.IntegerAttribute;
import org.tinyradius.attribute.IpAttribute;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.attribute.StringAttribute;
import org.tinyradius.dictionary.AttributeType;
import org.tinyradius.dictionary.DefaultDictionary;
import org.tinyradius.dictionary.MemoryDictionary;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusException;
import org.tinyradius.util.RadiusUtil;

public class b
implements Runnable {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(b.class);
    public static final int a = 1;
    private final ByteBuf c;
    private final String d;
    private final int e;
    private final int f;
    private final l g;
    private final f h;
    private final com.tplink.smb.omada.portal.domain.model.h.f.d i;
    private final i j;
    private final h k;

    public b(ByteBuf buf, String radiusServerIp, int radiusServerPort, int localPort) {
        this.c = buf;
        this.d = radiusServerIp;
        this.e = radiusServerPort;
        this.f = localPort;
        this.g = (l)com.tplink.smb.omada.common.spring.a.b(l.class);
        this.h = (f)com.tplink.smb.omada.common.spring.a.b(f.class);
        this.i = (com.tplink.smb.omada.portal.domain.model.h.f.d)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.portal.domain.model.h.f.d.class);
        this.j = (i)com.tplink.smb.omada.common.spring.a.b(i.class);
        this.k = (h)com.tplink.smb.omada.common.spring.a.b(h.class);
    }

    public static RadiusAttribute a(int attributeTypeCode, int vendorId) {
        RadiusAttribute attribute = new RadiusAttribute();
        MemoryDictionary dictionary = (MemoryDictionary)DefaultDictionary.getDefaultDictionary();
        AttributeType attributeInfo = dictionary.getAttributeTypeByCode(vendorId, attributeTypeCode);
        if (attributeInfo != null && attributeInfo.getAttributeClass() != null) {
            try {
                attribute = (RadiusAttribute)attributeInfo.getAttributeClass().newInstance();
            }
            catch (Exception e2) {
                b.warn(e2.getMessage(), (Throwable)e2);
            }
        }
        attribute.setAttributeType(attributeTypeCode);
        attribute.setVendorId(vendorId);
        return attribute;
    }

    public static Long a(int bps) {
        return bps >> 10;
    }

    public static com.tplink.smb.omada.portal.domain.model.c.i a() {
        com.tplink.smb.omada.portal.domain.model.c.i rateLimitSetting = new com.tplink.smb.omada.portal.domain.model.c.i();
        rateLimitSetting.a(Boolean.valueOf(false));
        rateLimitSetting.b(Boolean.valueOf(false));
        rateLimitSetting.a(Integer.valueOf(1));
        rateLimitSetting.a(Long.valueOf(0L));
        rateLimitSetting.c(Boolean.valueOf(false));
        rateLimitSetting.b(Integer.valueOf(1));
        rateLimitSetting.b(Long.valueOf(0L));
        return rateLimitSetting;
    }

    private static List<com.tplink.smb.omada.portal.domain.model.c.b> a(List<com.tplink.smb.omada.portal.domain.model.c.b> records, Set<String> portalIdSet) {
        return records.stream().filter(authRecordDO -> portalIdSet.contains(authRecordDO.r().b())).collect(Collectors.toList());
    }

    @Override
    public void run() {
        try {
            c results;
            if (this.g == null) {
                b.error("Failed to start disconnectRequestTask, authService is null");
                return;
            }
            if (this.h == null) {
                b.error("Failed to start disconnectRequestTask, authRecordRepository is null");
                return;
            }
            try {
                results = this.a(this.c);
            }
            catch (RadiusException e2) {
                b.debug("Radius protocol error:{}", (Object)e2.getMessage(), (Object)e2);
                return;
            }
            catch (Exception e3) {
                b.info("decode Request Packet failed {}.", (Object)this.c, (Object)e3);
                return;
            }
            if (results == null || results.b() == null || T.a((String)results.e())) {
                return;
            }
            if (results.c() == null || CollectionUtils.isEmpty(results.d())) {
                this.a(results, "Session-Context-Not-Found");
                return;
            }
            if (!com.tplink.smb.omada.portal.radius.a.a.a(results.b())) {
                this.a(results, "Unsupported-Attribute");
                return;
            }
            try {
                HashMap<r, List> omadacIdAuthRecordMap = new HashMap<r, List>();
                for (com.tplink.smb.omada.portal.domain.model.c.b authRecord : results.d()) {
                    List authRecords = omadacIdAuthRecordMap.computeIfAbsent(authRecord.o(), k2 -> new ArrayList());
                    authRecords.add(authRecord);
                }
                this.a(results);
                this.b(results);
            }
            catch (Exception e4) {
                b.debug("Fail to cancel auth by records");
                this.a(results, "Session-Context-Not-Removable");
            }
        }
        catch (Exception ex) {
            b.error("Failed to run {} : {}", new Object[]{this.getClass(), ex.getMessage(), ex});
        }
    }

    private void a(c results) {
        RadiusPacket radiusPacket = results.b();
        IntegerAttribute sessionTimeout = (IntegerAttribute)radiusPacket.getAttribute("Session-Timeout");
        IntegerAttribute maxUpBandwidth = (IntegerAttribute)radiusPacket.getAttribute("WISPr-Bandwidth-Max-Up");
        IntegerAttribute maxDownBandwidth = (IntegerAttribute)radiusPacket.getAttribute("WISPr-Bandwidth-Max-Down");
        IntegerAttribute trafficLimit = (IntegerAttribute)radiusPacket.getAttribute("TPLink-Traffic-Limit");
        for (com.tplink.smb.omada.portal.domain.model.c.b authRecord : results.d()) {
            if (sessionTimeout != null) {
                authRecord.b(Long.valueOf(System.currentTimeMillis() + (long)sessionTimeout.getAttributeValueInt() * 1000L));
            }
            if (maxUpBandwidth != null || maxDownBandwidth != null) {
                com.tplink.smb.omada.portal.domain.model.c.i rateLimit = Optional.ofNullable(authRecord.L()).map(q::m).orElseGet(b::a);
                rateLimit.a(Boolean.valueOf(true));
                if (maxUpBandwidth != null) {
                    rateLimit.b(Boolean.valueOf(true));
                    rateLimit.a(Integer.valueOf(1));
                    rateLimit.a(com.tplink.smb.omada.portal.radius.a.b.a(maxUpBandwidth.getAttributeValueInt()));
                }
                if (maxDownBandwidth != null) {
                    rateLimit.c(Boolean.valueOf(true));
                    rateLimit.b(Integer.valueOf(1));
                    rateLimit.b(com.tplink.smb.omada.portal.radius.a.b.a(maxDownBandwidth.getAttributeValueInt()));
                }
                authRecord.L().a(rateLimit);
            }
            if (trafficLimit != null) {
                Optional.ofNullable(authRecord.L()).ifPresent(c2 -> {
                    long trafficLimitDelta = (long)trafficLimit.getAttributeValueInt() * 1024L;
                    c2.i(Long.valueOf(authRecord.W() + authRecord.V() + trafficLimitDelta));
                });
            }
            if (authRecord.t() != null) {
                this.j.a(authRecord, authRecord.t(), DeviceTypeEnum.a);
                continue;
            }
            this.j.a(authRecord, authRecord.u(), DeviceTypeEnum.b);
        }
        this.h.a(results.d());
    }

    private void a(c results, String errorCause) {
        RadiusPacket nakPacket = new RadiusPacket(45);
        nakPacket.addAttribute("Error-Cause", errorCause);
        nakPacket.setPacketIdentifier(results.b().getPacketIdentifier());
        this.a(results.e(), nakPacket, results.b());
    }

    private void b(c results) {
        RadiusPacket ackPacket = new RadiusPacket(44);
        ackPacket.setPacketIdentifier(results.b().getPacketIdentifier());
        this.a(results.e(), ackPacket, results.b());
    }

    private void a(String secret, RadiusPacket responsePacket, RadiusPacket requestPacket) {
        try {
            if (com.tplink.smb.omada.portal.radius.b.d.c(this.f) == null) {
                b.debug("Channel of DisconnectRequestServer is shutdown, port:{}.", (Object)this.f);
                return;
            }
            DatagramPacket packetOut = this.a(responsePacket, this.e, this.d, secret, requestPacket);
            com.tplink.smb.omada.portal.radius.b.d.c(this.f).channel().writeAndFlush((Object)packetOut);
        }
        catch (SocketTimeoutException e2) {
            b.debug("Connect Radius timeout:{}", (Object)e2.getMessage(), (Object)e2);
        }
        catch (IOException e3) {
            b.debug("IOException occurs when connecting Radius server:{}", (Object)e3.getMessage(), (Object)e3);
        }
        catch (Exception e4) {
            b.debug("Exception occurs when connecting Radius server:{}", (Object)e4.getMessage(), (Object)e4);
        }
    }

    private DatagramPacket a(RadiusPacket packet, int port, String hostName, String sharedSecret, RadiusPacket requestPacket) throws IOException {
        InetSocketAddress remoteAddress;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        packet.encodeResponsePacket((OutputStream)bos, sharedSecret, requestPacket);
        byte[] data = bos.toByteArray();
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeBytes(data);
        InetAddress address = null;
        try {
            address = InetAddress.getByName(hostName);
            remoteAddress = new InetSocketAddress(address, port);
        }
        catch (UnknownHostException e2) {
            b.debug("UnknownHostException occurs when makeDatagramPacket:{},{},{}", new Object[]{hostName, address, port});
            throw e2;
        }
        return new DatagramPacket(byteBuf, remoteAddress);
    }

    private c a(ByteBuf byteBuf) throws RadiusException {
        int attributeLength;
        int offset;
        int attributeLength2;
        ByteBuffer content = byteBuf.nioBuffer();
        int typeCode = Byte.toUnsignedInt(content.get());
        if (!this.b(typeCode)) {
            throw new RadiusException("bad packet: type is not CoA-Request, type:" + typeCode);
        }
        int identifier = Byte.toUnsignedInt(content.get());
        short length = content.getShort();
        if (length < 20) {
            throw new RadiusException("bad packet: packet too short (" + length + " bytes)");
        }
        if (length > 4096) {
            throw new RadiusException("bad packet: packet too long (" + length + " bytes)");
        }
        byte[] authenticator = new byte[16];
        byte[] attributeData = new byte[length - 20];
        content.get(authenticator);
        if (content.remaining() != length - 20) {
            throw new RadiusException("bad packet: packet length mismatch");
        }
        content.get(attributeData);
        for (offset = 0; offset < attributeData.length; offset += attributeLength2) {
            if (offset + 1 >= attributeData.length) {
                throw new RadiusException("bad packet: attribute length mismatch");
            }
            attributeLength2 = Byte.toUnsignedInt(attributeData[offset + 1]);
            if (attributeLength2 >= 2) continue;
            throw new RadiusException("bad packet: invalid attribute length");
        }
        if (offset != attributeData.length) {
            throw new RadiusException("bad packet: attribute length mismatch");
        }
        RadiusPacket radiusPacket = new RadiusPacket();
        radiusPacket.setPacketType(typeCode);
        radiusPacket.setPacketIdentifier(identifier);
        radiusPacket.setAuthenticator(authenticator);
        for (offset = 0; offset < attributeData.length; offset += attributeLength) {
            int attributeTypeCode = Byte.toUnsignedInt(attributeData[offset]);
            attributeLength = Byte.toUnsignedInt(attributeData[offset + 1]);
            RadiusAttribute attribute = com.tplink.smb.omada.portal.radius.a.b.a(attributeTypeCode, -1);
            attribute.readAttribute(attributeData, offset, attributeLength);
            radiusPacket.addAttribute(attribute);
        }
        b.debug("CoA-Request packet:{}", (Object)radiusPacket);
        c results = this.a(radiusPacket, length, attributeData);
        if (results == null || results.c() == null) {
            b.debug("Invalid CoA-Request packet:{}", (Object)radiusPacket);
        }
        return results;
    }

    private c a(RadiusPacket radiusPacket, int length, byte[] attributeData) {
        IntegerAttribute integerAttribute = (IntegerAttribute)radiusPacket.getAttribute("Service-Type");
        if (integerAttribute != null && Objects.equals(integerAttribute.getAttributeValueInt(), 8)) {
            b.debug("Contain Authorize Only Attribute");
            return null;
        }
        List<com.tplink.smb.omada.portal.domain.model.c.b> records = this.a(radiusPacket);
        if (CollectionUtils.isEmpty(records)) {
            return null;
        }
        return this.a(radiusPacket, length, attributeData, records);
    }

    private List<com.tplink.smb.omada.portal.domain.model.c.b> a(RadiusPacket radiusPacket) {
        IpAttribute ipAttribute;
        List records = null;
        StringAttribute stringAttribute = (StringAttribute)radiusPacket.getAttribute("Acct-Session-Id");
        if (stringAttribute != null && !T.a((String)stringAttribute.getAttributeValue())) {
            records = this.h.a(stringAttribute.getAttributeValue());
        }
        if (CollectionUtils.isEmpty(records) && (stringAttribute = (StringAttribute)radiusPacket.getAttribute("Calling-Station-Id")) != null && !T.a((String)stringAttribute.getAttributeValue())) {
            records = this.h.b(stringAttribute.getAttributeValue());
        }
        if (CollectionUtils.isEmpty(records) && (ipAttribute = (IpAttribute)radiusPacket.getAttribute("Framed-IP-Address")) != null && !T.a((String)ipAttribute.getAttributeValue())) {
            records = this.h.c(ipAttribute.getAttributeValue());
        }
        if (CollectionUtils.isEmpty(records) && (stringAttribute = (StringAttribute)radiusPacket.getAttribute(1)) != null && !T.a((String)stringAttribute.getAttributeValue())) {
            records = this.h.d(stringAttribute.getAttributeValue());
        }
        if (CollectionUtils.isEmpty((Collection)records)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty((Map)this.i.a(String.valueOf(this.f)))) {
            return Collections.emptyList();
        }
        return com.tplink.smb.omada.portal.radius.a.b.a(records, this.i.a(String.valueOf(this.f)).keySet());
    }

    private c a(RadiusPacket radiusPacket, int length, byte[] attributeData, List<com.tplink.smb.omada.portal.domain.model.c.b> records) {
        ArrayList<com.tplink.smb.omada.portal.domain.model.c.b> queryAuthRecords = new ArrayList<com.tplink.smb.omada.portal.domain.model.c.b>();
        com.tplink.smb.omada.portal.port.cache.radius.b queryRadiusProfile = null;
        String secret = null;
        block0: for (com.tplink.smb.omada.portal.domain.model.c.b record : records) {
            com.tplink.smb.omada.portal.port.cache.radius.b radiusProfile;
            String portalId = record.r().b();
            if (!Boolean.TRUE.equals(record.F()) || (radiusProfile = (com.tplink.smb.omada.portal.port.cache.radius.b)this.i.a(String.valueOf(this.f), portalId).orElse(null)) == null || !this.a(radiusProfile)) continue;
            boolean isQuerySuccess = false;
            for (com.tplink.smb.omada.portal.port.cache.radius.a.b radiusAuthServerImage : radiusProfile.e()) {
                if (!this.a(radiusAuthServerImage.c(), length, attributeData, radiusPacket)) continue;
                queryAuthRecords.add(record);
                queryRadiusProfile = radiusProfile;
                secret = radiusAuthServerImage.c();
                isQuerySuccess = true;
                break;
            }
            if (isQuerySuccess || CollectionUtils.isEmpty((Collection)radiusProfile.i())) continue;
            for (com.tplink.smb.omada.portal.port.cache.radius.a.a radiusAcctServerImage : radiusProfile.i()) {
                if (!this.a(radiusAcctServerImage.c(), length, attributeData, radiusPacket)) continue;
                queryAuthRecords.add(record);
                queryRadiusProfile = radiusProfile;
                secret = radiusAcctServerImage.c();
                continue block0;
            }
        }
        return new c(radiusPacket, queryRadiusProfile, queryAuthRecords, secret);
    }

    private boolean a(String sharedSecret, int packetLength, byte[] attributes, RadiusPacket radiusPacket) {
        if (T.a((String)sharedSecret)) {
            b.debug("no shared secret has been set");
            return false;
        }
        byte[] expectedAuthenticator = this.b(sharedSecret, packetLength, attributes, radiusPacket);
        byte[] receivedAuth = radiusPacket.getAuthenticator();
        for (int i2 = 0; i2 < 16; ++i2) {
            if (expectedAuthenticator[i2] == receivedAuth[i2]) continue;
            b.debug("request authenticator invalid");
            return false;
        }
        return true;
    }

    private boolean a(com.tplink.smb.omada.portal.port.cache.radius.b radiusProfile) {
        for (com.tplink.smb.omada.portal.port.cache.radius.a.b radiusAuthServer : radiusProfile.e()) {
            if (!T.a((String)radiusAuthServer.a(), (String)this.d)) continue;
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)radiusProfile.i())) {
            return false;
        }
        for (com.tplink.smb.omada.portal.port.cache.radius.a.a radiusAcctServer : radiusProfile.i()) {
            if (!T.a((String)radiusAcctServer.a(), (String)this.d)) continue;
            return true;
        }
        return false;
    }

    private byte[] b(String sharedSecret, int packetLength, byte[] attributes, RadiusPacket radiusPacket) {
        byte[] authenticator = new byte[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            authenticator[i2] = 0;
        }
        MessageDigest md5 = DigestUtils.getMd5Digest();
        md5.reset();
        md5.update((byte)radiusPacket.getPacketType());
        md5.update((byte)radiusPacket.getPacketIdentifier());
        md5.update((byte)(packetLength >> 8));
        md5.update((byte)(packetLength & 0xFF));
        md5.update(authenticator, 0, authenticator.length);
        md5.update(attributes, 0, attributes.length);
        md5.update(RadiusUtil.getUtf8Bytes((String)sharedSecret));
        return md5.digest();
    }

    private boolean b(int packetTypeCode) {
        return packetTypeCode == 43;
    }
}

