/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.support.local.grpc.common.serialize;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Empty;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.UnsafeByteOperations;
import com.tplink.smb.omada.dispatcher.common.error.DispatcherException;
import com.tplink.smb.omada.dispatcher.common.util.BytesMultiPartFile;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.ApiGrpcResponseWrapperDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.ByteArrayOutputStreamDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.FileDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.JavaEnum;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.JsonString;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.GrpcConstsService;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.response.ApiGrpcResponseWrapper;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.serialize.AnyConverter;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.serialize.AnySerializeException;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.serialize.ApiGrpcResponseWrapperDeserializer;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.serialize.ApiGrpcResponseWrapperSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.EnumUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class LocalClusterAnyConverterJsonJacksonImpl
implements AnyConverter {
    private static final Logger log = LoggerFactory.getLogger(LocalClusterAnyConverterJsonJacksonImpl.class);
    @Autowired
    private GrpcConstsService grpcConstsService;
    private static final Set<Class<? extends AbstractMessage>> SUPPORTED_MESSAGE_SET = ImmutableSet.of(StringValue.class, BoolValue.class, Int32Value.class, Int64Value.class, FloatValue.class, DoubleValue.class, (Object[])new Class[]{BytesValue.class, JavaEnum.class, FileDTO.class, ByteArrayOutputStreamDTO.class, ApiGrpcResponseWrapperDTO.class, JsonString.class});
    private final ObjectMapper objectMapper;
    private final Map<Class<?>, Function<Object, Message>> serializeMap = new HashMap();
    private final Map<Class<? extends Message>, Function<Any, Object>> deserializeMap = new HashMap<Class<? extends Message>, Function<Any, Object>>();

    public LocalClusterAnyConverterJsonJacksonImpl() {
        this.objectMapper = new ObjectMapper();
        this.initObjectMapper();
    }

    public LocalClusterAnyConverterJsonJacksonImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper.copy();
        this.initObjectMapper();
    }

    @PostConstruct
    public void init() {
        this.putSerializer(value -> StringValue.of((String)((String)value)), String.class);
        this.putSerializer(value -> DoubleValue.of((double)((Double)value)), Double.TYPE, Double.class);
        this.putSerializer(value -> FloatValue.of((float)((Float)value).floatValue()), Float.TYPE, Float.class);
        this.putSerializer(value -> Int32Value.of((int)((Byte)value).byteValue()), Byte.TYPE, Byte.class);
        this.putSerializer(value -> Int32Value.of((int)((Integer)value)), Integer.TYPE, Integer.class);
        this.putSerializer(value -> Int64Value.of((long)((Long)value)), Long.TYPE, Long.class);
        this.putSerializer(value -> BoolValue.of((boolean)((Boolean)value)), Boolean.TYPE, Boolean.class);
        this.putSerializer(value -> BytesValue.of((ByteString)ByteString.copyFrom((byte[])((byte[])value))), byte[].class);
        this.putSerializer(value -> JavaEnum.newBuilder().setDeclaringClass(((Enum)value).getDeclaringClass().getName()).setName(((Enum)value).name()).build(), Enum.class);
        this.putSerializer(value -> {
            try {
                return FileDTO.newBuilder().setFileName(((MultipartFile)value).getOriginalFilename()).setName(((MultipartFile)value).getName()).setContentType(((MultipartFile)value).getContentType()).setContent(ByteString.copyFrom((byte[])((MultipartFile)value).getBytes())).build();
            }
            catch (Exception e) {
                throw new DispatcherException((Throwable)e);
            }
        }, MultipartFile.class);
        this.putSerializer(value -> ByteArrayOutputStreamDTO.newBuilder().setBytes(UnsafeByteOperations.unsafeWrap((byte[])((ByteArrayOutputStream)value).toByteArray())).build(), ByteArrayOutputStream.class);
        this.putSerializer(ApiGrpcResponseWrapperSerializer.INSTANCE, ApiGrpcResponseWrapper.class);
        this.putDeserializer(StringValue.class, StringValue::getValue);
        this.putDeserializer(DoubleValue.class, DoubleValue::getValue);
        this.putDeserializer(FloatValue.class, FloatValue::getValue);
        this.putDeserializer(Int32Value.class, Int32Value::getValue);
        this.putDeserializer(Int64Value.class, Int64Value::getValue);
        this.putDeserializer(BoolValue.class, BoolValue::getValue);
        this.putDeserializer(BytesValue.class, val -> val.getValue().toByteArray());
        this.putDeserializer(JavaEnum.class, val -> {
            try {
                return EnumUtils.getEnum(Class.forName(val.getDeclaringClass()), (String)val.getName());
            }
            catch (ClassNotFoundException e) {
                throw new DispatcherException((Throwable)e);
            }
        });
        this.putDeserializer(FileDTO.class, val -> new BytesMultiPartFile(val.getName(), val.getFileName(), val.getContentType(), val.getContent().toByteArray()));
        this.putDeserializer(JsonString.class, val -> {
            try {
                return this.objectMapper.readValue(this.grpcConstsService.decryptAesString(val.getValue()), Object.class);
            }
            catch (JsonProcessingException e) {
                throw new AnySerializeException("Failed to deserialize json {}" + val.getValue(), e);
            }
        });
        this.putDeserializer(ByteArrayOutputStreamDTO.class, val -> {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                val.getBytes().writeTo((OutputStream)byteArrayOutputStream);
                return byteArrayOutputStream;
            }
            catch (IOException e) {
                log.error("Failed to deserialize ByteArrayOutputStreamDTO", (Throwable)e);
                throw new AnySerializeException("Failed to deserialize ByteArrayOutputStreamDTO", e);
            }
        });
        this.putDeserializer(ApiGrpcResponseWrapperDTO.class, ApiGrpcResponseWrapperDeserializer.INSTANCE);
    }

    @Override
    public Message toMessage(Object object) {
        try {
            if (object == null) {
                return Empty.getDefaultInstance();
            }
            if (object instanceof Message) {
                return (Message)object;
            }
            return Objects.requireNonNull(this.constructMsg(object));
        }
        catch (Exception e) {
            log.error("Failed to serialize object to bytes.", (Throwable)e);
            throw new AnySerializeException("Failed to serialize object to bytes.", e);
        }
    }

    @Override
    @Nullable
    public Object unpack(Any any) {
        if (any.is(Empty.class)) {
            return null;
        }
        for (Class<? extends AbstractMessage> clazz : SUPPORTED_MESSAGE_SET) {
            if (!any.is(clazz)) continue;
            return this.deserializeMap.get(clazz).apply(any);
        }
        throw new AnySerializeException("Failed to deserialize Any to object.");
    }

    private <T extends Message, R> void putDeserializer(@Nonnull Class<T> msgType, @Nonnull Function<T, R> mapper) {
        Objects.requireNonNull(mapper);
        Objects.requireNonNull(msgType);
        this.deserializeMap.put(msgType, value -> {
            try {
                if (value.is(msgType)) {
                    return mapper.apply(value.unpack(msgType));
                }
                log.error("Unpack Any to {} failed, not expected type.", (Object)msgType);
                return null;
            }
            catch (InvalidProtocolBufferException e) {
                log.error("Unpack Any to {} failed with exception.", (Object)msgType, (Object)e);
                return null;
            }
        });
    }

    private void putSerializer(Function<Object, Message> function, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.serializeMap.put(clazz, function);
        }
    }

    protected void initObjectMapper() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(JSONObject.class, (JsonSerializer)new JsonSerializer<JSONObject>(){

            public void serialize(JSONObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(value.toString());
            }
        });
        module.addSerializer(JSONArray.class, (JsonSerializer)new JsonSerializer<JSONArray>(){

            public void serialize(JSONArray value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(value.toString());
            }
        });
        module.addDeserializer(JSONObject.class, (JsonDeserializer)new JsonDeserializer<JSONObject>(){

            public JSONObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                JsonToken currentToken = p.getCurrentToken();
                if (currentToken == JsonToken.START_OBJECT) {
                    Map map = (Map)p.readValueAs(Map.class);
                    return new JSONObject(map);
                }
                return (JSONObject)ctxt.handleUnexpectedToken(JSONObject.class, p);
            }
        });
        module.addDeserializer(JSONArray.class, (JsonDeserializer)new JsonDeserializer<JSONArray>(){

            public JSONArray deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                JsonToken currentToken = p.getCurrentToken();
                if (currentToken == JsonToken.START_ARRAY) {
                    List list = (List)p.readValueAs(List.class);
                    return new JSONArray((Collection)list);
                }
                return (JSONArray)ctxt.handleUnexpectedToken(JSONArray.class, p);
            }
        });
        this.objectMapper.registerModule((Module)module);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setVisibility(this.objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        this.objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.disable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this.objectMapper.disable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        this.objectMapper.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
    }

    protected void initTypeInclusion(ObjectMapper mapObjectMapper) {
        ObjectMapper.DefaultTypeResolverBuilder mapTyper = new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL, (PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance){

            public boolean useForType(JavaType t) {
                switch (this._appliesFor) {
                    case NON_CONCRETE_AND_ARRAYS: {
                        while (t.isArrayType()) {
                            t = t.getContentType();
                        }
                    }
                    case OBJECT_AND_NON_CONCRETE: {
                        return t.getRawClass() == Object.class || !t.isConcrete();
                    }
                    case NON_FINAL: {
                        while (t.isArrayType()) {
                            t = t.getContentType();
                        }
                        if (t.getRawClass() == Long.class) {
                            return true;
                        }
                        if (t.getRawClass() == XMLGregorianCalendar.class) {
                            return false;
                        }
                        return !t.isFinal();
                    }
                }
                return t.getRawClass() == Object.class;
            }
        };
        mapTyper.init(JsonTypeInfo.Id.CLASS, null);
        mapTyper.inclusion(JsonTypeInfo.As.PROPERTY);
        mapObjectMapper.setDefaultTyping((TypeResolverBuilder)mapTyper);
    }

    private Message constructMsg(Object obj) {
        Class<?> clazz = obj.getClass();
        for (Map.Entry<Class<?>, Function<Object, Message>> entry : this.serializeMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue().apply(obj);
        }
        try {
            return JsonString.newBuilder().setValue(this.grpcConstsService.encryptAesString(this.objectMapper.writeValueAsString(obj))).build();
        }
        catch (Exception e) {
            throw new AnySerializeException("Failed to convert object to AbstractMessage, unsupported Type", e);
        }
    }
}

