/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.support.local.grpc.common.serialize;

import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.ApiGrpcResponseWrapperDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.HeaderDTO;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.response.ApiGrpcHttpServletResponse;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.response.ApiGrpcResponseWrapper;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.serialize.AnySerializeException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiGrpcResponseWrapperDeserializer
implements Function<ApiGrpcResponseWrapperDTO, ApiGrpcResponseWrapper> {
    private static final Logger log = LoggerFactory.getLogger(ApiGrpcResponseWrapperDeserializer.class);
    public static final ApiGrpcResponseWrapperDeserializer INSTANCE = new ApiGrpcResponseWrapperDeserializer();

    @Override
    public ApiGrpcResponseWrapper apply(ApiGrpcResponseWrapperDTO val) {
        ApiGrpcHttpServletResponse wrapped = new ApiGrpcHttpServletResponse();
        wrapped.setStatusCode(val.getHttpStatus());
        for (HeaderDTO header : val.getHeadersList()) {
            wrapped.getHeaders().computeIfAbsent(header.getName(), key -> new ArrayList()).add(header.getValue());
        }
        try {
            val.getOutputStream().getBytes().writeTo((OutputStream)wrapped.getOutputStream());
        }
        catch (IOException e) {
            log.error("Failed to deserialize ApiGrpcResponseWrapper, write bytes error.", (Throwable)e);
            throw new AnySerializeException("Failed to deserialize ApiGrpcResponseWrapper, write bytes error.", e);
        }
        return new ApiGrpcResponseWrapper(wrapped);
    }

    private ApiGrpcResponseWrapperDeserializer() {
    }
}

