/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.support.local.grpc.common;

import com.tplink.smb.omada.dispatcher.support.local.grpc.common.StubManagementRegister;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractStub;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StubManagement {
    private static final Logger log = LoggerFactory.getLogger(StubManagement.class);
    public static final int DEFAULT_PORT = 9098;
    public static final int DEFAULT_TIMEOUT = 5;
    private static Map<Class, Map<String, AbstractStub>> stubMap = new HashMap<Class, Map<String, AbstractStub>>(8);
    private static Map<String, ManagedChannel> channelMap = new HashMap<String, ManagedChannel>(8);
    @Autowired
    private StubManagementRegister stubManagementRegister;

    public void addAllStubForNode(String nodeId, String nodeIp) {
        log.info("add stub for node:{}", (Object)nodeId);
        ManagedChannel oldChannel = channelMap.get(nodeId);
        if (oldChannel != null) {
            oldChannel.shutdown();
        }
        ManagedChannel channelForNode = ManagedChannelBuilder.forAddress((String)nodeIp, (int)9098).usePlaintext().build();
        channelMap.put(nodeId, channelForNode);
        for (Map.Entry<Class, Function<Channel, AbstractBlockingStub>> entry : this.stubManagementRegister.getStubConstructors().entrySet()) {
            Function<Channel, AbstractBlockingStub> constructor = entry.getValue();
            AbstractStub stub = (AbstractStub)constructor.apply((Channel)channelForNode);
            stub = stub.withMaxInboundMessageSize(Integer.MAX_VALUE).withMaxOutboundMessageSize(Integer.MAX_VALUE);
            stubMap.computeIfAbsent(entry.getKey(), k -> new HashMap(8)).put(nodeId, stub);
        }
    }

    public <T extends AbstractStub> Map<String, T> getNodeStubMap(Class<T> stubClass) {
        return stubMap.getOrDefault(stubClass, Collections.emptyMap());
    }
}

