/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.support.local.grpc.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.util.JsonUtils;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.dto.ResolveOperationRequestDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.dto.ResolveOperationResponseDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.service.ResolveCallCrossInstanceForLocalServiceGrpc;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.GrpcConstsService;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalMethodResolveClient;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalRequestDTO;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.StubManagement;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OmadaClusterUniversalMethodResolveClientImpl
implements OmadaClusterUniversalMethodResolveClient {
    private static final Logger log = LoggerFactory.getLogger(OmadaClusterUniversalMethodResolveClientImpl.class);
    @Autowired
    private StubManagement stubManagement;
    @Autowired
    private GrpcConstsService grpcConstsService;
    public static final int UNIVERSAL_METHOD_DEFAULT_TIMEOUT = 35;

    public <T> OperationResponse<T> resolveSpringBeanCall(String nodeId, OmadaClusterUniversalRequestDTO<?, T> reqDTO) {
        return this.resolveSpringBeanCall(nodeId, reqDTO, 35L, TimeUnit.SECONDS);
    }

    public <T> OperationResponse<T> resolveSpringBeanCall(String nodeId, OmadaClusterUniversalRequestDTO<?, T> reqDTO, long expireDuration, TimeUnit unit) {
        ResolveOperationResponseDTO resp;
        Map<String, ResolveCallCrossInstanceForLocalServiceGrpc.ResolveCallCrossInstanceForLocalServiceBlockingStub> nodeStubMap = this.stubManagement.getNodeStubMap(ResolveCallCrossInstanceForLocalServiceGrpc.ResolveCallCrossInstanceForLocalServiceBlockingStub.class);
        if (CollectionUtils.isEmpty(nodeStubMap) || nodeStubMap.get(nodeId) == null) {
            if (CollectionUtils.isEmpty(nodeStubMap)) {
                log.warn("the nodeStubMap is null when resolveSpringBeanCall");
            }
            if (nodeStubMap.get(nodeId) == null) {
                log.warn("the nodeStub get nodeId {} is null when resolveSpringBeanCall.", (Object)nodeId);
            }
            log.warn("No grpc stub for bean call api {} on node {}.", (Object)ResolveCallCrossInstanceForLocalServiceGrpc.ResolveCallCrossInstanceForLocalServiceBlockingStub.class.getSimpleName(), (Object)nodeId);
            return new OperationResponse(OperationResponse.GENERAL_ERROR.getErrorCode(), OperationResponse.GENERAL_ERROR.getMsg());
        }
        log.debug("resolve ClusterUniversal Method req: {}, req node:{}", reqDTO, (Object)nodeId);
        ResolveCallCrossInstanceForLocalServiceGrpc.ResolveCallCrossInstanceForLocalServiceBlockingStub stub = (ResolveCallCrossInstanceForLocalServiceGrpc.ResolveCallCrossInstanceForLocalServiceBlockingStub)nodeStubMap.get(nodeId).withDeadlineAfter(expireDuration, unit);
        try {
            resp = stub.resolveSpringBeanCall(ResolveOperationRequestDTO.newBuilder().setReq(this.grpcConstsService.encryptAesString(JsonUtils.bean2Json(reqDTO))).build());
        }
        catch (StatusRuntimeException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new OperationResponse(OperationResponse.GENERAL_ERROR.getErrorCode(), OperationResponse.GENERAL_ERROR.getMsg());
        }
        String respDecrypt = this.grpcConstsService.decryptAesString(resp.getResp());
        log.debug("resolve ClusterUniversal Method resp: {}, node:{}", (Object)respDecrypt, (Object)nodeId);
        T t = this.json2bean(respDecrypt, reqDTO.getRespObjectType(), reqDTO.getRespMultiElementClasses());
        return OperationResponse.success(t);
    }

    public <T> OperationResponse<T> resolveStaticCall(String nodeId, OmadaClusterUniversalRequestDTO<?, T> reqDTO) {
        ResolveOperationResponseDTO resp;
        Map<String, ResolveCallCrossInstanceForLocalServiceGrpc.ResolveCallCrossInstanceForLocalServiceBlockingStub> nodeStubMap = this.stubManagement.getNodeStubMap(ResolveCallCrossInstanceForLocalServiceGrpc.ResolveCallCrossInstanceForLocalServiceBlockingStub.class);
        if (CollectionUtils.isEmpty(nodeStubMap) || nodeStubMap.get(nodeId) == null) {
            log.warn("No grpc stub for static api call {} on node {}.", (Object)ResolveCallCrossInstanceForLocalServiceGrpc.ResolveCallCrossInstanceForLocalServiceBlockingStub.class.getSimpleName(), (Object)nodeId);
            return new OperationResponse(OperationResponse.GENERAL_ERROR.getErrorCode(), OperationResponse.GENERAL_ERROR.getMsg());
        }
        log.debug("resolve ClusterUniversal Method req: {}, req node:{}", reqDTO, (Object)nodeId);
        ResolveCallCrossInstanceForLocalServiceGrpc.ResolveCallCrossInstanceForLocalServiceBlockingStub stub = (ResolveCallCrossInstanceForLocalServiceGrpc.ResolveCallCrossInstanceForLocalServiceBlockingStub)nodeStubMap.get(nodeId).withDeadlineAfter(35L, TimeUnit.SECONDS);
        try {
            resp = stub.resolveStaticCall(ResolveOperationRequestDTO.newBuilder().setReq(this.grpcConstsService.encryptAesString(JsonUtils.bean2Json(reqDTO))).build());
        }
        catch (StatusRuntimeException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new OperationResponse(OperationResponse.GENERAL_ERROR.getErrorCode(), OperationResponse.GENERAL_ERROR.getMsg());
        }
        String respDecrypt = this.grpcConstsService.decryptAesString(resp.getResp());
        log.debug("resolve ClusterUniversal Method resp: {}, node:{}", (Object)respDecrypt, (Object)nodeId);
        T t = this.json2bean(respDecrypt, reqDTO.getRespObjectType(), reqDTO.getRespMultiElementClasses());
        return OperationResponse.success(t);
    }

    private <T> T json2bean(String respJson, TypeReference<T> respObjectType, Boolean respMultiElementClasses) {
        try {
            if (!respMultiElementClasses.booleanValue()) {
                return (T)JsonUtils.json2bean((String)respJson, respObjectType);
            }
            List jsonObjectList = JsonUtils.json2list((String)respJson, JSONObject.class);
            ArrayList objList = new ArrayList(jsonObjectList.size());
            jsonObjectList.forEach(jsonObject -> {
                String className = jsonObject.getString("_class");
                try {
                    Class<?> clazz = Class.forName(className);
                    Object obj = JsonUtils.json2bean((String)jsonObject.toString(), clazz);
                    objList.add(obj);
                }
                catch (ClassNotFoundException e) {
                    log.error(e.getMessage());
                }
            });
            return (T)objList;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

