/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.domain.model.user;

import com.tplink.smb.omada.common.e.l;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ResetPasswordRequestDTO;
import java.util.Calendar;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepClass
public class ResetPasswordVerifyInfo
implements l<ResetPasswordVerifyInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResetPasswordVerifyInfo.class);
    private String verifyCode;
    private Date verifyOutDate;

    public boolean validate(ResetPasswordRequestDTO resetPasswordRequest) {
        if (T.a((String)this.verifyCode) || this.verifyOutDate == null) {
            log.warn("omadacId={},tenantId={} verifyCode or verifyOutDate is null.", (Object)resetPasswordRequest.getOmadacId(), (Object)resetPasswordRequest.getUserId());
            return false;
        }
        Date currentTime = Calendar.getInstance().getTime();
        if (currentTime.after(this.verifyOutDate)) {
            log.warn("omadacId={},userId={} verifyOutDate is overdue.", (Object)resetPasswordRequest.getOmadacId(), (Object)resetPasswordRequest.getUserId());
            return false;
        }
        if (!this.verifyCode.equals(resetPasswordRequest.getVerifyCode())) {
            log.warn("omadacId={},userId={} verifyCode is mismatch.", (Object)resetPasswordRequest.getOmadacId(), (Object)resetPasswordRequest.getUserId());
            return false;
        }
        return true;
    }

    public void resetVerifyInfo() {
        this.verifyCode = "";
        this.verifyOutDate = Calendar.getInstance().getTime();
    }

    public boolean sameValueAs(ResetPasswordVerifyInfo other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @Generated
    public String getVerifyCode() {
        return this.verifyCode;
    }

    @Generated
    public Date getVerifyOutDate() {
        return this.verifyOutDate;
    }

    @Generated
    public void setVerifyCode(String verifyCode) {
        this.verifyCode = verifyCode;
    }

    @Generated
    public void setVerifyOutDate(Date verifyOutDate) {
        this.verifyOutDate = verifyOutDate;
    }

    @Generated
    public ResetPasswordVerifyInfo(String verifyCode, Date verifyOutDate) {
        this.verifyCode = verifyCode;
        this.verifyOutDate = verifyOutDate;
    }

    @Generated
    public ResetPasswordVerifyInfo() {
    }
}

