/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.global.port.mongo.configuration.webhook;

import com.mongodb.bulk.BulkWriteResult;
import com.tplink.smb.omada.common.mongo.repository.k;
import com.tplink.smb.omada.common.mongo.repository.s;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.global.configuration.domain.model.webhook.dto.WebhookRetryRequestDTO;
import com.tplink.smb.omada.global.configuration.domain.model.webhook.retry.WebhookRetryMessageDTO;
import com.tplink.smb.omada.global.configuration.domain.model.webhook.retry.c;
import com.tplink.smb.omada.global.port.mongo.configuration.webhook.WebhookRetryMessagePO;
import com.tplink.smb.omada.global.port.mongo.configuration.webhook.l;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class m
extends s<WebhookRetryMessagePO>
implements c {
    private static final Logger a = LoggerFactory.getLogger(m.class);
    @Autowired
    private MongoTemplate mongoTemplate;

    public void a(List<WebhookRetryMessageDTO> retryMessages) {
        Map<String, List<WebhookRetryMessagePO>> collectionNameToPOsMap = retryMessages.stream().map(l::a).collect(Collectors.groupingBy(WebhookRetryMessagePO::getCentralId));
        collectionNameToPOsMap.forEach((omadacId, poList) -> {
            String collectionName = this.getCollectionNameForSave((WebhookRetryMessagePO)poList.get(0));
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
            poList.forEach(retryMessagePO -> bulkOperations.insert(retryMessagePO));
            BulkWriteResult result = bulkOperations.execute();
            a.debug("Bulk write webhook retry message result: {}", (Object)result);
        });
    }

    public List<WebhookRetryMessageDTO> a(@Nonnull WebhookRetryRequestDTO retryRequestDTO) {
        ArrayList<WebhookRetryMessageDTO> webhookRetryMessages = new ArrayList<WebhookRetryMessageDTO>();
        this.iteratorCollectionsByTimeDesc(retryRequestDTO.getExecuteTime() / 1000L, retryRequestDTO.getExecuteTime() / 1000L, collectionName -> webhookRetryMessages.addAll(this.mongoTemplate.find(this.c(retryRequestDTO), WebhookRetryMessagePO.class, collectionName).stream().map(l::a).collect(Collectors.toList())));
        return webhookRetryMessages;
    }

    public void b(WebhookRetryRequestDTO retryRequestDTO) {
        this.iteratorCollectionsByTimeDesc(retryRequestDTO.getExecuteTime() / 1000L, retryRequestDTO.getExecuteTime() / 1000L, collectionName -> this.mongoTemplate.remove(this.c(retryRequestDTO), WebhookRetryMessagePO.class, collectionName));
    }

    public void a(WebhookRetryRequestDTO retryRequestDTO, Long executeTime) {
        Query query = this.c(retryRequestDTO);
        this.iteratorCollectionsByTimeDesc(retryRequestDTO.getExecuteTime() / 1000L, retryRequestDTO.getExecuteTime() / 1000L, collectionName -> this.mongoTemplate.upsert(query, (UpdateDefinition)Update.update((String)"execute_time", (Object)executeTime), WebhookRetryMessagePO.class, collectionName));
    }

    protected u<WebhookRetryMessagePO> getStrategy() {
        return k.b();
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return WebhookRetryMessagePO.INDEX_DEFINITIONS;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "webhookretrymessage";
    }

    protected Class<WebhookRetryMessagePO> getPOClass() {
        return WebhookRetryMessagePO.class;
    }

    private Query c(WebhookRetryRequestDTO retryRequestDTO) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"central_id").is((Object)retryRequestDTO.getCentralId());
        criteria.and("site_id").is((Object)retryRequestDTO.getSiteId());
        criteria.and("webhook_id").is((Object)retryRequestDTO.getWebhookId());
        criteria.and("url").is((Object)retryRequestDTO.getUrl());
        criteria.and("execute_time").is((Object)retryRequestDTO.getExecuteTime());
        query.addCriteria((CriteriaDefinition)criteria);
        return query;
    }
}

