/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.application.c;

import cn.hutool.core.util.RandomUtil;
import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.DeviceHolder;
import com.tplink.smb.device.firmware.upgrade.common.rxjava.RetryWithDelay;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.common.TransResult;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageBody;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseConfigResponse;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.log.component.client.api.LogApiService;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.e;
import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.common.util.o;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.olt.DeviceRequestBody;
import com.tplink.smb.omada.device.manage.message.body.olt.DeviceResponseBody;
import com.tplink.smb.omada.device.manage.message.body.olt.v2.DeviceRebootResponse;
import com.tplink.smb.omada.dispatcher.common.util.SessionUtils;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetCurrentInfoDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.manager.c.b.Q;
import com.tplink.smb.omada.manager.c.b.R;
import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.c.b.y;
import com.tplink.smb.omada.manager.c.s;
import com.tplink.smb.omada.manager.common.config.d;
import com.tplink.smb.omada.manager.device.api.internal.dto.olt.DeviceNotifyLogDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.olt.OLTNotifyRequestBodyDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.olt.OLTNotifyRequestDTO;
import com.tplink.smb.omada.manager.device.application.c.b;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.device.olt.dto.reboot.RebootControlDTO;
import com.tplink.smb.omada.manager.device.domain.model.k.a.a;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.f;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import com.tplink.smb.omada.manager.device.olt.reboot.BatchDeviceRebootDTO;
import com.tplink.smb.omada.manager.device.olt.reboot.BatchDeviceRebootStatusDTO;
import com.tplink.smb.omada.manager.device.olt.reboot.DeviceRebootDTO;
import com.tplink.smb.omada.manager.device.olt.reboot.DeviceRebootNotifyContentDTO;
import com.tplink.smb.omada.manager.device.olt.reboot.DeviceRebootStatusDTO;
import com.tplink.smb.omada.manager.device.olt.system.boardcontrol.BoardDetailInfo;
import com.tplink.smb.omada.manager.device.olt.system.boardcontrol.BoardInfoDTO;
import com.tplink.smb.omada.manager.device.olt.system.boardcontrol.BoardsInfoRequestDTO;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class c
extends d
implements DomainEventSubscriber<b> {
    @Generated
    private static final Logger e = LoggerFactory.getLogger(c.class);
    private static final String f = "system-tools/reboot/ack";
    @Autowired
    private com.tplink.smb.omada.manager.device.port.transport.e.d g;
    @Autowired
    private f h;
    @Autowired
    private a i;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.deviceimage.a.d j;
    @Autowired
    private LogApiService k;
    @Autowired
    private g l;
    private static final Integer m = 5000;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.web.olt.j.a.a n;
    @Autowired
    private com.tplink.smb.omada.manager.common.d.b o;
    private static final String p = "monitor_olt_reboot";
    private static final String q = "monitor_olt_reboot_handler";
    @Autowired
    private ScheduleCenter r;

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().register(b.class, (DomainEventSubscriber)this);
        this.g.e().retryWhen((Function)new RetryWithDelay()).observeOn(this.d).subscribe(this::a);
    }

    private void a(OLTNotifyRequestDTO notifyRequestDTO) {
        boolean needReply;
        String deviceKey = notifyRequestDTO.getDeviceMac();
        String omadacId = notifyRequestDTO.getDest();
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceKey, (String)omadacId);
        Map messageBody = notifyRequestDTO.getNotifyBody();
        OLTNotifyRequestBodyDTO bodyDTO = (OLTNotifyRequestBodyDTO)JacksonUtils.map2Bean((Map)messageBody, OLTNotifyRequestBodyDTO.class);
        String contentStr = JacksonUtils.pojo2Json((Object)bodyDTO.getContent());
        DeviceRebootNotifyContentDTO deviceRebootNotifyContentDTO = (DeviceRebootNotifyContentDTO)JacksonUtils.json2Pojo((String)contentStr, DeviceRebootNotifyContentDTO.class);
        int estimateRebootTime = deviceRebootNotifyContentDTO.getEstimateRebootTime();
        Boolean needReconnect = deviceRebootNotifyContentDTO.getNeedReconnect();
        if (needReconnect == null || needReconnect.booleanValue()) {
            this.a(deviceHolder, estimateRebootTime, R.b);
        }
        if (needReply = bodyDTO.getNeedReply().booleanValue()) {
            Integer sequenceId = notifyRequestDTO.getSequenceId();
            this.a(deviceKey, sequenceId);
        }
    }

    private void a(String deviceKey, Integer sequenceId) {
        DeviceRebootResponse notifyResponseBody = DeviceRebootResponse.builder().uri(f).build();
        this.b.sendV2NotifyResponse(deviceKey, "2.0.0", (MessageBody)notifyResponseBody, sequenceId, 90000L).subscribe((transResult, throwable) -> this.a((TransResult<Integer>)transResult, (Throwable)throwable, deviceKey));
    }

    private void a(TransResult<Integer> transResult, Throwable throwable, String deviceKey) {
        if (Objects.nonNull(throwable)) {
            e.error("send notify reponse to {} error, {}", (Object)deviceKey, transResult);
            return;
        }
        if (!transResult.isOK()) {
            e.error("send notify response to {} error, {}", (Object)deviceKey, transResult);
        } else {
            e.debug("send notify response to {} success", (Object)deviceKey);
        }
    }

    public Single<OperationResponse<DeviceRebootDTO>> a(DeviceRebootDTO dto) {
        boolean issu;
        String mac = dto.getMac();
        ArrayList<DeviceHolder> deviceHolderList = new ArrayList<DeviceHolder>();
        String omadacId = dto.getOmadacId();
        e controlType = dto.getControlType();
        OperationResponse currentInfoResponse = this.l.a(new GetCurrentInfoDTO(SessionUtils.getSessionId(), controlType, omadacId));
        if (!currentInfoResponse.success()) {
            return Single.just((Object)new OperationResponse(currentInfoResponse.getErrorCode(), currentInfoResponse.getMsg(), null));
        }
        UserDTO userDTO = (UserDTO)currentInfoResponse.getResult();
        String username = userDTO.getName();
        String userRole = userDTO.getRoleId();
        boolean containMainControl = false;
        boolean containSlots = dto.getSlots() != null;
        boolean bl = issu = dto.getIssu() == ac.b;
        if (containSlots && !issu) {
            List rebootSlots = dto.getSlots();
            for (Integer slot : rebootSlots) {
                BoardsInfoRequestDTO requestDTO = new BoardsInfoRequestDTO();
                requestDTO.setSlot(slot);
                requestDTO.setOmadacId(omadacId);
                requestDTO.setDeviceKey(mac);
                OperationResponse operationResponseDTO = this.n.a(requestDTO);
                if (!operationResponseDTO.success()) {
                    return Single.just((Object)new OperationResponse(operationResponseDTO.getErrorCode(), operationResponseDTO.getMsg(), null));
                }
                String operationResponseJson = x.a((Object)operationResponseDTO.getResult());
                BoardInfoDTO infoDTO = (BoardInfoDTO)x.a((String)operationResponseJson, BoardInfoDTO.class);
                BoardDetailInfo boardDetail = infoDTO.getBoardDetail();
                if (Objects.equals(slot, com.tplink.smb.omada.common.constant.b.c) || Objects.equals(slot, com.tplink.smb.omada.common.constant.b.d) && boardDetail.getActiveStatus() == y.b) {
                    containMainControl = true;
                }
                if (!containMainControl) continue;
                break;
            }
        }
        boolean batchReboot = Boolean.FALSE;
        String rebootId = UUID.randomUUID().toString();
        DeviceHolder deviceHolder = DeviceHolder.create((String)mac, (String)omadacId);
        boolean activeStatus = containMainControl;
        OperationResponse checkStatusResponse = this.a(omadacId, mac);
        if (Objects.nonNull(checkStatusResponse)) {
            this.a(deviceHolder, Q.d);
            return Single.just((Object)new OperationResponse(checkStatusResponse.getErrorCode(), checkStatusResponse.getMsg(), null));
        }
        this.i.i(deviceHolder);
        if (!containSlots || activeStatus) {
            this.i.a(deviceHolder, username, userRole);
        }
        deviceHolderList.add(DeviceHolder.create((String)mac, (String)omadacId));
        this.a(deviceHolder, dto, activeStatus);
        this.c(omadacId, mac);
        dto.setStatus(Integer.valueOf(DeviceStatusEnum.f.n()));
        dto.setStatusCategory(Integer.valueOf(DeviceStatusEnum.f.l().b()));
        this.i.a(rebootId, deviceHolderList, username, batchReboot);
        dto.setRebootId(rebootId);
        return Single.just((Object)OperationResponse.success((Object)dto));
    }

    private void c(String omadacId, String mac) {
        ScheduleTask reboot5SecondTask = ScheduleTask.builder().withIdentity(p, omadacId + ":" + mac).withFixedRateTrigger(m, Integer.valueOf(new Random().nextInt(m))).forHandler(q).build();
        this.r.saveTask(reboot5SecondTask);
    }

    private void a(DeviceHolder deviceHolder, DeviceRebootDTO dto, boolean activeStatus) {
        RebootControlDTO rebootControlDTO = new RebootControlDTO();
        rebootControlDTO.setSaveCurrentConfig(dto.getSaveCurrentConfig());
        rebootControlDTO.setIssu(dto.getIssu());
        rebootControlDTO.setSlots(dto.getSlots());
        if (dto.getSlots() == null || activeStatus) {
            this.b.sendSetRequest(deviceHolder.getDeviceMac(), "2.0.0", (MessageBody)DeviceRequestBody.builder().uri("system-tools/reboot/now").params((Object)rebootControlDTO).build(), Integer.valueOf(RandomUtil.randomInt((int)1, (int)0x7FFFFFFE)), 90000L).subscribeOn(this.d).subscribe((transResult, throwable) -> this.a((TransResult<EcspMessage>)transResult, deviceHolder, (Throwable)throwable));
        } else {
            this.b.sendSetRequest(deviceHolder.getDeviceMac(), "2.0.0", (MessageBody)DeviceRequestBody.builder().uri("system-tools/reboot/now").params((Object)rebootControlDTO).build(), Integer.valueOf(RandomUtil.randomInt((int)1, (int)0x7FFFFFFE)), 90000L);
        }
    }

    private void d(DeviceHolder deviceHolder) {
        this.a(deviceHolder, Q.c);
    }

    public void a(String mac) {
        DeviceHolder deviceHolder = DeviceHolder.toBean((String)mac);
        R rebootType = this.i(deviceHolder);
        if (R.e.equals((Object)rebootType)) {
            this.a(deviceHolder, Q.c);
            String deviceKey = deviceHolder.getDeviceMac();
            String omadacId = deviceHolder.getSysId();
            this.j.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new G(deviceKey));
        } else {
            this.a(deviceHolder, Q.d);
            this.e(deviceHolder);
        }
    }

    private void a(DeviceHolder deviceHolder, Q status) {
        boolean rebootFinished;
        this.i.a(deviceHolder, status);
        boolean bl = rebootFinished = Q.c.equals((Object)status) || Q.d.equals((Object)status);
        if (R.a.equals((Object)this.i(deviceHolder)) && rebootFinished) {
            this.b(deviceHolder, status);
        }
    }

    private void b(DeviceHolder deviceHolder, Q status) {
        s logKey;
        switch (status) {
            case c: {
                logKey = s.d;
                break;
            }
            case d: {
                logKey = s.e;
                break;
            }
            default: {
                return;
            }
        }
        String username = com.tplink.smb.omada.common.util.o.a((String)this.i.c(deviceHolder));
        String userRole = this.i.d(deviceHolder);
        String deviceType = this.a(deviceHolder);
        String siteId = this.b(deviceHolder);
        this.k.addLog(DeviceNotifyLogDTO.build((String)deviceHolder.getSysId(), (String)siteId, (s)logKey, (Long)System.currentTimeMillis(), (String[])new String[]{userRole, username, deviceType, deviceHolder.getDeviceMac()}).toJson());
    }

    public String a(DeviceHolder deviceHolder) {
        com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage;
        G deviceMac;
        String deviceType = DeviceType.OLT.getType();
        String deviceKey = deviceHolder.getDeviceMac();
        String omadacIdStr = deviceHolder.getSysId();
        com.tplink.smb.omada.manager.j.a.a.c omadacId = new com.tplink.smb.omada.manager.j.a.a.c(omadacIdStr);
        Optional deviceImageOptional = this.j.a(omadacId, deviceMac = new G(deviceKey));
        if (deviceImageOptional.isPresent() && Objects.nonNull((deviceImage = (com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImageOptional.get()).an())) {
            deviceType = deviceImage.an().b();
        }
        return deviceType;
    }

    public String b(DeviceHolder deviceHolder) {
        com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage;
        G deviceMac;
        String siteId = "";
        String deviceKey = deviceHolder.getDeviceMac();
        String omadacIdStr = deviceHolder.getSysId();
        com.tplink.smb.omada.manager.j.a.a.c omadacId = new com.tplink.smb.omada.manager.j.a.a.c(omadacIdStr);
        Optional deviceImageOptional = this.j.a(omadacId, deviceMac = new G(deviceKey));
        if (deviceImageOptional.isPresent() && Objects.nonNull((deviceImage = (com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImageOptional.get()).ap())) {
            siteId = deviceImage.ap().a();
        }
        return siteId;
    }

    private void a(TransResult<EcspMessage> transResult, DeviceHolder deviceHolder, Throwable throwable) {
        if (Objects.nonNull(throwable)) {
            e.error("error on processing message from device");
            this.a(deviceHolder, Q.d);
            return;
        }
        if (!transResult.isOK()) {
            e.error("device-transport error\uff1aerror code is [{}], error message is {}", (Object)transResult.getErrCode(), (Object)transResult.getMsg());
            this.a(deviceHolder, Q.d);
            return;
        }
        if (((EcspMessage)transResult.getResult()).getHeader().getError() != 0) {
            e.error("ECSP error: errorCode is [{}]", (Object)((EcspMessage)transResult.getResult()).getHeader().getError());
            this.a(deviceHolder, Q.d);
            return;
        }
        BaseConfigResponse responseBody = (BaseConfigResponse)((EcspMessage)transResult.getResult()).getBody();
        DeviceResponseBody deviceResponseBody = (DeviceResponseBody)JacksonUtils.map2Bean((Map)responseBody.getAdditionalProperties(), DeviceResponseBody.class);
        if (responseBody.getErrcode() != 0) {
            this.a(deviceHolder, Q.d);
            return;
        }
        String rebootStatusStr = JacksonUtils.pojo2Json((Object)deviceResponseBody.getData());
        DeviceRebootStatusDTO rebootStatusDTO = (DeviceRebootStatusDTO)JacksonUtils.json2Pojo((String)rebootStatusStr, DeviceRebootStatusDTO.class);
        int estimateTime = rebootStatusDTO.getEstimateTime();
        this.f(deviceHolder);
        this.i.a(deviceHolder, Q.b, estimateTime, R.a);
        this.i.a(deviceHolder, estimateTime);
    }

    private void e(DeviceHolder deviceHolder) {
        String deviceKey = deviceHolder.getDeviceMac();
        String omadacIdStr = deviceHolder.getSysId();
        com.tplink.smb.omada.manager.j.a.a.c omadacId = new com.tplink.smb.omada.manager.j.a.a.c(omadacIdStr);
        G deviceMac = new G(deviceKey);
        this.o.a(omadacId, deviceMac, () -> {
            this.j.a(omadacId, deviceMac).ifPresent(deviceImage -> {
                if (DeviceStatusEnum.f.equals((Object)deviceImage.at())) {
                    deviceImage.ba();
                    this.j.a(deviceImage);
                }
            });
            return true;
        }, () -> {
            e.warn("Can't get device readWriteLock when changeDeviceListStatusDisconnected:{}", (Object)deviceKey);
            return false;
        });
    }

    private void f(DeviceHolder deviceHolder) {
        String deviceKey = deviceHolder.getDeviceMac();
        String omadacIdStr = deviceHolder.getSysId();
        com.tplink.smb.omada.manager.j.a.a.c omadacId = new com.tplink.smb.omada.manager.j.a.a.c(omadacIdStr);
        G deviceMac = new G(deviceKey);
        this.o.a(omadacId, deviceMac, () -> {
            this.j.a(omadacId, deviceMac).ifPresent(deviceImage -> {
                deviceImage.aZ();
                this.j.a(deviceImage);
            });
            DpmsBaseDeviceDTO dto = new DpmsBaseDeviceDTO();
            dto.setDeviceKey(deviceHolder.getDeviceMac());
            dto.setOmadacId(deviceHolder.getSysId());
            this.h.a(dto);
            return true;
        }, () -> {
            e.warn("Can't get device readWriteLock when changeDeviceListStatusRebooting:{}", (Object)deviceKey);
            return false;
        });
    }

    public void a(b event) {
        DeviceHolder deviceHolder = event.a();
        Q rebootStatus = this.h(deviceHolder);
        if (Objects.nonNull(rebootStatus) && Q.b.equals((Object)rebootStatus)) {
            e.debug("device {} reboot success!", (Object)deviceHolder.toJson());
            this.r.deleteTask(TaskKey.of((String)p, (String)(deviceHolder.getSysId() + ":" + deviceHolder.getDeviceMac())));
            this.d(deviceHolder);
            this.i.h(deviceHolder);
            R rebootType = this.i(deviceHolder);
            if (R.d.equals((Object)rebootType)) {
                this.h.a(deviceHolder);
            }
        }
    }

    public Single<OperationResponse<DeviceRebootStatusDTO>> c(DeviceHolder deviceHolder) {
        return Single.just((Object)OperationResponse.success((Object)this.g(deviceHolder)));
    }

    public Single<OperationResponse<List<DeviceRebootStatusDTO>>> b(String rebootId) {
        List<DeviceHolder> deviceList = this.c(rebootId);
        if (deviceList.isEmpty()) {
            return Single.just((Object)new OperationResponse(com.tplink.smb.omada.common.g.b.d, "rebootId not exists", null));
        }
        ArrayList<DeviceRebootStatusDTO> statusDTOList = new ArrayList<DeviceRebootStatusDTO>();
        for (DeviceHolder deviceHolder : deviceList) {
            DeviceRebootStatusDTO statusDTO = this.g(deviceHolder);
            statusDTOList.add(statusDTO);
        }
        return Single.just((Object)OperationResponse.success(statusDTOList));
    }

    private DeviceRebootStatusDTO g(DeviceHolder deviceHolder) {
        String deviceKey = deviceHolder.getDeviceMac();
        String omadacId = deviceHolder.getSysId();
        if (this.i.c(deviceKey)) {
            omadacId = "";
            deviceHolder = DeviceHolder.create((String)deviceKey, (String)omadacId);
        }
        DeviceRebootStatusDTO statusDTO = new DeviceRebootStatusDTO();
        statusDTO.setDeviceKey(deviceKey);
        statusDTO.setOmadacId(omadacId);
        Q status = this.h(deviceHolder);
        if (Objects.isNull(status)) {
            statusDTO.setStatus(Q.e);
            return statusDTO;
        }
        statusDTO.setStatus(status);
        if (status.equals((Object)Q.b)) {
            int estimateTime = this.j(deviceHolder);
            statusDTO.setEstimateTime(Integer.valueOf(estimateTime += 25));
            int rebootTimeSeconds = (int)TimeUnit.SECONDS.convert(System.currentTimeMillis() - this.k(deviceHolder), TimeUnit.MILLISECONDS);
            statusDTO.setRebootTime(Integer.valueOf(rebootTimeSeconds));
        }
        if (status.equals((Object)Q.d) || status.equals((Object)Q.c)) {
            int rebootTimeSeconds = (int)TimeUnit.SECONDS.convert(this.l(deviceHolder) - this.k(deviceHolder), TimeUnit.MILLISECONDS);
            statusDTO.setRebootTime(Integer.valueOf(rebootTimeSeconds));
        }
        return statusDTO;
    }

    private List<DeviceHolder> c(String rebootId) {
        return this.i.a(rebootId);
    }

    private Q h(DeviceHolder deviceHolder) {
        return this.i.b(deviceHolder);
    }

    private R i(DeviceHolder deviceHolder) {
        return this.i.a(deviceHolder);
    }

    private int j(DeviceHolder deviceHolder) {
        return this.i.e(deviceHolder);
    }

    private long k(DeviceHolder deviceHolder) {
        return this.i.f(deviceHolder);
    }

    private long l(DeviceHolder deviceHolder) {
        return this.i.g(deviceHolder);
    }

    public void a(DeviceHolder deviceHolder, int estimateTime, R rebootType) {
        this.f(deviceHolder);
        this.i.i(deviceHolder);
        if (R.e.equals((Object)rebootType)) {
            String deviceKey = deviceHolder.getDeviceMac();
            this.i.b(deviceKey);
            deviceHolder = DeviceHolder.create((String)deviceKey, (String)"");
        }
        this.i.a(deviceHolder, Q.b, estimateTime, rebootType);
        this.i.a(deviceHolder, estimateTime);
    }

    public Single<OperationResponse<List<BatchDeviceRebootStatusDTO>>> a(BatchDeviceRebootDTO dto) {
        String omadacId = dto.getOmadacId();
        e controlType = dto.getControlType();
        OperationResponse currentInfoResponse = this.l.a(new GetCurrentInfoDTO(SessionUtils.getSessionId(), controlType, omadacId));
        if (!currentInfoResponse.success()) {
            return Single.just((Object)new OperationResponse(currentInfoResponse.getErrorCode(), currentInfoResponse.getMsg(), null));
        }
        UserDTO userDTO = (UserDTO)currentInfoResponse.getResult();
        String username = userDTO.getName();
        List rebootIds = this.i.d(username);
        if (rebootIds.isEmpty()) {
            return Single.just((Object)OperationResponse.ok());
        }
        ArrayList<BatchDeviceRebootStatusDTO> batchResult = new ArrayList<BatchDeviceRebootStatusDTO>();
        for (String rebootId : rebootIds) {
            List<DeviceHolder> deviceList = this.c(rebootId);
            if (deviceList.isEmpty()) continue;
            ArrayList<DeviceRebootStatusDTO> successfulList = new ArrayList<DeviceRebootStatusDTO>();
            ArrayList<DeviceRebootStatusDTO> failedList = new ArrayList<DeviceRebootStatusDTO>();
            for (DeviceHolder deviceHolder : deviceList) {
                DeviceRebootStatusDTO statusDTO = this.g(deviceHolder);
                if (Q.c.equals((Object)statusDTO.getStatus())) {
                    successfulList.add(statusDTO);
                }
                if (!Q.d.equals((Object)statusDTO.getStatus())) continue;
                failedList.add(statusDTO);
            }
            BatchDeviceRebootStatusDTO batchRebootStatusDTO = new BatchDeviceRebootStatusDTO();
            batchRebootStatusDTO.setRebootId(rebootId);
            batchRebootStatusDTO.setUsername(username);
            batchRebootStatusDTO.setSuccessfulList(successfulList);
            batchRebootStatusDTO.setFailedList(failedList);
            batchResult.add(batchRebootStatusDTO);
        }
        return Single.just((Object)OperationResponse.success(batchResult));
    }

    public Single<OperationResponse<Void>> a(DpmsBaseDeviceDTO dto) {
        boolean isRebootFinished;
        String omadacId;
        String deviceKey = dto.getDeviceKey();
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceKey, (String)(omadacId = dto.getOmadacId()));
        Q statusType = this.h(deviceHolder);
        if (Objects.isNull(statusType)) {
            return Single.just((Object)OperationResponse.ok());
        }
        boolean bl = isRebootFinished = Q.c.equals((Object)statusType) || Q.d.equals((Object)statusType);
        if (!isRebootFinished) {
            return Single.just((Object)new OperationResponse(com.tplink.smb.omada.common.g.b.b));
        }
        this.i.i(DeviceHolder.create((String)deviceKey, (String)omadacId));
        return Single.just((Object)OperationResponse.ok());
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((b)object);
    }
}

