/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol.packet.message.outbound;

import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import com.tplink.smb.rtty.protocol.packet.message.outbound.RttyOutboundMessage;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterOutboundMessage
extends RttyOutboundMessage {
    private static final Logger log = LoggerFactory.getLogger(RegisterOutboundMessage.class);
    private int err;
    private String msg;

    public RegisterOutboundMessage(int err, String msg) {
        this.type = RttyMessageType.REGISTER.getValue();
        this.err = err;
        this.msg = msg;
    }

    @Override
    public RttyPacket toRttyPacket() {
        ByteBuffer data = ByteBuffer.allocate(1 + this.msg.getBytes().length);
        data.put((byte)this.err);
        data.put(this.msg.getBytes(StandardCharsets.UTF_8));
        RttyPacket rttyPacket = RttyPacket.builder().typeField((byte)this.type).lengthField((short)data.capacity()).payload(data).build();
        log.debug("pack rtty register message to rtty packet, rtty packet:{}", (Object)rttyPacket);
        return rttyPacket;
    }

    public RegisterOutboundMessage() {
    }

    public int getErr() {
        return this.err;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setErr(int err) {
        this.err = err;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return "RegisterOutboundMessage(err=" + this.getErr() + ", msg=" + this.getMsg() + ")";
    }
}

