/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol.packet.message.outbound;

import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import com.tplink.smb.rtty.protocol.packet.message.outbound.RttyOutboundMessage;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginOutboundMessage
extends RttyOutboundMessage {
    private static final Logger log = LoggerFactory.getLogger(LoginOutboundMessage.class);
    private String sid;

    public LoginOutboundMessage(String sid) {
        this.type = RttyMessageType.LOGIN.getValue();
        this.sid = sid;
    }

    @Override
    public RttyPacket toRttyPacket() {
        ByteBuffer data = ByteBuffer.wrap(this.sid.getBytes(StandardCharsets.UTF_8));
        RttyPacket rttyPacket = RttyPacket.builder().typeField((byte)this.type).lengthField((short)data.capacity()).payload(data).build();
        log.debug("pack rtty login message to rtty packet, rtty packet:{}", (Object)rttyPacket);
        return rttyPacket;
    }

    public LoginOutboundMessage() {
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String toString() {
        return "LoginOutboundMessage(sid=" + this.getSid() + ")";
    }
}

