/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol.packet.message.outbound;

import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import com.tplink.smb.rtty.protocol.packet.message.outbound.RttyOutboundMessage;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckOutboundMessage
extends RttyOutboundMessage {
    private static final Logger log = LoggerFactory.getLogger(AckOutboundMessage.class);
    private String sid;
    private short ack;

    public AckOutboundMessage(String sid, short ack) {
        this.type = RttyMessageType.ACK.getValue();
        this.sid = sid;
        this.ack = ack;
    }

    @Override
    public RttyPacket toRttyPacket() {
        ByteBuffer data = ByteBuffer.allocate(34);
        data.put(this.sid.getBytes(StandardCharsets.UTF_8));
        data.putShort(this.ack);
        RttyPacket rttyPacket = RttyPacket.builder().typeField((byte)this.type).lengthField((short)data.capacity()).payload(data).build();
        log.debug("pack rtty ack message to rtty packet, rtty packet:{}", (Object)rttyPacket);
        return rttyPacket;
    }

    public AckOutboundMessage() {
    }

    public String getSid() {
        return this.sid;
    }

    public short getAck() {
        return this.ack;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public void setAck(short ack) {
        this.ack = ack;
    }

    public String toString() {
        return "AckOutboundMessage(sid=" + this.getSid() + ", ack=" + this.getAck() + ")";
    }
}

