/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol.packet.message.inbound;

import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import com.tplink.smb.rtty.protocol.packet.message.inbound.RttyInboundMessage;
import com.tplink.smb.rtty.protocol.utils.ByteUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterInboundMessage
extends RttyInboundMessage {
    private static final Logger log = LoggerFactory.getLogger(RegisterInboundMessage.class);
    private int version;
    private String devid;
    private String description;
    private String token;

    public RegisterInboundMessage(int version, String devid, String description, String token) {
        this.type = RttyMessageType.REGISTER.getValue();
        this.version = version;
        this.devid = devid;
        this.description = description;
        this.token = token;
    }

    @Override
    public RegisterInboundMessage buildFromRttyPacket(RttyPacket rttyPacket) {
        this.setType(rttyPacket.getTypeField());
        ByteBuffer payload = rttyPacket.getPayload();
        byte rttyVersion = payload.get();
        byte[] array = new byte[payload.remaining()];
        payload.get(array);
        this.setVersion(rttyVersion);
        List<byte[]> bytes = ByteUtils.split(array, new byte[]{0});
        if (bytes.size() != 4) {
            log.warn("Register inbound data length parse failed, rtty packet: {}", (Object)rttyPacket);
            return null;
        }
        this.setDevid(new String(bytes.get(0), StandardCharsets.UTF_8));
        this.setDescription(new String(bytes.get(1), StandardCharsets.UTF_8));
        this.setToken(new String(bytes.get(2), StandardCharsets.UTF_8));
        log.debug("parse registerDataPackage: {}", (Object)this);
        return this;
    }

    public RegisterInboundMessage() {
    }

    public int getVersion() {
        return this.version;
    }

    public String getDevid() {
        return this.devid;
    }

    public String getDescription() {
        return this.description;
    }

    public String getToken() {
        return this.token;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setDevid(String devid) {
        this.devid = devid;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String toString() {
        return "RegisterInboundMessage(version=" + this.getVersion() + ", devid=" + this.getDevid() + ", description=" + this.getDescription() + ", token=" + this.getToken() + ")";
    }
}

