/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol.packet.message.inbound;

import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import com.tplink.smb.rtty.protocol.packet.message.inbound.RttyInboundMessage;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginInboundMessage
extends RttyInboundMessage {
    private static final Logger log = LoggerFactory.getLogger(LoginInboundMessage.class);
    private String sid;
    private int code;

    public LoginInboundMessage(String sid, int code) {
        this.type = RttyMessageType.LOGIN.getValue();
        this.sid = sid;
        this.code = code;
    }

    @Override
    public LoginInboundMessage buildFromRttyPacket(RttyPacket rttyPacket) {
        this.setType(rttyPacket.getTypeField());
        ByteBuffer payload = rttyPacket.getPayload();
        byte[] array = new byte[payload.remaining()];
        payload.get(array);
        this.setSid(new String(array, 0, 32, StandardCharsets.UTF_8));
        this.setCode(array[32]);
        log.debug("parse loginDataPackage, sid: {}, code: {}", (Object)this.getSid(), (Object)this.getCode());
        return this;
    }

    public LoginInboundMessage() {
    }

    public String getSid() {
        return this.sid;
    }

    public int getCode() {
        return this.code;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String toString() {
        return "LoginInboundMessage(sid=" + this.getSid() + ", code=" + this.getCode() + ")";
    }
}

