/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol.packet.message.inbound;

import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import com.tplink.smb.rtty.protocol.packet.message.inbound.RttyInboundMessage;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatInboundMessage
extends RttyInboundMessage {
    private static final Logger log = LoggerFactory.getLogger(HeartBeatInboundMessage.class);
    private int uptime;

    public HeartBeatInboundMessage(int uptime) {
        this.type = RttyMessageType.HEARTBEAT.getValue();
        this.uptime = uptime;
    }

    @Override
    public HeartBeatInboundMessage buildFromRttyPacket(RttyPacket rttyPacket) {
        this.setType(rttyPacket.getTypeField());
        ByteBuffer payload = rttyPacket.getPayload();
        this.setUptime(payload.getInt());
        return this;
    }

    public HeartBeatInboundMessage() {
    }

    public int getUptime() {
        return this.uptime;
    }

    public void setUptime(int uptime) {
        this.uptime = uptime;
    }

    public String toString() {
        return "HeartBeatInboundMessage(uptime=" + this.getUptime() + ")";
    }
}

