/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol.packet.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.rtty.protocol.packet.RttyMessage;
import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermDataMessage
extends RttyMessage {
    private static final Logger log = LoggerFactory.getLogger(TermDataMessage.class);
    private String sid;
    private String data;
    private int orderId;
    @JsonIgnore
    private int unAck;

    public TermDataMessage(String sid, String data) {
        this.type = RttyMessageType.TERMDATA.getValue();
        this.sid = sid;
        this.data = data;
    }

    @Override
    public RttyPacket toRttyPacket() {
        ByteBuffer payload = ByteBuffer.allocate(32 + this.data.getBytes(StandardCharsets.UTF_8).length);
        payload.put(this.sid.getBytes(StandardCharsets.UTF_8));
        payload.put(this.data.getBytes(StandardCharsets.UTF_8));
        RttyPacket rttyPacket = RttyPacket.builder().typeField((byte)this.type).lengthField((short)payload.capacity()).payload(payload).build();
        log.debug("pack rtty termData message to rtty packet, rtty packet:{}", (Object)rttyPacket);
        return rttyPacket;
    }

    @Override
    public TermDataMessage buildFromRttyPacket(RttyPacket rttyPacket) {
        this.setType(rttyPacket.getTypeField());
        ByteBuffer payload = rttyPacket.getPayload();
        byte[] array = new byte[payload.remaining()];
        payload.get(array);
        this.setSid(new String(array, 0, 32, StandardCharsets.UTF_8));
        int dataLen = payload.capacity() - 32;
        this.setData(new String(array, 32, dataLen));
        this.setUnAck(dataLen);
        log.debug("parse termdata, termData: {}", (Object)this);
        return this;
    }

    public String toString() {
        return "TermData{sid='" + this.sid + "', data=" + this.data + "}";
    }

    public TermDataMessage() {
    }

    public String getSid() {
        return this.sid;
    }

    public String getData() {
        return this.data;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public int getUnAck() {
        return this.unAck;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }

    @JsonIgnore
    public void setUnAck(int unAck) {
        this.unAck = unAck;
    }
}

