/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol.packet.message;

import com.tplink.smb.rtty.protocol.packet.RttyMessage;
import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutMessage
extends RttyMessage {
    private static final Logger log = LoggerFactory.getLogger(LogoutMessage.class);
    private String sid;

    public LogoutMessage(String sid) {
        this.type = RttyMessageType.LOGOUT.getValue();
        this.sid = sid;
    }

    @Override
    public RttyPacket toRttyPacket() {
        ByteBuffer data = ByteBuffer.wrap(this.sid.getBytes(StandardCharsets.UTF_8));
        RttyPacket rttyPacket = RttyPacket.builder().typeField((byte)this.type).lengthField((short)data.capacity()).payload(data).build();
        log.debug("pack rtty logout message to rtty packet, rtty packet:{}", (Object)rttyPacket);
        return rttyPacket;
    }

    @Override
    public LogoutMessage buildFromRttyPacket(RttyPacket rttyPacket) {
        this.setType(rttyPacket.getTypeField());
        ByteBuffer payload = rttyPacket.getPayload();
        byte[] array = new byte[payload.remaining()];
        payload.get(array);
        this.setSid(new String(array, StandardCharsets.UTF_8));
        log.debug("parse logoutDataPackage, sid: {}", (Object)this.getSid());
        return this;
    }

    public LogoutMessage() {
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String toString() {
        return "LogoutMessage(sid=" + this.getSid() + ")";
    }
}

