/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol.packet;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RttyPacket {
    private static final Logger log = LoggerFactory.getLogger(RttyPacket.class);
    private final byte typeField;
    private final short lengthField;
    private final ByteBuffer payload;

    public ByteBuffer pack() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(3 + this.lengthField);
        byteBuffer.put(this.typeField);
        byteBuffer.putShort(this.lengthField);
        this.payload.rewind();
        byteBuffer.put(this.payload);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public String toString() {
        return "RttyPacket{typeField=" + this.typeField + ", lengthField=" + this.lengthField + ", payload=\n" + new String(this.payload.array()) + "}";
    }

    RttyPacket(byte typeField, short lengthField, ByteBuffer payload) {
        this.typeField = typeField;
        this.lengthField = lengthField;
        this.payload = payload;
    }

    public static RttyPacketBuilder builder() {
        return new RttyPacketBuilder();
    }

    public byte getTypeField() {
        return this.typeField;
    }

    public short getLengthField() {
        return this.lengthField;
    }

    public ByteBuffer getPayload() {
        return this.payload;
    }

    public static class RttyPacketBuilder {
        private byte typeField;
        private short lengthField;
        private ByteBuffer payload;

        RttyPacketBuilder() {
        }

        public RttyPacketBuilder typeField(byte typeField) {
            this.typeField = typeField;
            return this;
        }

        public RttyPacketBuilder lengthField(short lengthField) {
            this.lengthField = lengthField;
            return this;
        }

        public RttyPacketBuilder payload(ByteBuffer payload) {
            this.payload = payload;
            return this;
        }

        public RttyPacket build() {
            return new RttyPacket(this.typeField, this.lengthField, this.payload);
        }

        public String toString() {
            return "RttyPacket.RttyPacketBuilder(typeField=" + this.typeField + ", lengthField=" + this.lengthField + ", payload=" + this.payload + ")";
        }
    }
}

