/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol.packet;

import com.tplink.smb.rtty.protocol.packet.RttyMessage;
import com.tplink.smb.rtty.protocol.packet.message.LogoutMessage;
import com.tplink.smb.rtty.protocol.packet.message.TermDataMessage;
import com.tplink.smb.rtty.protocol.packet.message.inbound.HeartBeatInboundMessage;
import com.tplink.smb.rtty.protocol.packet.message.inbound.LoginInboundMessage;
import com.tplink.smb.rtty.protocol.packet.message.inbound.RegisterInboundMessage;
import com.tplink.smb.rtty.protocol.packet.message.outbound.AckOutboundMessage;
import com.tplink.smb.rtty.protocol.packet.message.outbound.CmdOutboundPackage;
import com.tplink.smb.rtty.protocol.packet.message.outbound.WinSizeOutboundMessage;
import java.util.HashMap;
import java.util.Map;

public enum RttyMessageType {
    REGISTER(0, "register", RegisterInboundMessage.class),
    LOGIN(1, "login", LoginInboundMessage.class),
    LOGOUT(2, "logout", LogoutMessage.class),
    TERMDATA(3, "termdata", TermDataMessage.class),
    WINSIZE(4, "winsize", WinSizeOutboundMessage.class),
    CMD(5, "cmd", CmdOutboundPackage.class),
    HEARTBEAT(6, "heartbeat", HeartBeatInboundMessage.class),
    ACK(9, "ack", AckOutboundMessage.class);

    private final int value;
    private final String type;
    private final Class<? extends RttyMessage> messageClass;
    private static final Map<Integer, RttyMessageType> TYPE_MAP;

    public static RttyMessageType fromInteger(int value) {
        return TYPE_MAP.get(value);
    }

    private RttyMessageType(int value, String type, Class<? extends RttyMessage> messageClass) {
        this.value = value;
        this.type = type;
        this.messageClass = messageClass;
    }

    public int getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public Class<? extends RttyMessage> getMessageClass() {
        return this.messageClass;
    }

    static {
        TYPE_MAP = new HashMap<Integer, RttyMessageType>(8);
        for (RttyMessageType type : RttyMessageType.values()) {
            TYPE_MAP.put(type.getValue(), type);
        }
    }
}

