/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol.packet;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import com.tplink.smb.rtty.protocol.packet.message.LogoutMessage;
import com.tplink.smb.rtty.protocol.packet.message.TermDataMessage;
import com.tplink.smb.rtty.protocol.packet.message.inbound.HeartBeatInboundMessage;
import com.tplink.smb.rtty.protocol.packet.message.inbound.LoginInboundMessage;
import com.tplink.smb.rtty.protocol.packet.message.inbound.RegisterInboundMessage;
import com.tplink.smb.rtty.protocol.packet.message.outbound.HeartBeatOutboundMessage;
import com.tplink.smb.rtty.protocol.packet.message.outbound.LoginOutboundMessage;
import com.tplink.smb.rtty.protocol.packet.message.outbound.RegisterOutboundMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT, property="className")
@JsonSubTypes(value={@JsonSubTypes.Type(value=RegisterInboundMessage.class, name="RegisterInboundMessage"), @JsonSubTypes.Type(value=RegisterOutboundMessage.class, name="RegisterOutboundMessage"), @JsonSubTypes.Type(value=LoginOutboundMessage.class, name="LoginOutboundMessage"), @JsonSubTypes.Type(value=LoginInboundMessage.class, name="LoginInboundMessage"), @JsonSubTypes.Type(value=TermDataMessage.class, name="TermData"), @JsonSubTypes.Type(value=LogoutMessage.class, name="LogoutData"), @JsonSubTypes.Type(value=HeartBeatInboundMessage.class, name="HeartBeatInboundMessage"), @JsonSubTypes.Type(value=HeartBeatOutboundMessage.class, name="HeartBeatOutboundMessage")})
public class RttyMessage {
    private static final Logger log = LoggerFactory.getLogger(RttyMessage.class);
    public int type;

    public RttyPacket toRttyPacket() {
        log.warn("implement by subclass.");
        return null;
    }

    public RttyMessage buildFromRttyPacket(RttyPacket rttyPacket) {
        log.debug("implement by subclass.");
        return null;
    }

    @JsonIgnore
    public boolean isValid() {
        return this.getType() >= RttyMessageType.REGISTER.getValue() && this.getType() <= RttyMessageType.ACK.getValue();
    }

    public static RttyMessage parseJson(String json) {
        return JacksonUtils.json2Pojo(json, RttyMessage.class);
    }

    public String toJson() {
        return JacksonUtils.pojo2Json(this);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

