/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.protocol;

import java.util.HashMap;
import java.util.Map;

public enum RttyDeviceStateEnum {
    DISCONNECT(0, "disconnect"),
    CONNECTED(1, "connected"),
    UNDER_AUTH(2, "under_auth"),
    IDLE(3, "IDLE");

    private final int value;
    private final String type;
    private static final Map<Integer, RttyDeviceStateEnum> TYPE_MAP;

    private RttyDeviceStateEnum(int value, String type) {
        this.value = value;
        this.type = type;
    }

    public static RttyDeviceStateEnum fromInteger(int value) {
        return TYPE_MAP.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    static {
        TYPE_MAP = new HashMap<Integer, RttyDeviceStateEnum>(8);
        for (RttyDeviceStateEnum type : RttyDeviceStateEnum.values()) {
            TYPE_MAP.put(type.getValue(), type);
        }
    }
}

