/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.protocol.packet.header;

import com.tplink.smb.ecsp.common.util.StringUtils;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EcspVersion {
    VERSION_1("1.0.0"),
    VERSION_2("2.0.0"),
    VERSION_3("3.0.0");

    private static final Logger log;
    private final String version;
    private static final int V1_NUMBER = 1;
    private static final int V2_NUMBER = 2;
    private static final int V3_NUMBER = 3;

    private EcspVersion(String version) {
        this.version = version;
    }

    public static boolean isEcspVersion1(String ecspVer) {
        return StringUtils.isEmpty(ecspVer) || EcspVersion.parseFatEcspVer(ecspVer)[0] < 2;
    }

    public static boolean isEcspVersion2(String ecspVer) {
        return !StringUtils.isEmpty(ecspVer) && EcspVersion.parseFatEcspVer(ecspVer)[0] == 2;
    }

    public static boolean isEcspVersion3(String ecspVer) {
        return !StringUtils.isEmpty(ecspVer) && EcspVersion.parseFatEcspVer(ecspVer)[0] == 3;
    }

    public static int[] parseFatEcspVer(String ecspVer) {
        String fitEcspVer = EcspVersion.fitFatEcspVer(ecspVer);
        return EcspVersion.parseFitEcspVer(fitEcspVer);
    }

    public static int[] parseFitEcspVer(String ecspVer) {
        StringTokenizer stringTokenizer = new StringTokenizer(ecspVer, ".");
        int[] result = new int[2];
        for (int idx = 0; stringTokenizer.hasMoreTokens() && idx <= 1; ++idx) {
            result[idx] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return result;
    }

    public static String fitFatEcspVer(String ecspVer) {
        if (StringUtils.isEmpty(ecspVer)) {
            return "";
        }
        int blank = ecspVer.lastIndexOf(32);
        return blank < 0 ? ecspVer : ecspVer.substring(blank + 1);
    }

    public static int getEcspVerCap(boolean ... enableVersions) {
        int ecspVerCap = 0;
        for (int index = 0; index < enableVersions.length; ++index) {
            ecspVerCap += enableVersions[index] ? 1 << index : 0;
        }
        return ecspVerCap;
    }

    public static EcspVersion getEcspVersion(int serverEcspVer, int deviceEcspVer) {
        int ecspVersion = serverEcspVer & deviceEcspVer;
        if (0 == ecspVersion) {
            return VERSION_3;
        }
        if (1 == (ecspVersion = (int)Math.floor(Math.log(ecspVersion) / Math.log(2.0) + 1.0))) {
            return VERSION_1;
        }
        if (2 == ecspVersion) {
            return VERSION_2;
        }
        return VERSION_3;
    }

    public static EcspVersion getEcspVersion(String ecspVer) {
        if (EcspVersion.isEcspVersion1(ecspVer)) {
            return VERSION_1;
        }
        if (EcspVersion.isEcspVersion2(ecspVer)) {
            return VERSION_2;
        }
        return VERSION_3;
    }

    public String getVersion() {
        return this.version;
    }

    static {
        log = LoggerFactory.getLogger(EcspVersion.class);
    }
}

