/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.protocol.packet.body;

import com.tplink.smb.ecsp.protocol.packet.body.AbstractMessageBody;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.AdoptRequest;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.Authorization;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseAdoptResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseConfigRequest;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseConfigResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseDiscovery;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseGetRequest;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseGetResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseInformRequest;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseInitialSetSync;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseRebuildRequest;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseRebuildResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseUpgradeRequest;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseUpgradeResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.DeviceVerifyInfo;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.DeviceVerifyResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.FileTransferRequest;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.FileTransferResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.ForgetRequest;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.NotifyRequest;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.NotifyResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.NullMessage;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.PortalQuery;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.PreAdoptRequest;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.PreConnectInfo;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.PreConnectInfoResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.Report;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MessageType {
    UNKNOWN(-1, "unknown", NullMessage.class),
    DISCOVERY(1, "discovery", BaseDiscovery.class),
    PRE_ADOPT_REQUEST(2, "pre.adopt.request", PreAdoptRequest.class),
    PRE_CONNECT_INFO(3, "pre.connect.info", PreConnectInfo.class),
    ADOPT_REQUEST(16, "adopt.request", AdoptRequest.class),
    ADOPT_RESPONSE(32, "adopt.response", BaseAdoptResponse.class),
    INFORM_REQUEST(256, "inform.request", BaseInformRequest.class),
    INFORM_RESPONSE(512, "inform.response", NullMessage.class),
    SET_REQUEST(4096, "set.request", BaseConfigRequest.class),
    SET_RESPONSE(8192, "set.response", BaseConfigResponse.class),
    INIT_SYNC(4352, "init.sync", BaseInitialSetSync.class),
    FORGET_REQUEST(16384, "forget.request", ForgetRequest.class),
    FORGET_RESPONSE(20480, "forget.response", NullMessage.class),
    FORGET_REQUEST_NO_RESET(131072, "forget.request.no.reset", ForgetRequest.class),
    FORGET_RESPONSE_NO_RESET(196608, "forget.response.no.reset", NullMessage.class),
    GET_REQUEST(24576, "get.request", BaseGetRequest.class),
    GET_RESPONSE(28672, "get.response", BaseGetResponse.class),
    NOTIFY_REQUEST(80, "notify.request", NotifyRequest.class),
    NOTIFY_REPLY(144, "notify.response", NotifyResponse.class),
    UPGRADE_REQUEST(32768, "upgrade.request", BaseUpgradeRequest.class),
    UPGRADE_RESPONSE(65536, "upgrade.response", BaseUpgradeResponse.class),
    REBUILD_REQUEST(36864, "rebuild.request", BaseRebuildRequest.class),
    REBUILD_RESPONSE(40960, "rebuild.response", BaseRebuildResponse.class),
    EVENT_PORTAL_QUERY(64, "portal.query", PortalQuery.class),
    EVENT_PORTAL_AUTH(128, "portal.auth", Authorization.class),
    EVENT_PORTAL_AUTH_RESPONSE(352, "portal.auth.response", NotifyResponse.class),
    PRE_CONNECT_INFO_RESPONSE(0x100000, "pre.connect.info.response", PreConnectInfoResponse.class),
    DEVICE_VERIFY_INFO(0x100001, "device.verify", DeviceVerifyInfo.class),
    DEVICE_VERIFY_RESPONSE(0x100002, "device.verify.response", DeviceVerifyResponse.class),
    SYSTEM_VERIFY_RESULT(0x100003, "system.verify.result", NullMessage.class),
    VERIFY_RESULT_ACK(0x100009, "verify.result.ack", NullMessage.class),
    DEVICE_NEGOTIATION(0x100004, "device.negotiation", BaseAdoptResponse.class),
    SYSTEM_NEGOTIATION(0x100005, "system.negotiation", BaseInitialSetSync.class),
    INIT_SYNC_RESULT(0x100006, "init.sync.result", NullMessage.class),
    INIT_SYNC_RESULT_ACK(0x10000A, "init.sync.result.ack", NullMessage.class),
    NOTIFY_REQUEST_V2(0x100007, "notify.request.v2", NotifyRequest.class),
    NOTIFY_REPLY_V2(0x100008, "notify.response.v2", NotifyResponse.class),
    UPGRADE_REQUEST_V2(69632, "upgrade.request.v2", BaseUpgradeRequest.class),
    UPGRADE_RESPONSE_V2(73728, "upgrade.response.v2", BaseUpgradeResponse.class),
    UPGRADE_NOTIFY_REQUEST(77824, "upgrade.notify.request", BaseUpgradeRequest.class),
    UPGRADE_NOTIFY_RESPONSE(81920, "upgrade.notify.response", BaseUpgradeResponse.class),
    REPORT(0x150000, "report", Report.class),
    FILE_TRANSFER_REQUEST_V2(0x160000, "file.request.v2", FileTransferRequest.class),
    FILE_TRANSFER_RESPONSE_V2(0x170000, "file.response.v2", FileTransferResponse.class),
    REBUILD_RESULT(86016, "rebuild.result", BaseConfigResponse.class);

    private static final Logger log;
    private final int value;
    private final String type;
    private final Class<? extends AbstractMessageBody> messageBodyClass;
    private static final Map<Integer, MessageType> typeMap;

    public static MessageType fromInteger(int value) {
        return typeMap.getOrDefault(value, UNKNOWN);
    }

    public static boolean isMessageBodyEmpty(MessageType messageType) {
        return INFORM_RESPONSE.equals((Object)messageType) || FORGET_REQUEST.equals((Object)messageType) || FORGET_REQUEST_NO_RESET.equals((Object)messageType) || FORGET_RESPONSE.equals((Object)messageType) || FORGET_RESPONSE_NO_RESET.equals((Object)messageType) || SYSTEM_VERIFY_RESULT.equals((Object)messageType) || VERIFY_RESULT_ACK.equals((Object)messageType) || INIT_SYNC_RESULT.equals((Object)messageType) || INIT_SYNC_RESULT_ACK.equals((Object)messageType);
    }

    public static boolean needPiiMessage(MessageType messageType) {
        return DISCOVERY.equals((Object)messageType) || PRE_CONNECT_INFO.equals((Object)messageType) || INFORM_REQUEST.equals((Object)messageType) || INFORM_RESPONSE.equals((Object)messageType) || SET_REQUEST.equals((Object)messageType) || SET_RESPONSE.equals((Object)messageType) || GET_REQUEST.equals((Object)messageType) || GET_RESPONSE.equals((Object)messageType) || NOTIFY_REQUEST.equals((Object)messageType) || NOTIFY_REQUEST_V2.equals((Object)messageType) || REBUILD_REQUEST.equals((Object)messageType) || REBUILD_RESPONSE.equals((Object)messageType) || REPORT.equals((Object)messageType);
    }

    public static boolean skipLog(Integer messageType) {
        return Objects.equals(INFORM_REQUEST.getValue(), messageType) || Objects.equals(INFORM_RESPONSE.getValue(), messageType);
    }

    public static boolean skipLog(MessageType messageType) {
        return INFORM_REQUEST.equals((Object)messageType) || INFORM_RESPONSE.equals((Object)messageType);
    }

    private MessageType(int value, String type, Class<? extends AbstractMessageBody> messageBodyClass) {
        this.value = value;
        this.type = type;
        this.messageBodyClass = messageBodyClass;
    }

    public int getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public Class<? extends AbstractMessageBody> getMessageBodyClass() {
        return this.messageBodyClass;
    }

    static {
        log = LoggerFactory.getLogger(MessageType.class);
        typeMap = new HashMap<Integer, MessageType>(32);
        for (MessageType type : MessageType.values()) {
            typeMap.put(type.getValue(), type);
        }
    }
}

