/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.protocol.packet;

import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.ecsp.protocol.packet.Message;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseInformRequest;
import com.tplink.smb.ecsp.protocol.packet.header.MessageHeader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformEcspMessage
implements Message {
    private static final Logger log = LoggerFactory.getLogger(InformEcspMessage.class);
    private MessageHeader header;
    private BaseInformRequest body;

    public InformEcspMessage(ByteBuffer byteBuffer) {
        this(StandardCharsets.UTF_8.decode(byteBuffer).toString());
    }

    public InformEcspMessage(String json) {
        InformEcspMessage informEcspMessage = JacksonUtils.json2Pojo(json, InformEcspMessage.class);
        this.header = informEcspMessage.header;
        this.body = informEcspMessage.body;
    }

    @Override
    public ByteBuffer pack() {
        return ByteBuffer.wrap(JacksonUtils.pojo2Json(this).getBytes());
    }

    protected InformEcspMessage(InformEcspMessageBuilder<?, ?> b) {
        this.header = b.header;
        this.body = b.body;
    }

    public static InformEcspMessageBuilder<?, ?> builder() {
        return new InformEcspMessageBuilderImpl();
    }

    public InformEcspMessageBuilder<?, ?> toBuilder() {
        return new InformEcspMessageBuilderImpl().$fillValuesFrom(this);
    }

    public String toString() {
        return "InformEcspMessage(header=" + this.getHeader() + ", body=" + this.getBody() + ")";
    }

    public MessageHeader getHeader() {
        return this.header;
    }

    public BaseInformRequest getBody() {
        return this.body;
    }

    public void setHeader(MessageHeader header) {
        this.header = header;
    }

    public void setBody(BaseInformRequest body) {
        this.body = body;
    }

    public InformEcspMessage() {
    }

    public InformEcspMessage(MessageHeader header, BaseInformRequest body) {
        this.header = header;
        this.body = body;
    }

    public static abstract class InformEcspMessageBuilder<C extends InformEcspMessage, B extends InformEcspMessageBuilder<C, B>> {
        private MessageHeader header;
        private BaseInformRequest body;

        protected B $fillValuesFrom(C instance) {
            InformEcspMessageBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(InformEcspMessage instance, InformEcspMessageBuilder<?, ?> b) {
            b.header(instance.header);
            b.body(instance.body);
        }

        public B header(MessageHeader header) {
            this.header = header;
            return this.self();
        }

        public B body(BaseInformRequest body) {
            this.body = body;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "InformEcspMessage.InformEcspMessageBuilder(header=" + this.header + ", body=" + this.body + ")";
        }
    }

    private static final class InformEcspMessageBuilderImpl
    extends InformEcspMessageBuilder<InformEcspMessage, InformEcspMessageBuilderImpl> {
        private InformEcspMessageBuilderImpl() {
        }

        @Override
        protected InformEcspMessageBuilderImpl self() {
            return this;
        }

        @Override
        public InformEcspMessage build() {
            return new InformEcspMessage(this);
        }
    }
}

